#ifndef _RFOLDWRAPPER_HPP_
#define _RFOLDWRAPPER_HPP_

#include <iostream>
#include "SafeVector.h"
#include "BPPMatrix.hpp"

// for Rfold
#include "rfold.hpp"
#include "opt.hpp"

using namespace::RFOLD;
using namespace std;

namespace MXSCARNA {
class RfoldWrapper {
public:
  SafeVector<BPPMatrix*> getProb(const SafeVector<string> &sequenceNames, const MultiSequence *sequences, float basePairingThreshold, int BandWidth) {
    // compute the base pairing matrices for each sequences
    Rfold folder;
    folder.set_command("COMPUTE_PROB");
    folder.set_max_pair_dist(BandWidth);
    folder.set_allow_non_canonical(false);
    folder.set_mea_separate_loop_type(false);
    folder.set_mea_outer_loop_coeff(1.25);
    // if (opt.get_bool("mea_inner_scale_by_outer")) {
    //   folder.set_mea_inner_loop_coeff(opt.get_dbl("mea_outer_loop_coeff")
    // 				    * opt.get_dbl("mea_inner_loop_coeff"));
    // } else {
    //   folder.set_mea_inner_loop_coeff(opt.get_dbl("mea_inner_loop_coeff"));
    // }
    folder.set_mea_inner_loop_coeff(0.9375);
    folder.set_print_prob(true);
    folder.set_print_loop_prob(false);
    folder.set_print_prob_cutoff(false);
    folder.set_constraint(false);
    folder.set_constraint_mea(false);
    Model::FeatureCounter fc;
    fc.set_default_params();
    Array<ScoreT> pv0(fc.param_vector());
    pv0 = fc.param_vector();
    fc.set_param_vector(pv0);
    folder.set_param_vector(pv0);
    folder.set_print_prob(true);
    ofstream f_prob;
    folder.set_f_prob(&f_prob);
    //  if (!f_prob.is_open()) {
    //    f_prob.open(opt.get_str("prob_file").c_str());
    //    Check(f_prob, "cannot open probfile %s", opt.get_str("prob_file").c_str());
    //  }
    //  folder.set_f_prob(&f_prob);
    SafeVector<BPPMatrix*> BPPMatrices;
    int m = 0;
    for (int i = 0; i < (int)sequenceNames.size(); i++) {
      string name = sequenceNames[i];
      ifstream fseq(name.c_str());
      //    Check(fseq, "cannot open seqfile %s", opt.get_str("seqfile").c_str());
      SeqFile seq_file("rfold_sequence.txt");
      while (seq_file.read_fasta(fseq)) {
	folder.set_seq(seq_file);
	if (seq_file.has_ct()) {
	  //	if (max_pair_dist >= 0) {// modify ct
	  //	  seq_file.ct().remove_distant_pairs(max_pair_dist);
	  //	}
	  //	if (!allow_non_canonical_pairs) {
	  if (false) {
	    seq_file.remove_non_canonical_pairs();
	  }
	  folder.set_ct_constr(seq_file.ct());
	}
	folder.run();
	int seqLength = sequences->GetSequence(m)->GetLength();
	Trimat<float> tmpBppMat(seqLength + 1);
	for (int j = 0; j < (int)folder.left.size(); j++) {
	  tmpBppMat.ref(folder.left[j], folder.right[j]) = folder.score[j];
	}
	folder.left.clear();
	folder.right.clear();
	folder.score.clear();
	BPPMatrix *bppmat = new BPPMatrix(seqLength, basePairingThreshold, tmpBppMat);
	BPPMatrices.push_back(bppmat);
	// ScoreT dp_score = folder.dp_score();
	// string sscons = folder.sscons();
	// fo << "---\n";
	// fo << "dp_score: " << dp_score << "\n";
	// cout << "dp_score: " << dp_score << endl;
	m++;
      }
    }
    return BPPMatrices;
  }
};
}
#endif // _RFOLDWRAPPER_HPP_
