/*
 * Vector.hpp
 *
 */
#ifndef VECTOR_HPP
#define VECTOR_HPP
#include <vector>

namespace RFOLD {

template <typename T>
class Vector : private std::vector<T> {
  typedef std::vector<T> Super;
  typedef Vector<T> Self;
public:
  //type definitions
  using Super::value_type;
  using Super::iterator;
  using Super::const_iterator;
  using Super::reference;
  using Super::const_reference;
  using Super::size_type;
  using Super::difference_type;
 
  Vector() : Super() {}
  explicit Vector(unsigned int initSize, const T& t = T())
    : Super(initSize, t) {}
  template <typename InpIt>
  Vector(InpIt first, InpIt last) : Super(first, last) {}
  Vector(const Vector& v) : Super(v) {}
  ~Vector() {}
  Vector& operator=(const Vector& v) {
    Super::operator=(v); return *this;
  }

  using Super::size;
  using Super::empty;
  using Super::clear;
  using Super::resize;
  using Super::begin;
  using Super::end;
  using Super::front;
  using Super::back;
  using Super::erase;
  using Super::push_back;
  using Super::pop_back;
  using Super::assign;
  //using Super::insert;
  template <typename InpIt>
  void assign(InpIt first, InpIt last) {Super::assign(first, last);}
  template <typename InpIt>
  void insert(typename Self::iterator position, InpIt first, InpIt last) {
    Super::insert(position, first, last);
  }
  T& get(unsigned int i) {
    Assert(i < Super::size()); return Super::operator[](i);
  }
  const T& get(unsigned int i) const {
    Assert(i < Super::size()); return Super::operator[](i);
  }
  T& operator[](unsigned int i) {return get(i);}
  const T& operator[](unsigned int i) const {return get(i);}

  //void removeAt(unsigned int pos, unsigned int len = 1) {
  //  Assert(0 <= pos && pos <= size() && 0 <= len);
  //  erase(begin() + pos, begin() + pos + len);
  //}
  void fill(const T& t) {std::fill(Super::begin(), Super::end(), t);}
  int indexOf(const T* p) const {return (p - &Super::front());}
  string toString() const;
  void print() const;
};
}

namespace RFOLD {
template <typename T>
string
Vector<T>::
toString() const
{
  ostringstream oss;
  transform(Self::begin(), Self::end(),
	    ostream_iterator<string>(oss, "\n"),
	    mem_fun_ref(&T::toString));
  return oss.str();
}
}
namespace RFOLD {
template <typename T>
void
Vector<T>::
print() const
{
  cout << toString() << flush;
}
}
#endif
