/*
 * score.hpp
 */
#ifndef SCORE_HPP
#define SCORE_HPP

namespace RFOLD {
#ifdef USE_FLOAT_SCORE
typedef float ScoreT;
inline ScoreT NEG_INF() {return -2.0e20;}
#else
typedef double ScoreT;
inline ScoreT NEG_INF() {return -1.0e60;}
#endif

inline ScoreT LOG_PROB_THRESHOLD() {return 0.1 * NEG_INF();}
inline bool
possible(ScoreT val)
{
  return (val > LOG_PROB_THRESHOLD());
}
inline bool
impossible(ScoreT val)
{
  return (val <= LOG_PROB_THRESHOLD());
}
inline void
logadd(ScoreT& z, const ScoreT& z1)
{
  enum {CUTOFF = 50};
  if (impossible(z1)) return;

  const ScoreT& d = (z - z1);
  if (0 < d) {
    if (d < CUTOFF) {
      z += std::log(1 + std::exp(-d));
    }
  } else {
    z = z1;
    if (-CUTOFF < d) {
      z += std::log(1 + std::exp(d));
    }
  }
}
inline void LOGADD(ScoreT &z, const ScoreT &z1) { logadd(z, z1); }
}
//#define LOGADD(x, y) logadd((x), (y))
#define EXP(x) std::exp(x)

#endif
