/*
 * alpha.cpp
 *
 */
#include "alpha.hpp"

namespace RFOLD {
const Alpha::CodeTypeToStrs 
Alpha::CODE_TYPE_TO_STRS = {{
  "NCODE_TYPE", "PCODE_TYPE", "SCODE_TYPE", "BAD_CODE_TYPE"
}};

/* base codes
 * a = A = N_A = 0, c = C = N_C = 1, g = G = N_G = 2, t = T = u = U = N_U = 3
 * N R Y M K S W H B V D and X (and their lower case chars)
 * as ambiguous chars (= N_N = 4)
 * '.', '-', '_', and '~' are regarded as gap chars (= N_GAP = 5)
 * other characters are invalid (= N_BAD = 6)
 */
const Alpha::CharToNCode
Alpha::CHAR_TO_NCODE = {{
#define A N_A
#define C N_C
#define G N_G
#define U N_U
#define N N_N
#define g N_GAP
#define _ N_BAD
 _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
 _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
 _, _, _, _, _, _, _, _, _, _, _, _, _, g, g, _,
 _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
 _, A, N, C, N, _, _, G, N, _, _, N, _, N, N, _,
 _, _, N, N, U, U, N, N, N, N, _, _, _, _, _, g,
 _, A, N, C, N, _, _, G, N, _, _, N, _, N, N, _,
 _, _, N, N, U, U, N, N, N, N, _, _, _, _, g, _,
 _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
 _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
 _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
 _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
 _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
 _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
 _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
 _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _,
#undef A
#undef C
#undef G
#undef U
#undef N
#undef g
#undef _
}};
const Alpha::NCodeToChar
Alpha::NCODE_TO_CHAR = {{
  'A', 'C', 'G', 'U', 'N', '.', '?'
}};
const Alpha::NCodeToStrs
Alpha::NCODE_TO_STRS = {{
  "A", "C", "G", "U", "N", ".", "?"
}};
const string
Alpha::BASE_CHARS = "ACGU";
const string
Alpha::GAP_CHARS = ".-_~";
const string
Alpha::AMB_CHARS = "NRYMKSWHBVDXnrymkswhbvdx";

const Alpha::PCodeToStrs
Alpha::PCODE_TO_STRS = {{
  "AA", "AC", "AG", "AU",
  "CA", "CC", "CG", "CU",
  "GA", "GC", "GG", "GU",
  "UA", "UC", "UG", "UU",
  "NN", "..", "??"
}};
const Alpha::NCode2ToPCode
Alpha::NCODE2_TO_PCODE = {{
{{P_AA, P_AC, P_AG, P_AU, P_NN, P_GAP, P_BAD}},
{{P_CA, P_CC, P_CG, P_CU, P_NN, P_GAP, P_BAD}},
{{P_GA, P_GC, P_GG, P_GU, P_NN, P_GAP, P_BAD}},
{{P_UA, P_UC, P_UG, P_UU, P_NN, P_GAP, P_BAD}},
{{P_NN, P_NN, P_NN, P_NN, P_NN, P_GAP, P_BAD}},
{{P_GAP,P_GAP,P_GAP,P_GAP,P_GAP,P_GAP, P_BAD}},
{{P_BAD,P_BAD,P_BAD,P_BAD,P_BAD,P_BAD, P_BAD}}
}};
const Alpha::PCodeToNCode2
Alpha::PCODE_TO_NCODE2 = {{
  {{N_A, N_A}}, {{N_A, N_C}}, {{N_A, N_G}}, {{N_A, N_U}},
  {{N_C, N_A}}, {{N_C, N_C}}, {{N_C, N_G}}, {{N_C, N_U}},
  {{N_G, N_A}}, {{N_G, N_C}}, {{N_G, N_G}}, {{N_G, N_U}},
  {{N_U, N_A}}, {{N_U, N_C}}, {{N_U, N_G}}, {{N_U, N_U}},
  {{N_N, N_N}}, {{N_GAP, N_GAP}}, {{N_BAD, N_BAD}}
}};
const Alpha::FlipPCode 
Alpha::FLIP_PCODE = {{
  P_AA, P_CA, P_GA, P_UA,
  P_AC, P_CC, P_GC, P_UC,
  P_AG, P_CG, P_GG, P_UG,
  P_AU, P_CU, P_GU, P_UU,
  P_NN, P_GAP,P_BAD
}};

const Alpha::SCodeToStrs 
Alpha::SCODE_TO_STRS = {{
  "AU", "CG", "GC", "GU", "UA", "UG", "MM", "NN", "..", "??"
}};
const Alpha::NCode2ToSCode 
Alpha::NCODE2_TO_SCODE = {{
  {{S_MM, S_MM, S_MM, S_AU, S_NN, S_GAP, S_BAD}},
  {{S_MM, S_MM, S_CG, S_MM, S_NN, S_GAP, S_BAD}},
  {{S_MM, S_GC, S_MM, S_GU, S_NN, S_GAP, S_BAD}},
  {{S_UA, S_MM, S_UG, S_MM, S_NN, S_GAP, S_BAD}},
  {{S_NN, S_NN, S_NN, S_NN, S_NN, S_GAP, S_BAD}},
  {{S_GAP,S_GAP,S_GAP,S_GAP,S_GAP,S_GAP, S_BAD}},
  {{S_BAD,S_BAD,S_BAD,S_BAD,S_BAD,S_BAD, S_BAD}}
}};
const Alpha::SCodeToNCode2 
Alpha::SCODE_TO_NCODE2 = {{
  {{N_A, N_U}}, {{N_C, N_G}}, {{N_G, N_C}}, {{N_G, N_U}},
  {{N_U, N_A}}, {{N_U, N_G}}, {{N_N, N_N}}, {{N_N, N_N}},
  {{N_GAP, N_GAP}}, {{N_BAD, N_BAD}}
}};
const Alpha::FlipSCode 
Alpha::FLIP_SCODE = {{
  S_UA, S_GC, S_CG, S_UG, S_AU, S_GU,
  S_MM, S_NN, S_GAP,S_BAD
}};
const Alpha::PCodeToSCode 
Alpha::PCODE_TO_SCODE = {{
  S_MM, S_MM, S_MM, S_AU,
  S_MM, S_MM, S_CG, S_MM,
  S_MM, S_GC, S_MM, S_GU,
  S_UA, S_MM, S_UG, S_MM,
  S_NN, S_GAP,S_BAD
}};
}
