/*
 * array_ring.hpp
 */
#ifndef ARRAY_RING_HPP
#define ARRAY_RING_HPP

namespace RFOLD {
template <typename T, typename Data = Array<T> >
class ArrayRing {
public:
  typedef typename Data::value_type value_type;
  typedef typename Data::iterator iterator;
  typedef typename Data::const_iterator const_iterator;
  typedef typename Data::reference reference;
  typedef typename Data::const_reference const_reference;
  typedef typename Data::size_type size_type;
  typedef typename Data::difference_type difference_type;

  ArrayRing() : _nlayer(0), _length(0) {}
  ArrayRing(const ArrayRing& other) 
    : _data(other._data), _nlayer(other._nlayer), _length(other._length) {}
  ~ArrayRing() {}
  bool empty() const {return _data.empty();}
  int size() const {return _data.size();}
  int nlayer() const {return _nlayer;}
  int length() const {return _length;}
  void set_size(int nlayer, int length) {
    Check(nlayer >= 0 && length >= 0);
    _nlayer = nlayer;
    _length = length;
    _data.resize(_nlayer * _length);
  }
  const_reference get(int s, int i) const {return _data[get_index(s, i)];}
  void set(int s, int i, const_reference val) {_data[get_index(s, i)] = val;}
  void add(int s, int i, const_reference val) {_data[get_index(s, i)] += val;}
  void logadd(int s, int i, const_reference val){LOGADD(_data[get_index(s, i)], val);}
  const_iterator iter(int s, int i) const {return (_data.begin() + get_index(s, i));}
  void fill(const_reference val) {_data.fill(val);}
  void clear() {_data.clear(); _nlayer = 0; _length = 0;}
  int get_index(int s, int i) const {
    Assert((0 <= s && s < _nlayer && 0 < _length), 
	   "[%d,%d] out of range [%d,%d]", s, i, _nlayer, _length);
    return (s * _length + (i % _length));
  }
  string to_s() const {return "";}
  void print() const {cout << to_s() << flush;}
private:
  Data _data;
  int _nlayer;
  int _length;
};
}
#endif
