/*
 * Opt.hpp
 *
 */
#ifndef OPT_HPP
#define OPT_HPP

#include <string>
#include <map>
#include <iostream>
using std::string;
using std::map;
using std::ostream;
using std::istream;

namespace RFOLD {
class Opt {
public:
  enum ArgumentType {
    NO_ARGUMENT       = 0,
    REQUIRED_ARGUMENT = 1
  };
  struct Entry {
    const char* name;
    int type;
    const char* dflt;
  };
  Opt(const Entry* const opt_table);
  ~Opt();
  void set_value(const string& key, const string& value);
  void set_from_file(const string& filename);
  void set_from_args(int& argc, char**& argv);
  const string& get_str(const string& name) const;
  int get_int(const string& name) const;
  double get_dbl(const string& name) const;
  bool get_bool(const string& name) const;
  void check_int_lower_bound(const string& name, int min_value) const;
  void check_int_upper_bound(const string& name, int max_value) const;
  void check_int_range(const string& name, int min_value, int max_value) const;
  void check_dbl_lower_bound(const string& name, double min_value) const;
  void check_dbl_upper_bound(const string& name, double max_value) const;
  void check_dbl_range(const string& name,
			double min_value, double max_value) const;
  void check_str_entry(const string& name, const string& entries) const;
  void print_header(ostream& fo) const;
  void print_yaml(ostream& fo) const;
  void set_from_yaml(istream& fi);
  string to_s() const;
  void print() const;

private:
  struct EntryData {
    EntryData(); 
    EntryData(const Entry& entry);
    EntryData(const EntryData& entry_data);
    ~EntryData();
    EntryData& operator=(const EntryData& entry_data);

    bool required_argument() const {return type == Opt::REQUIRED_ARGUMENT;}
    bool value_is_set() const {return val_is_set;}
    void set_value(const string& value0);
    const string& get_name() const {return name;}
    const string& get_value() const;
    string to_s() const;
    void print() const;
  private:
    string name;
    int type;
    string dflt;
    string value;
    bool val_is_set;
  };
  typedef map<string, EntryData> Table;
  string fname;
  Table table;

  bool has_key(const string& name) const;
};
}
#endif
