/*
 * Util.hpp
 *
 */
#ifndef __UTIL_HPP__
#define __UTIL_HPP__

#include <cstdio>
#include <cstdlib>
#include <cstdarg>
#include <cmath>
#include <cctype>
#include <climits>
#include <cfloat>

#include <iostream>
#include <fstream>
#include <iomanip>
#include <sstream>

#include <string>
#include <vector>
#include <list>
#include <map>

#include <algorithm>
#include <functional>
#include <iterator>
#include <numeric>
#include <limits>

using namespace std;

namespace RFOLD {
class Break {
public:
  static int Here()  {static volatile int a; return a;}
  static int Here1() {static volatile int a; return a;}
  static int Here2() {static volatile int a; return a;}
  static int Here3() {static volatile int a; return a;}
  static int Here4() {static volatile int a; return a;}
  static int Here5() {static volatile int a; return a;}
  static int Here6() {static volatile int a; return a;}
  static int Here7() {static volatile int a; return a;}
  static int Here8() {static volatile int a; return a;}
  static int Here9() {static volatile int a; return a;}
};

#define _ERR_MSG_() do {                                   \
  fprintf(stderr, "  in %s at %s:%d\n", func, file, line); \
  if (format != NULL && *format != '\0') {		   \
    fprintf(stderr, "  ");				   \
    va_list ap;						   \
    va_start(ap, format);				   \
    vfprintf(stderr, format, ap);			   \
    va_end(ap);						   \
    fprintf(stderr, "\n");				   \
  }							   \
  fflush(stderr);                                          \
} while (0)
  
#define Warn(...) \
Warn_(__PRETTY_FUNCTION__, __FILE__, __LINE__, ""__VA_ARGS__)
inline void
Warn_(const char* func, const char* file, const int line,
      const char* format, ...)
{
  fprintf(stderr, "---\nwarning:\n");
  _ERR_MSG_();
  Break::Here();
}
#define Die(...) \
Die_(__PRETTY_FUNCTION__, __FILE__, __LINE__, ""__VA_ARGS__)

inline void
Die_(const char* func, const char* file, const int line,
     const char* format, ...)
{
  fprintf(stderr, "---\nerror:\n");
  _ERR_MSG_();
  Break::Here();
  exit(EXIT_FAILURE);
}

#ifdef DEBUG
#define Assert(expr, ...) \
Assert_(__PRETTY_FUNCTION__, __FILE__, __LINE__,(expr), #expr , "" __VA_ARGS__)
#else
#define Assert(expr, ...) 
#endif

inline void
Assert_(const char* func, const char* file, const int line,
	bool value, const char* expr, const char* format, ...)
{
#ifdef DEBUG
  if (value) return;

  fprintf(stderr, "---\nerror:\n  Assertion (%s) failed.\n", expr);
  _ERR_MSG_();
  Break::Here();
  exit(EXIT_FAILURE);
#endif
}
#define Check(expr, ...) \
Check_(__PRETTY_FUNCTION__, __FILE__, __LINE__, (expr), #expr , "" __VA_ARGS__)

inline void
Check_(const char* func, const char* file, const int line,
       bool value, const char* expr, const char* format, ...)
{
  if (value) return;

  fprintf(stderr, "---\nerror:\n  Check (%s) failed.\n", expr);
  _ERR_MSG_();
  Break::Here();
  exit(EXIT_FAILURE);
}
}
#include "Vector.hpp"
#include "array.hpp"
// #include "int_pairs.hpp"
#include "matrix.hpp"
namespace RFOLD {
template<typename T>
Vector<T>
tokenize(const string& str)
{
  istringstream iss(str);
  return Vector<T>(istream_iterator<T>(iss), istream_iterator<T>());
}
inline int
Rand(int n)
{
  const double& z = rand() / (1.0 + (double) RAND_MAX);
  return (int) (n * z);
}
template <typename T>
class Series {
public:
  Series(const T& start) : next(start) {}
  T operator()() {return next++;}
private:
  T next;
};
class StringTokenizer {
public:
  StringTokenizer(const string& str, const string& delim = " \f\r\n\t\v")
    : str(str), delim(delim), pos(0) {}
  ~StringTokenizer() {}
   string next_token() {
     return next_token(delim);
   }
  string next_token(const string& delim1) {
    const string::size_type& pos0 = str.find_first_not_of(delim1, pos);
    if (pos0 == string::npos) return "";

    pos = str.find_first_of(delim1, pos0);
    return (pos == string::npos
	    ? str.substr(pos0) 
	    : str.substr(pos0, (pos++) - pos0));
  }
  bool has_more_tokens() const {
    return (str.find_first_not_of(delim, pos) != string::npos);
  }
private:
  const string str;
  const string delim;
  string::size_type pos;
};
inline std::string
indent(const std::string& str0, int n)
{
  const std::string indent_str(n, ' ');
  const std::string nl = "\n";
  std::istringstream iss(str0);
  std::ostringstream oss;
  std::string buf;
  while (std::getline(iss, buf)) {
    oss << indent_str << buf << nl;
  }
  return oss.str();
}
}
#endif
