/*
 * energy_model_default_params.hpp
 *   Energy parameters extracted from RNAalifold program of Vienna package (version 1.5)
 *   Reference: 
 *    Secondary structure prediction for aligned RNA sequences.
 *    Ivo L Hofacker and  Martin Fekete and  Peter F Stadler
 *    J Mol Biol. 2002 vol 319 (18) 3724-32
 */
#ifndef ENERGY_MODEL_DEFAULT_PARAMS
#define ENERGY_MODEL_DEFAULT_PARAMS
/* 
   Current free energy parameters are summarized in:

   D.H.Mathews, J. Sabina, M. ZUker, D.H. Turner
   "Expanded sequence dependence of thermodynamic parameters improves
   prediction of RNA secondary structure"
   JMB, 288, pp 911-940, 1999

   Enthalpies taken from:
    
   A. Walter, D Turner, J Kim, M Lyttle, P M"uller, D Mathews, M Zuker
   "Coaxial stckaing of helices enhances binding of oligoribonucleotides.."
   PNAS, 91, pp 9218-9222, 1994
    
   D.H. Turner, N. Sugimoto, and S.M. Freier.
   "RNA Structure Prediction",
   Ann. Rev. Biophys. Biophys. Chem. 17, 167-192, 1988.

   John A.Jaeger, Douglas H.Turner, and Michael Zuker.
   "Improved predictions of secondary structures for RNA",
   PNAS, 86, 7706-7710, October 1989.
    
   L. He, R. Kierzek, J. SantaLucia, A.E. Walter, D.H. Turner
   "Nearest-Neughbor Parameters for GU Mismatches...."
   Biochemistry 1991, 30 11124-11132

   A.E. Peritz, R. Kierzek, N, Sugimoto, D.H. Turner
   "Thermodynamic Study of Internal Loops in Oligoribonucleotides..."
   Biochemistry 1991, 30, 6428--6435
*/

namespace RFOLD{
}
const string
EnergyModel::FeatureCounter::
DEFAULT_PARAMS =
"large_loop_factor 1.07856\n"
"multiloop_offset 3.8\n"
"multiloop_nuc 0.0\n"
"multiloop_helix 0.4\n"
"hairpinloop_change_0 10000.0\n"
"hairpinloop_change_1 0.0\n"
"hairpinloop_change_2 0.0\n"
"hairpinloop_change_3 -9994.3\n"
"hairpinloop_change_4 -0.1\n"
"hairpinloop_change_5 0.0\n"
"hairpinloop_change_6 -0.2\n"
"hairpinloop_change_7 0.5\n"
"hairpinloop_change_8 -0.3\n"
"hairpinloop_change_9 0.8\n"
"hairpinloop_change_10 0.1\n"
"hairpinloop_change_11 0.1\n"
"hairpinloop_change_12 0.1\n"
"hairpinloop_change_13 0.08\n"
"hairpinloop_change_14 0.08\n"
"hairpinloop_change_15 0.08\n"
"hairpinloop_change_16 0.07\n"
"hairpinloop_change_17 0.06\n"
"hairpinloop_change_18 0.06\n"
"hairpinloop_change_19 0.06\n"
"hairpinloop_change_20 0.06\n"
"hairpinloop_change_21 0.05\n"
"hairpinloop_change_22 0.05\n"
"hairpinloop_change_23 0.05\n"
"hairpinloop_change_24 0.04\n"
"hairpinloop_change_25 0.05\n"
"hairpinloop_change_26 0.04\n"
"hairpinloop_change_27 0.04\n"
"hairpinloop_change_28 0.04\n"
"hairpinloop_change_29 0.04\n"
"hairpinloop_change_30 0.04\n"
"bulgeloop_change_0 10000.0\n"
"bulgeloop_change_1 -9996.2\n"
"bulgeloop_change_2 -1.0\n"
"bulgeloop_change_3 0.4\n"
"bulgeloop_change_4 0.4\n"
"bulgeloop_change_5 0.4\n"
"bulgeloop_change_6 0.4\n"
"bulgeloop_change_7 0.19\n"
"bulgeloop_change_8 0.11\n"
"bulgeloop_change_9 0.1\n"
"bulgeloop_change_10 0.1\n"
"bulgeloop_change_11 0.1\n"
"bulgeloop_change_12 0.1\n"
"bulgeloop_change_13 0.09\n"
"bulgeloop_change_14 0.08\n"
"bulgeloop_change_15 0.07\n"
"bulgeloop_change_16 0.07\n"
"bulgeloop_change_17 0.07\n"
"bulgeloop_change_18 0.06\n"
"bulgeloop_change_19 0.06\n"
"bulgeloop_change_20 0.05\n"
"bulgeloop_change_21 0.06\n"
"bulgeloop_change_22 0.05\n"
"bulgeloop_change_23 0.04\n"
"bulgeloop_change_24 0.05\n"
"bulgeloop_change_25 0.04\n"
"bulgeloop_change_26 0.05\n"
"bulgeloop_change_27 0.04\n"
"bulgeloop_change_28 0.04\n"
"bulgeloop_change_29 0.03\n"
"bulgeloop_change_30 0.04\n"
"internalloop_change_0 10000.0\n"
"internalloop_change_1 0.0\n"
"internalloop_change_2 -9995.9\n"
"internalloop_change_3 1.0\n"
"internalloop_change_4 -3.4\n"
"internalloop_change_5 0.1\n"
"internalloop_change_6 0.2\n"
"internalloop_change_7 0.2\n"
"internalloop_change_8 0.1\n"
"internalloop_change_9 0.1\n"
"internalloop_change_10 0.1\n"
"internalloop_change_11 0.1\n"
"internalloop_change_12 0.1\n"
"internalloop_change_13 0.08\n"
"internalloop_change_14 0.08\n"
"internalloop_change_15 0.08\n"
"internalloop_change_16 0.07\n"
"internalloop_change_17 0.06\n"
"internalloop_change_18 0.06\n"
"internalloop_change_19 0.06\n"
"internalloop_change_20 0.06\n"
"internalloop_change_21 0.05\n"
"internalloop_change_22 0.05\n"
"internalloop_change_23 0.05\n"
"internalloop_change_24 0.05\n"
"internalloop_change_25 0.04\n"
"internalloop_change_26 0.04\n"
"internalloop_change_27 0.04\n"
"internalloop_change_28 0.04\n"
"internalloop_change_29 0.04\n"
"internalloop_change_30 0.04\n"
"internalloop_asymmetry_0 0.0\n"
"internalloop_asymmetry_1 0.5\n"
"internalloop_asymmetry_2 0.5\n"
"internalloop_asymmetry_3 0.5\n"
"internalloop_asymmetry_4 0.5\n"
"internalloop_asymmetry_5 0.5\n"
"internalloop_asymmetry_6 0.5\n"
"internalloop_asymmetry_7 0.0\n"
"internalloop_asymmetry_8 0.0\n"
"internalloop_asymmetry_9 0.0\n"
"internalloop_asymmetry_10 0.0\n"
"internalloop_asymmetry_11 0.0\n"
"internalloop_asymmetry_12 0.0\n"
"internalloop_asymmetry_13 0.0\n"
"internalloop_asymmetry_14 0.0\n"
"internalloop_asymmetry_15 0.0\n"
"internalloop_asymmetry_16 0.0\n"
"internalloop_asymmetry_17 0.0\n"
"internalloop_asymmetry_18 0.0\n"
"internalloop_asymmetry_19 0.0\n"
"internalloop_asymmetry_20 0.0\n"
"internalloop_asymmetry_21 0.0\n"
"internalloop_asymmetry_22 0.0\n"
"internalloop_asymmetry_23 0.0\n"
"internalloop_asymmetry_24 0.0\n"
"internalloop_asymmetry_25 0.0\n"
"internalloop_asymmetry_26 0.0\n"
"internalloop_asymmetry_27 0.0\n"
"internalloop_asymmetry_28 0.0\n"
"internalloop_asymmetry_29 0.0\n"
"internalloop_asymmetry_30 0.0\n"
"terminal_base_pair_AU 0.5\n"
"terminal_base_pair_CG 0.0\n"
"terminal_base_pair_GC 0.0\n"
"terminal_base_pair_GU 0.5\n"
"terminal_base_pair_UA 0.5\n"
"terminal_base_pair_UG 0.5\n"
"dangle3_AUA -0.8\n"
"dangle3_AUC -0.5\n"
"dangle3_AUG -0.8\n"
"dangle3_AUU -0.6\n"
"dangle3_CGA -1.7\n"
"dangle3_CGC -0.8\n"
"dangle3_CGG -1.7\n"
"dangle3_CGU -1.2\n"
"dangle3_GCA -1.1\n"
"dangle3_GCC -0.4\n"
"dangle3_GCG -1.3\n"
"dangle3_GCU -0.6\n"
"dangle3_GUA -0.8\n"
"dangle3_GUC -0.5\n"
"dangle3_GUG -0.8\n"
"dangle3_GUU -0.6\n"
"dangle3_UAA -0.7\n"
"dangle3_UAC -0.1\n"
"dangle3_UAG -0.7\n"
"dangle3_UAU -0.1\n"
"dangle3_UGA -0.7\n"
"dangle3_UGC -0.1\n"
"dangle3_UGG -0.7\n"
"dangle3_UGU -0.1\n"
"dangle5_AUA -0.3\n"
"dangle5_AUC -0.1\n"
"dangle5_AUG -0.2\n"
"dangle5_AUU -0.2\n"
"dangle5_CGA -0.2\n"
"dangle5_CGC -0.3\n"
"dangle5_CGG 0.0\n"
"dangle5_CGU 0.0\n"
"dangle5_GCA -0.5\n"
"dangle5_GCC -0.3\n"
"dangle5_GCG -0.2\n"
"dangle5_GCU -0.1\n"
"dangle5_GUA -0.3\n"
"dangle5_GUC -0.1\n"
"dangle5_GUG -0.2\n"
"dangle5_GUU -0.2\n"
"dangle5_UAA -0.3\n"
"dangle5_UAC -0.3\n"
"dangle5_UAG -0.4\n"
"dangle5_UAU -0.2\n"
"dangle5_UGA -0.3\n"
"dangle5_UGC -0.3\n"
"dangle5_UGG -0.4\n"
"dangle5_UGU -0.2\n"
"stack_AUAU -1.1\n"
"stack_AUCG -2.1\n"
"stack_AUGC -2.2\n"
"stack_AUGU -1.4\n"
"stack_AUUA -0.9\n"
"stack_AUUG -0.6\n"
"stack_CGCG -2.4\n"
"stack_CGGC -3.3\n"
"stack_CGGU -2.1\n"
"stack_CGUA -2.1\n"
"stack_CGUG -1.4\n"
"stack_GCGC -3.4\n"
"stack_GCGU -2.5\n"
"stack_GCUA -2.4\n"
"stack_GCUG -1.5\n"
"stack_GUGU 1.3\n"
"stack_GUUA -1.3\n"
"stack_GUUG -0.5\n"
"stack_UAUA -1.3\n"
"stack_UAUG -1.0\n"
"stack_UGUG 0.3\n"
"tstackh_AUAA -0.3\n"
"tstackh_AUAC -0.5\n"
"tstackh_AUAG -0.3\n"
"tstackh_AUAU -0.3\n"
"tstackh_AUCA -0.1\n"
"tstackh_AUCC -0.2\n"
"tstackh_AUCG -1.5\n"
"tstackh_AUCU -0.2\n"
"tstackh_AUGA -1.1\n"
"tstackh_AUGC -1.2\n"
"tstackh_AUGG -0.2\n"
"tstackh_AUGU 0.2\n"
"tstackh_AUUA -0.3\n"
"tstackh_AUUC -0.3\n"
"tstackh_AUUG -0.6\n"
"tstackh_AUUU -1.1\n"
"tstackh_CGAA -1.5\n"
"tstackh_CGAC -1.5\n"
"tstackh_CGAG -1.4\n"
"tstackh_CGAU -1.8\n"
"tstackh_CGCA -1.0\n"
"tstackh_CGCC -0.9\n"
"tstackh_CGCG -2.9\n"
"tstackh_CGCU -0.8\n"
"tstackh_CGGA -2.2\n"
"tstackh_CGGC -2.0\n"
"tstackh_CGGG -1.6\n"
"tstackh_CGGU -1.1\n"
"tstackh_CGUA -1.7\n"
"tstackh_CGUC -1.4\n"
"tstackh_CGUG -1.8\n"
"tstackh_CGUU -2.0\n"
"tstackh_GCAA -1.1\n"
"tstackh_GCAC -1.5\n"
"tstackh_GCAG -1.3\n"
"tstackh_GCAU -2.1\n"
"tstackh_GCCA -1.1\n"
"tstackh_GCCC -0.7\n"
"tstackh_GCCG -2.4\n"
"tstackh_GCCU -0.5\n"
"tstackh_GCGA -2.4\n"
"tstackh_GCGC -2.9\n"
"tstackh_GCGG -1.4\n"
"tstackh_GCGU -1.2\n"
"tstackh_GCUA -1.9\n"
"tstackh_GCUC -1.0\n"
"tstackh_GCUG -2.2\n"
"tstackh_GCUU -1.5\n"
"tstackh_GUAA 0.2\n"
"tstackh_GUAC -0.5\n"
"tstackh_GUAG -0.3\n"
"tstackh_GUAU -0.3\n"
"tstackh_GUCA -0.1\n"
"tstackh_GUCC -0.2\n"
"tstackh_GUCG -1.5\n"
"tstackh_GUCU -0.2\n"
"tstackh_GUGA -0.9\n"
"tstackh_GUGC -1.1\n"
"tstackh_GUGG -0.3\n"
"tstackh_GUGU 0.0\n"
"tstackh_GUUA -0.3\n"
"tstackh_GUUC -0.3\n"
"tstackh_GUUG -0.4\n"
"tstackh_GUUU -1.1\n"
"tstackh_UAAA -0.5\n"
"tstackh_UAAC -0.3\n"
"tstackh_UAAG -0.6\n"
"tstackh_UAAU -0.5\n"
"tstackh_UACA -0.2\n"
"tstackh_UACC -0.1\n"
"tstackh_UACG -1.2\n"
"tstackh_UACU 0.0\n"
"tstackh_UAGA -1.4\n"
"tstackh_UAGC -1.2\n"
"tstackh_UAGG -0.7\n"
"tstackh_UAGU -0.2\n"
"tstackh_UAUA -0.3\n"
"tstackh_UAUC -0.1\n"
"tstackh_UAUG -0.5\n"
"tstackh_UAUU -0.8\n"
"tstackh_UGAA -0.5\n"
"tstackh_UGAC -0.3\n"
"tstackh_UGAG -0.6\n"
"tstackh_UGAU -0.5\n"
"tstackh_UGCA -0.2\n"
"tstackh_UGCC -0.1\n"
"tstackh_UGCG -1.7\n"
"tstackh_UGCU 0.0\n"
"tstackh_UGGA -0.8\n"
"tstackh_UGGC -1.2\n"
"tstackh_UGGG -0.3\n"
"tstackh_UGGU -0.7\n"
"tstackh_UGUA -0.6\n"
"tstackh_UGUC -0.1\n"
"tstackh_UGUG -0.6\n"
"tstackh_UGUU -0.8\n"
"tstacki_AUAA 0.7\n"
"tstacki_AUAC 0.7\n"
"tstacki_AUAG -0.4\n"
"tstacki_AUAU 0.7\n"
"tstacki_AUCA 0.7\n"
"tstacki_AUCC 0.7\n"
"tstacki_AUCG 0.7\n"
"tstacki_AUCU 0.7\n"
"tstacki_AUGA -0.4\n"
"tstacki_AUGC 0.7\n"
"tstacki_AUGG 0.7\n"
"tstacki_AUGU 0.7\n"
"tstacki_AUUA 0.7\n"
"tstacki_AUUC 0.7\n"
"tstacki_AUUG 0.7\n"
"tstacki_AUUU 0.0\n"
"tstacki_CGAA 0.0\n"
"tstacki_CGAC 0.0\n"
"tstacki_CGAG -1.1\n"
"tstacki_CGAU 0.0\n"
"tstacki_CGCA 0.0\n"
"tstacki_CGCC 0.0\n"
"tstacki_CGCG 0.0\n"
"tstacki_CGCU 0.0\n"
"tstacki_CGGA -1.1\n"
"tstacki_CGGC 0.0\n"
"tstacki_CGGG 0.0\n"
"tstacki_CGGU 0.0\n"
"tstacki_CGUA 0.0\n"
"tstacki_CGUC 0.0\n"
"tstacki_CGUG 0.0\n"
"tstacki_CGUU -0.7\n"
"tstacki_GCAA 0.0\n"
"tstacki_GCAC 0.0\n"
"tstacki_GCAG -1.1\n"
"tstacki_GCAU 0.0\n"
"tstacki_GCCA 0.0\n"
"tstacki_GCCC 0.0\n"
"tstacki_GCCG 0.0\n"
"tstacki_GCCU 0.0\n"
"tstacki_GCGA -1.1\n"
"tstacki_GCGC 0.0\n"
"tstacki_GCGG 0.0\n"
"tstacki_GCGU 0.0\n"
"tstacki_GCUA 0.0\n"
"tstacki_GCUC 0.0\n"
"tstacki_GCUG 0.0\n"
"tstacki_GCUU -0.7\n"
"tstacki_GUAA 0.7\n"
"tstacki_GUAC 0.7\n"
"tstacki_GUAG -0.4\n"
"tstacki_GUAU 0.7\n"
"tstacki_GUCA 0.7\n"
"tstacki_GUCC 0.7\n"
"tstacki_GUCG 0.7\n"
"tstacki_GUCU 0.7\n"
"tstacki_GUGA -0.4\n"
"tstacki_GUGC 0.7\n"
"tstacki_GUGG 0.7\n"
"tstacki_GUGU 0.7\n"
"tstacki_GUUA 0.7\n"
"tstacki_GUUC 0.7\n"
"tstacki_GUUG 0.7\n"
"tstacki_GUUU 0.0\n"
"tstacki_UAAA 0.7\n"
"tstacki_UAAC 0.7\n"
"tstacki_UAAG -0.4\n"
"tstacki_UAAU 0.7\n"
"tstacki_UACA 0.7\n"
"tstacki_UACC 0.7\n"
"tstacki_UACG 0.7\n"
"tstacki_UACU 0.7\n"
"tstacki_UAGA -0.4\n"
"tstacki_UAGC 0.7\n"
"tstacki_UAGG 0.7\n"
"tstacki_UAGU 0.7\n"
"tstacki_UAUA 0.7\n"
"tstacki_UAUC 0.7\n"
"tstacki_UAUG 0.7\n"
"tstacki_UAUU 0.0\n"
"tstacki_UGAA 0.7\n"
"tstacki_UGAC 0.7\n"
"tstacki_UGAG -0.4\n"
"tstacki_UGAU 0.7\n"
"tstacki_UGCA 0.7\n"
"tstacki_UGCC 0.7\n"
"tstacki_UGCG 0.7\n"
"tstacki_UGCU 0.7\n"
"tstacki_UGGA -0.4\n"
"tstacki_UGGC 0.7\n"
"tstacki_UGGG 0.7\n"
"tstacki_UGGU 0.7\n"
"tstacki_UGUA 0.7\n"
"tstacki_UGUC 0.7\n"
"tstacki_UGUG 0.7\n"
"tstacki_UGUU 0.0\n"
"tstackm_AUAA 0.0\n"
"tstackm_AUAC 0.0\n"
"tstackm_AUAG 0.0\n"
"tstackm_AUAU 0.0\n"
"tstackm_AUCA 0.0\n"
"tstackm_AUCC 0.0\n"
"tstackm_AUCG 0.0\n"
"tstackm_AUCU 0.0\n"
"tstackm_AUGA 0.0\n"
"tstackm_AUGC 0.0\n"
"tstackm_AUGG 0.0\n"
"tstackm_AUGU 0.0\n"
"tstackm_AUUA 0.0\n"
"tstackm_AUUC 0.0\n"
"tstackm_AUUG 0.0\n"
"tstackm_AUUU 0.0\n"
"tstackm_CGAA 0.0\n"
"tstackm_CGAC 0.0\n"
"tstackm_CGAG 0.0\n"
"tstackm_CGAU 0.0\n"
"tstackm_CGCA 0.0\n"
"tstackm_CGCC 0.0\n"
"tstackm_CGCG 0.0\n"
"tstackm_CGCU 0.0\n"
"tstackm_CGGA 0.0\n"
"tstackm_CGGC 0.0\n"
"tstackm_CGGG 0.0\n"
"tstackm_CGGU 0.0\n"
"tstackm_CGUA 0.0\n"
"tstackm_CGUC 0.0\n"
"tstackm_CGUG 0.0\n"
"tstackm_CGUU 0.0\n"
"tstackm_GCAA 0.0\n"
"tstackm_GCAC 0.0\n"
"tstackm_GCAG 0.0\n"
"tstackm_GCAU 0.0\n"
"tstackm_GCCA 0.0\n"
"tstackm_GCCC 0.0\n"
"tstackm_GCCG 0.0\n"
"tstackm_GCCU 0.0\n"
"tstackm_GCGA 0.0\n"
"tstackm_GCGC 0.0\n"
"tstackm_GCGG 0.0\n"
"tstackm_GCGU 0.0\n"
"tstackm_GCUA 0.0\n"
"tstackm_GCUC 0.0\n"
"tstackm_GCUG 0.0\n"
"tstackm_GCUU 0.0\n"
"tstackm_GUAA 0.0\n"
"tstackm_GUAC 0.0\n"
"tstackm_GUAG 0.0\n"
"tstackm_GUAU 0.0\n"
"tstackm_GUCA 0.0\n"
"tstackm_GUCC 0.0\n"
"tstackm_GUCG 0.0\n"
"tstackm_GUCU 0.0\n"
"tstackm_GUGA 0.0\n"
"tstackm_GUGC 0.0\n"
"tstackm_GUGG 0.0\n"
"tstackm_GUGU 0.0\n"
"tstackm_GUUA 0.0\n"
"tstackm_GUUC 0.0\n"
"tstackm_GUUG 0.0\n"
"tstackm_GUUU 0.0\n"
"tstackm_UAAA 0.0\n"
"tstackm_UAAC 0.0\n"
"tstackm_UAAG 0.0\n"
"tstackm_UAAU 0.0\n"
"tstackm_UACA 0.0\n"
"tstackm_UACC 0.0\n"
"tstackm_UACG 0.0\n"
"tstackm_UACU 0.0\n"
"tstackm_UAGA 0.0\n"
"tstackm_UAGC 0.0\n"
"tstackm_UAGG 0.0\n"
"tstackm_UAGU 0.0\n"
"tstackm_UAUA 0.0\n"
"tstackm_UAUC 0.0\n"
"tstackm_UAUG 0.0\n"
"tstackm_UAUU 0.0\n"
"tstackm_UGAA 0.0\n"
"tstackm_UGAC 0.0\n"
"tstackm_UGAG 0.0\n"
"tstackm_UGAU 0.0\n"
"tstackm_UGCA 0.0\n"
"tstackm_UGCC 0.0\n"
"tstackm_UGCG 0.0\n"
"tstackm_UGCU 0.0\n"
"tstackm_UGGA 0.0\n"
"tstackm_UGGC 0.0\n"
"tstackm_UGGG 0.0\n"
"tstackm_UGGU 0.0\n"
"tstackm_UGUA 0.0\n"
"tstackm_UGUC 0.0\n"
"tstackm_UGUG 0.0\n"
"tstackm_UGUU 0.0\n"
"int2_AUAAAU 1.7\n"
"int2_AUAACG 1.1\n"
"int2_AUAAGC 1.1\n"
"int2_AUAAGU 1.7\n"
"int2_AUAAUA 1.7\n"
"int2_AUAAUG 1.7\n"
"int2_AUACAU 1.7\n"
"int2_AUACCG 1.1\n"
"int2_AUACGC 1.1\n"
"int2_AUACGU 1.7\n"
"int2_AUACUA 1.7\n"
"int2_AUACUG 1.7\n"
"int2_AUAGAU 1.7\n"
"int2_AUAGCG 1.1\n"
"int2_AUAGGC 1.1\n"
"int2_AUAGGU 1.7\n"
"int2_AUAGUA 1.7\n"
"int2_AUAGUG 1.7\n"
"int2_AUAUAU 1.7\n"
"int2_AUAUCG 1.1\n"
"int2_AUAUGC 1.1\n"
"int2_AUAUGU 1.7\n"
"int2_AUAUUA 1.7\n"
"int2_AUAUUG 1.7\n"
"int2_AUCACG 1.1\n"
"int2_AUCAGC 1.1\n"
"int2_AUCAGU 1.7\n"
"int2_AUCAUA 1.7\n"
"int2_AUCAUG 1.7\n"
"int2_AUCCAU 1.7\n"
"int2_AUCCCG 1.1\n"
"int2_AUCCGC 1.1\n"
"int2_AUCCGU 1.7\n"
"int2_AUCCUA 1.7\n"
"int2_AUCCUG 1.7\n"
"int2_AUCGAU 1.7\n"
"int2_AUCGCG 1.1\n"
"int2_AUCGGC 1.1\n"
"int2_AUCGGU 1.7\n"
"int2_AUCGUA 1.7\n"
"int2_AUCGUG 1.7\n"
"int2_AUCUAU 1.7\n"
"int2_AUCUCG 1.1\n"
"int2_AUCUGC 1.1\n"
"int2_AUCUGU 1.7\n"
"int2_AUCUUA 1.7\n"
"int2_AUCUUG 1.7\n"
"int2_AUGACG 1.1\n"
"int2_AUGAGC 1.1\n"
"int2_AUGAGU 1.7\n"
"int2_AUGAUA 1.7\n"
"int2_AUGAUG 1.7\n"
"int2_AUGCCG 1.1\n"
"int2_AUGCGC 1.1\n"
"int2_AUGCGU 1.7\n"
"int2_AUGCUA 1.7\n"
"int2_AUGCUG 1.7\n"
"int2_AUGGAU -0.4\n"
"int2_AUGGCG -1.0\n"
"int2_AUGGGC -1.0\n"
"int2_AUGGGU -0.4\n"
"int2_AUGGUA -0.4\n"
"int2_AUGGUG -0.4\n"
"int2_AUGUAU 1.7\n"
"int2_AUGUCG 1.1\n"
"int2_AUGUGC 1.1\n"
"int2_AUGUGU 1.7\n"
"int2_AUGUUA 1.7\n"
"int2_AUGUUG 1.7\n"
"int2_AUUACG 1.1\n"
"int2_AUUAGC 1.1\n"
"int2_AUUAGU 1.7\n"
"int2_AUUAUA 1.7\n"
"int2_AUUAUG 1.7\n"
"int2_AUUCCG 1.1\n"
"int2_AUUCGC 1.1\n"
"int2_AUUCGU 1.7\n"
"int2_AUUCUA 1.7\n"
"int2_AUUCUG 1.7\n"
"int2_AUUGCG 1.1\n"
"int2_AUUGGC 1.1\n"
"int2_AUUGGU 1.7\n"
"int2_AUUGUA 1.7\n"
"int2_AUUGUG 1.7\n"
"int2_AUUUAU 1.2\n"
"int2_AUUUCG 1.1\n"
"int2_AUUUGC 1.0\n"
"int2_AUUUGU 1.7\n"
"int2_AUUUUA 1.5\n"
"int2_AUUUUG 1.7\n"
"int2_CGAACG 1.1\n"
"int2_CGAAGC 0.4\n"
"int2_CGAAGU 1.1\n"
"int2_CGAAUA 1.1\n"
"int2_CGAAUG 1.1\n"
"int2_CGACCG 0.4\n"
"int2_CGACGC -0.4\n"
"int2_CGACGU 1.1\n"
"int2_CGACUA 1.1\n"
"int2_CGACUG 1.1\n"
"int2_CGAGCG 0.4\n"
"int2_CGAGGC 0.4\n"
"int2_CGAGGU 1.1\n"
"int2_CGAGUA 1.1\n"
"int2_CGAGUG 1.1\n"
"int2_CGAUCG 0.4\n"
"int2_CGAUGC 0.4\n"
"int2_CGAUGU 1.1\n"
"int2_CGAUUA 1.1\n"
"int2_CGAUUG 1.1\n"
"int2_CGCAGC 0.3\n"
"int2_CGCAGU 1.1\n"
"int2_CGCAUA 1.1\n"
"int2_CGCAUG 1.1\n"
"int2_CGCCCG 0.4\n"
"int2_CGCCGC 0.5\n"
"int2_CGCCGU 1.1\n"
"int2_CGCCUA 1.1\n"
"int2_CGCCUG 1.1\n"
"int2_CGCGCG 0.4\n"
"int2_CGCGGC 0.4\n"
"int2_CGCGGU 1.1\n"
"int2_CGCGUA 1.1\n"
"int2_CGCGUG 1.1\n"
"int2_CGCUCG 0.4\n"
"int2_CGCUGC 0.5\n"
"int2_CGCUGU 1.1\n"
"int2_CGCUUA 1.1\n"
"int2_CGCUUG 1.1\n"
"int2_CGGAGC -0.1\n"
"int2_CGGAGU 1.1\n"
"int2_CGGAUA 1.1\n"
"int2_CGGAUG 1.1\n"
"int2_CGGCGC 0.4\n"
"int2_CGGCGU 1.1\n"
"int2_CGGCUA 1.1\n"
"int2_CGGCUG 1.1\n"
"int2_CGGGCG -1.4\n"
"int2_CGGGGC -1.7\n"
"int2_CGGGGU -1.0\n"
"int2_CGGGUA -1.0\n"
"int2_CGGGUG -1.0\n"
"int2_CGGUCG 0.4\n"
"int2_CGGUGC 0.4\n"
"int2_CGGUGU 1.1\n"
"int2_CGGUUA 1.1\n"
"int2_CGGUUG 1.1\n"
"int2_CGUAGC 0.4\n"
"int2_CGUAGU 1.1\n"
"int2_CGUAUA 1.1\n"
"int2_CGUAUG 1.1\n"
"int2_CGUCGC 0.0\n"
"int2_CGUCGU 1.1\n"
"int2_CGUCUA 1.1\n"
"int2_CGUCUG 1.1\n"
"int2_CGUGGC 0.4\n"
"int2_CGUGGU 1.1\n"
"int2_CGUGUA 1.1\n"
"int2_CGUGUG 1.1\n"
"int2_CGUUCG 0.4\n"
"int2_CGUUGC -0.3\n"
"int2_CGUUGU 1.1\n"
"int2_CGUUUA 1.1\n"
"int2_CGUUUG 1.1\n"
"int2_GCAAGC 0.8\n"
"int2_GCAAGU 1.1\n"
"int2_GCAAUA 1.1\n"
"int2_GCAAUG 1.1\n"
"int2_GCACGC 0.4\n"
"int2_GCACGU 1.1\n"
"int2_GCACUA 1.1\n"
"int2_GCACUG 1.1\n"
"int2_GCAGGC 0.4\n"
"int2_GCAGGU 1.1\n"
"int2_GCAGUA 1.1\n"
"int2_GCAGUG 1.1\n"
"int2_GCAUGC 0.4\n"
"int2_GCAUGU 1.1\n"
"int2_GCAUUA 1.1\n"
"int2_GCAUUG 1.1\n"
"int2_GCCAGU 1.1\n"
"int2_GCCAUA 1.1\n"
"int2_GCCAUG 1.1\n"
"int2_GCCCGC 0.4\n"
"int2_GCCCGU 1.1\n"
"int2_GCCCUA 1.1\n"
"int2_GCCCUG 1.1\n"
"int2_GCCGGC 0.4\n"
"int2_GCCGGU 1.1\n"
"int2_GCCGUA 1.1\n"
"int2_GCCGUG 1.1\n"
"int2_GCCUGC 0.4\n"
"int2_GCCUGU 1.1\n"
"int2_GCCUUA 1.1\n"
"int2_GCCUUG 1.1\n"
"int2_GCGAGU 1.1\n"
"int2_GCGAUA 1.1\n"
"int2_GCGAUG 1.1\n"
"int2_GCGCGU 1.1\n"
"int2_GCGCUA 1.1\n"
"int2_GCGCUG 1.1\n"
"int2_GCGGGC -2.1\n"
"int2_GCGGGU -1.0\n"
"int2_GCGGUA -1.0\n"
"int2_GCGGUG -1.0\n"
"int2_GCGUGC 0.4\n"
"int2_GCGUGU 1.1\n"
"int2_GCGUUA 1.1\n"
"int2_GCGUUG 1.1\n"
"int2_GCUAGU 1.1\n"
"int2_GCUAUA 1.1\n"
"int2_GCUAUG 1.1\n"
"int2_GCUCGU 1.1\n"
"int2_GCUCUA 1.1\n"
"int2_GCUCUG 1.1\n"
"int2_GCUGGU 1.1\n"
"int2_GCUGUA 1.1\n"
"int2_GCUGUG 1.1\n"
"int2_GCUUGC -0.7\n"
"int2_GCUUGU 1.1\n"
"int2_GCUUUA 1.1\n"
"int2_GCUUUG 1.1\n"
"int2_GUAAGU 1.7\n"
"int2_GUAAUA 1.7\n"
"int2_GUAAUG 1.7\n"
"int2_GUACGU 1.7\n"
"int2_GUACUA 1.7\n"
"int2_GUACUG 1.7\n"
"int2_GUAGGU 1.7\n"
"int2_GUAGUA 1.7\n"
"int2_GUAGUG 1.7\n"
"int2_GUAUGU 1.7\n"
"int2_GUAUUA 1.7\n"
"int2_GUAUUG 1.7\n"
"int2_GUCAUA 1.7\n"
"int2_GUCAUG 1.7\n"
"int2_GUCCGU 1.7\n"
"int2_GUCCUA 1.7\n"
"int2_GUCCUG 1.7\n"
"int2_GUCGGU 1.7\n"
"int2_GUCGUA 1.7\n"
"int2_GUCGUG 1.7\n"
"int2_GUCUGU 1.7\n"
"int2_GUCUUA 1.7\n"
"int2_GUCUUG 1.7\n"
"int2_GUGAUA 1.7\n"
"int2_GUGAUG 1.7\n"
"int2_GUGCUA 1.7\n"
"int2_GUGCUG 1.7\n"
"int2_GUGGGU -0.4\n"
"int2_GUGGUA -0.4\n"
"int2_GUGGUG -0.4\n"
"int2_GUGUGU 1.7\n"
"int2_GUGUUA 1.7\n"
"int2_GUGUUG 1.7\n"
"int2_GUUAUA 1.7\n"
"int2_GUUAUG 1.7\n"
"int2_GUUCUA 1.7\n"
"int2_GUUCUG 1.7\n"
"int2_GUUGUA 1.7\n"
"int2_GUUGUG 1.7\n"
"int2_GUUUGU 1.7\n"
"int2_GUUUUA 1.7\n"
"int2_GUUUUG 1.7\n"
"int2_UAAAUA 1.7\n"
"int2_UAAAUG 1.7\n"
"int2_UAACUA 1.7\n"
"int2_UAACUG 1.7\n"
"int2_UAAGUA 1.7\n"
"int2_UAAGUG 1.7\n"
"int2_UAAUUA 1.7\n"
"int2_UAAUUG 1.7\n"
"int2_UACAUG 1.7\n"
"int2_UACCUA 1.7\n"
"int2_UACCUG 1.7\n"
"int2_UACGUA 1.7\n"
"int2_UACGUG 1.7\n"
"int2_UACUUA 1.7\n"
"int2_UACUUG 1.7\n"
"int2_UAGAUG 1.7\n"
"int2_UAGCUG 1.7\n"
"int2_UAGGUA -0.4\n"
"int2_UAGGUG -0.4\n"
"int2_UAGUUA 1.7\n"
"int2_UAGUUG 1.7\n"
"int2_UAUAUG 1.7\n"
"int2_UAUCUG 1.7\n"
"int2_UAUGUG 1.7\n"
"int2_UAUUUA 1.8\n"
"int2_UAUUUG 1.7\n"
"int2_UGAAUG 1.7\n"
"int2_UGACUG 1.7\n"
"int2_UGAGUG 1.7\n"
"int2_UGAUUG 1.7\n"
"int2_UGCCUG 1.7\n"
"int2_UGCGUG 1.7\n"
"int2_UGCUUG 1.7\n"
"int2_UGGGUG -0.4\n"
"int2_UGGUUG 1.7\n"
"int2_UGUUUG 1.7\n"
"int21_AUAAAAU 3.9\n"
"int21_AUAAACG 3.2\n"
"int21_AUAAAGC 3.2\n"
"int21_AUAAAGU 3.9\n"
"int21_AUAAAUA 3.9\n"
"int21_AUAAAUG 3.9\n"
"int21_AUAACAU 3.7\n"
"int21_AUAACCG 3.0\n"
"int21_AUAACGC 3.0\n"
"int21_AUAACGU 3.7\n"
"int21_AUAACUA 3.7\n"
"int21_AUAACUG 3.7\n"
"int21_AUAAGAU 3.1\n"
"int21_AUAAGCG 2.4\n"
"int21_AUAAGGC 2.4\n"
"int21_AUAAGGU 3.1\n"
"int21_AUAAGUA 3.1\n"
"int21_AUAAGUG 3.1\n"
"int21_AUAAUAU 5.5\n"
"int21_AUAAUCG 4.8\n"
"int21_AUAAUGC 4.8\n"
"int21_AUAAUGU 5.5\n"
"int21_AUAAUUA 5.5\n"
"int21_AUAAUUG 5.5\n"
"int21_AUACAAU 3.8\n"
"int21_AUACACG 3.1\n"
"int21_AUACAGC 3.1\n"
"int21_AUACAGU 3.8\n"
"int21_AUACAUA 3.8\n"
"int21_AUACAUG 3.8\n"
"int21_AUACCAU 3.7\n"
"int21_AUACCCG 3.0\n"
"int21_AUACCGC 3.0\n"
"int21_AUACCGU 3.7\n"
"int21_AUACCUA 3.7\n"
"int21_AUACCUG 3.7\n"
"int21_AUACGAU 5.5\n"
"int21_AUACGCG 4.8\n"
"int21_AUACGGC 4.8\n"
"int21_AUACGGU 5.5\n"
"int21_AUACGUA 5.5\n"
"int21_AUACGUG 5.5\n"
"int21_AUACUAU 3.7\n"
"int21_AUACUCG 3.0\n"
"int21_AUACUGC 3.0\n"
"int21_AUACUGU 3.7\n"
"int21_AUACUUA 3.7\n"
"int21_AUACUUG 3.7\n"
"int21_AUAGAAU 3.2\n"
"int21_AUAGACG 2.5\n"
"int21_AUAGAGC 2.5\n"
"int21_AUAGAGU 3.2\n"
"int21_AUAGAUA 3.2\n"
"int21_AUAGAUG 3.2\n"
"int21_AUAGCAU 5.5\n"
"int21_AUAGCCG 4.8\n"
"int21_AUAGCGC 4.8\n"
"int21_AUAGCGU 5.5\n"
"int21_AUAGCUA 5.5\n"
"int21_AUAGCUG 5.5\n"
"int21_AUAGGAU 2.3\n"
"int21_AUAGGCG 1.6\n"
"int21_AUAGGGC 1.6\n"
"int21_AUAGGGU 2.3\n"
"int21_AUAGGUA 2.3\n"
"int21_AUAGGUG 2.3\n"
"int21_AUAGUAU 5.5\n"
"int21_AUAGUCG 4.8\n"
"int21_AUAGUGC 4.8\n"
"int21_AUAGUGU 5.5\n"
"int21_AUAGUUA 5.5\n"
"int21_AUAGUUG 5.5\n"
"int21_AUAUAAU 5.5\n"
"int21_AUAUACG 4.8\n"
"int21_AUAUAGC 4.8\n"
"int21_AUAUAGU 5.5\n"
"int21_AUAUAUA 5.5\n"
"int21_AUAUAUG 5.5\n"
"int21_AUAUCAU 5.5\n"
"int21_AUAUCCG 4.8\n"
"int21_AUAUCGC 4.8\n"
"int21_AUAUCGU 5.5\n"
"int21_AUAUCUA 5.5\n"
"int21_AUAUCUG 5.5\n"
"int21_AUAUGAU 5.5\n"
"int21_AUAUGCG 4.8\n"
"int21_AUAUGGC 4.8\n"
"int21_AUAUGGU 5.5\n"
"int21_AUAUGUA 5.5\n"
"int21_AUAUGUG 5.5\n"
"int21_AUAUUAU 5.5\n"
"int21_AUAUUCG 4.8\n"
"int21_AUAUUGC 4.8\n"
"int21_AUAUUGU 5.5\n"
"int21_AUAUUUA 5.5\n"
"int21_AUAUUUG 5.5\n"
"int21_AUCAAAU 3.6\n"
"int21_AUCAACG 2.9\n"
"int21_AUCAAGC 2.9\n"
"int21_AUCAAGU 3.6\n"
"int21_AUCAAUA 3.6\n"
"int21_AUCAAUG 3.6\n"
"int21_AUCACAU 3.2\n"
"int21_AUCACCG 2.5\n"
"int21_AUCACGC 2.5\n"
"int21_AUCACGU 3.2\n"
"int21_AUCACUA 3.2\n"
"int21_AUCACUG 3.2\n"
"int21_AUCAGAU 3.1\n"
"int21_AUCAGCG 2.4\n"
"int21_AUCAGGC 2.4\n"
"int21_AUCAGGU 3.1\n"
"int21_AUCAGUA 3.1\n"
"int21_AUCAGUG 3.1\n"
"int21_AUCAUAU 5.5\n"
"int21_AUCAUCG 4.8\n"
"int21_AUCAUGC 4.8\n"
"int21_AUCAUGU 5.5\n"
"int21_AUCAUUA 5.5\n"
"int21_AUCAUUG 5.5\n"
"int21_AUCCAAU 3.7\n"
"int21_AUCCACG 3.0\n"
"int21_AUCCAGC 3.0\n"
"int21_AUCCAGU 3.7\n"
"int21_AUCCAUA 3.7\n"
"int21_AUCCAUG 3.7\n"
"int21_AUCCCAU 4.0\n"
"int21_AUCCCCG 3.3\n"
"int21_AUCCCGC 3.3\n"
"int21_AUCCCGU 4.0\n"
"int21_AUCCCUA 4.0\n"
"int21_AUCCCUG 4.0\n"
"int21_AUCCGAU 5.5\n"
"int21_AUCCGCG 4.8\n"
"int21_AUCCGGC 4.8\n"
"int21_AUCCGGU 5.5\n"
"int21_AUCCGUA 5.5\n"
"int21_AUCCGUG 5.5\n"
"int21_AUCCUAU 3.7\n"
"int21_AUCCUCG 3.0\n"
"int21_AUCCUGC 3.0\n"
"int21_AUCCUGU 3.7\n"
"int21_AUCCUUA 3.7\n"
"int21_AUCCUUG 3.7\n"
"int21_AUCGAAU 5.5\n"
"int21_AUCGACG 4.8\n"
"int21_AUCGAGC 4.8\n"
"int21_AUCGAGU 5.5\n"
"int21_AUCGAUA 5.5\n"
"int21_AUCGAUG 5.5\n"
"int21_AUCGCAU 5.5\n"
"int21_AUCGCCG 4.8\n"
"int21_AUCGCGC 4.8\n"
"int21_AUCGCGU 5.5\n"
"int21_AUCGCUA 5.5\n"
"int21_AUCGCUG 5.5\n"
"int21_AUCGGAU 5.5\n"
"int21_AUCGGCG 4.8\n"
"int21_AUCGGGC 4.8\n"
"int21_AUCGGGU 5.5\n"
"int21_AUCGGUA 5.5\n"
"int21_AUCGGUG 5.5\n"
"int21_AUCGUAU 5.5\n"
"int21_AUCGUCG 4.8\n"
"int21_AUCGUGC 4.8\n"
"int21_AUCGUGU 5.5\n"
"int21_AUCGUUA 5.5\n"
"int21_AUCGUUG 5.5\n"
"int21_AUCUAAU 5.5\n"
"int21_AUCUACG 4.8\n"
"int21_AUCUAGC 4.8\n"
"int21_AUCUAGU 5.5\n"
"int21_AUCUAUA 5.5\n"
"int21_AUCUAUG 5.5\n"
"int21_AUCUCAU 3.7\n"
"int21_AUCUCCG 3.0\n"
"int21_AUCUCGC 3.0\n"
"int21_AUCUCGU 3.7\n"
"int21_AUCUCUA 3.7\n"
"int21_AUCUCUG 3.7\n"
"int21_AUCUGAU 5.5\n"
"int21_AUCUGCG 4.8\n"
"int21_AUCUGGC 4.8\n"
"int21_AUCUGGU 5.5\n"
"int21_AUCUGUA 5.5\n"
"int21_AUCUGUG 5.5\n"
"int21_AUCUUAU 2.8\n"
"int21_AUCUUCG 2.1\n"
"int21_AUCUUGC 2.1\n"
"int21_AUCUUGU 2.8\n"
"int21_AUCUUUA 2.8\n"
"int21_AUCUUUG 2.8\n"
"int21_AUGAAAU 2.5\n"
"int21_AUGAACG 1.8\n"
"int21_AUGAAGC 1.8\n"
"int21_AUGAAGU 2.5\n"
"int21_AUGAAUA 2.5\n"
"int21_AUGAAUG 2.5\n"
"int21_AUGACAU 2.1\n"
"int21_AUGACCG 1.4\n"
"int21_AUGACGC 1.4\n"
"int21_AUGACGU 2.1\n"
"int21_AUGACUA 2.1\n"
"int21_AUGACUG 2.1\n"
"int21_AUGAGAU 1.9\n"
"int21_AUGAGCG 1.2\n"
"int21_AUGAGGC 1.2\n"
"int21_AUGAGGU 1.9\n"
"int21_AUGAGUA 1.9\n"
"int21_AUGAGUG 1.9\n"
"int21_AUGAUAU 5.5\n"
"int21_AUGAUCG 4.8\n"
"int21_AUGAUGC 4.8\n"
"int21_AUGAUGU 5.5\n"
"int21_AUGAUUA 5.5\n"
"int21_AUGAUUG 5.5\n"
"int21_AUGCAAU 5.5\n"
"int21_AUGCACG 4.8\n"
"int21_AUGCAGC 4.8\n"
"int21_AUGCAGU 5.5\n"
"int21_AUGCAUA 5.5\n"
"int21_AUGCAUG 5.5\n"
"int21_AUGCCAU 5.5\n"
"int21_AUGCCCG 4.8\n"
"int21_AUGCCGC 4.8\n"
"int21_AUGCCGU 5.5\n"
"int21_AUGCCUA 5.5\n"
"int21_AUGCCUG 5.5\n"
"int21_AUGCGAU 5.5\n"
"int21_AUGCGCG 4.8\n"
"int21_AUGCGGC 4.8\n"
"int21_AUGCGGU 5.5\n"
"int21_AUGCGUA 5.5\n"
"int21_AUGCGUG 5.5\n"
"int21_AUGCUAU 5.5\n"
"int21_AUGCUCG 4.8\n"
"int21_AUGCUGC 4.8\n"
"int21_AUGCUGU 5.5\n"
"int21_AUGCUUA 5.5\n"
"int21_AUGCUUG 5.5\n"
"int21_AUGGAAU 2.3\n"
"int21_AUGGACG 1.6\n"
"int21_AUGGAGC 1.6\n"
"int21_AUGGAGU 2.3\n"
"int21_AUGGAUA 2.3\n"
"int21_AUGGAUG 2.3\n"
"int21_AUGGCAU 5.5\n"
"int21_AUGGCCG 4.8\n"
"int21_AUGGCGC 4.8\n"
"int21_AUGGCGU 5.5\n"
"int21_AUGGCUA 5.5\n"
"int21_AUGGCUG 5.5\n"
"int21_AUGGGAU 3.7\n"
"int21_AUGGGCG 3.0\n"
"int21_AUGGGGC 3.0\n"
"int21_AUGGGGU 3.7\n"
"int21_AUGGGUA 3.7\n"
"int21_AUGGGUG 3.7\n"
"int21_AUGGUAU 5.5\n"
"int21_AUGGUCG 4.8\n"
"int21_AUGGUGC 4.8\n"
"int21_AUGGUGU 5.5\n"
"int21_AUGGUUA 5.5\n"
"int21_AUGGUUG 5.5\n"
"int21_AUGUAAU 5.5\n"
"int21_AUGUACG 4.8\n"
"int21_AUGUAGC 4.8\n"
"int21_AUGUAGU 5.5\n"
"int21_AUGUAUA 5.5\n"
"int21_AUGUAUG 5.5\n"
"int21_AUGUCAU 5.5\n"
"int21_AUGUCCG 4.8\n"
"int21_AUGUCGC 4.8\n"
"int21_AUGUCGU 5.5\n"
"int21_AUGUCUA 5.5\n"
"int21_AUGUCUG 5.5\n"
"int21_AUGUGAU 5.5\n"
"int21_AUGUGCG 4.8\n"
"int21_AUGUGGC 4.8\n"
"int21_AUGUGGU 5.5\n"
"int21_AUGUGUA 5.5\n"
"int21_AUGUGUG 5.5\n"
"int21_AUGUUAU 5.5\n"
"int21_AUGUUCG 4.8\n"
"int21_AUGUUGC 4.8\n"
"int21_AUGUUGU 5.5\n"
"int21_AUGUUUA 5.5\n"
"int21_AUGUUUG 5.5\n"
"int21_AUUAAAU 5.5\n"
"int21_AUUAACG 4.8\n"
"int21_AUUAAGC 4.8\n"
"int21_AUUAAGU 5.5\n"
"int21_AUUAAUA 5.5\n"
"int21_AUUAAUG 5.5\n"
"int21_AUUACAU 5.5\n"
"int21_AUUACCG 4.8\n"
"int21_AUUACGC 4.8\n"
"int21_AUUACGU 5.5\n"
"int21_AUUACUA 5.5\n"
"int21_AUUACUG 5.5\n"
"int21_AUUAGAU 5.5\n"
"int21_AUUAGCG 4.8\n"
"int21_AUUAGGC 4.8\n"
"int21_AUUAGGU 5.5\n"
"int21_AUUAGUA 5.5\n"
"int21_AUUAGUG 5.5\n"
"int21_AUUAUAU 5.5\n"
"int21_AUUAUCG 4.8\n"
"int21_AUUAUGC 4.8\n"
"int21_AUUAUGU 5.5\n"
"int21_AUUAUUA 5.5\n"
"int21_AUUAUUG 5.5\n"
"int21_AUUCAAU 4.0\n"
"int21_AUUCACG 3.3\n"
"int21_AUUCAGC 3.3\n"
"int21_AUUCAGU 4.0\n"
"int21_AUUCAUA 4.0\n"
"int21_AUUCAUG 4.0\n"
"int21_AUUCCAU 3.4\n"
"int21_AUUCCCG 2.7\n"
"int21_AUUCCGC 2.7\n"
"int21_AUUCCGU 3.4\n"
"int21_AUUCCUA 3.4\n"
"int21_AUUCCUG 3.4\n"
"int21_AUUCGAU 5.5\n"
"int21_AUUCGCG 4.8\n"
"int21_AUUCGGC 4.8\n"
"int21_AUUCGGU 5.5\n"
"int21_AUUCGUA 5.5\n"
"int21_AUUCGUG 5.5\n"
"int21_AUUCUAU 3.7\n"
"int21_AUUCUCG 3.0\n"
"int21_AUUCUGC 3.0\n"
"int21_AUUCUGU 3.7\n"
"int21_AUUCUUA 3.7\n"
"int21_AUUCUUG 3.7\n"
"int21_AUUGAAU 5.5\n"
"int21_AUUGACG 4.8\n"
"int21_AUUGAGC 4.8\n"
"int21_AUUGAGU 5.5\n"
"int21_AUUGAUA 5.5\n"
"int21_AUUGAUG 5.5\n"
"int21_AUUGCAU 5.5\n"
"int21_AUUGCCG 4.8\n"
"int21_AUUGCGC 4.8\n"
"int21_AUUGCGU 5.5\n"
"int21_AUUGCUA 5.5\n"
"int21_AUUGCUG 5.5\n"
"int21_AUUGGAU 5.5\n"
"int21_AUUGGCG 4.8\n"
"int21_AUUGGGC 4.8\n"
"int21_AUUGGGU 5.5\n"
"int21_AUUGGUA 5.5\n"
"int21_AUUGGUG 5.5\n"
"int21_AUUGUAU 5.5\n"
"int21_AUUGUCG 4.8\n"
"int21_AUUGUGC 4.8\n"
"int21_AUUGUGU 5.5\n"
"int21_AUUGUUA 5.5\n"
"int21_AUUGUUG 5.5\n"
"int21_AUUUAAU 5.5\n"
"int21_AUUUACG 4.8\n"
"int21_AUUUAGC 4.8\n"
"int21_AUUUAGU 5.5\n"
"int21_AUUUAUA 5.5\n"
"int21_AUUUAUG 5.5\n"
"int21_AUUUCAU 3.2\n"
"int21_AUUUCCG 2.5\n"
"int21_AUUUCGC 2.5\n"
"int21_AUUUCGU 3.2\n"
"int21_AUUUCUA 3.2\n"
"int21_AUUUCUG 3.2\n"
"int21_AUUUGAU 5.5\n"
"int21_AUUUGCG 4.8\n"
"int21_AUUUGGC 4.8\n"
"int21_AUUUGGU 5.5\n"
"int21_AUUUGUA 5.5\n"
"int21_AUUUGUG 5.5\n"
"int21_AUUUUAU 2.7\n"
"int21_AUUUUCG 2.0\n"
"int21_AUUUUGC 2.0\n"
"int21_AUUUUGU 2.7\n"
"int21_AUUUUUA 2.7\n"
"int21_AUUUUUG 2.7\n"
"int21_CGAAAAU 3.2\n"
"int21_CGAAACG 2.4\n"
"int21_CGAAAGC 2.5\n"
"int21_CGAAAGU 3.2\n"
"int21_CGAAAUA 3.2\n"
"int21_CGAAAUG 3.2\n"
"int21_CGAACAU 3.0\n"
"int21_CGAACCG 2.2\n"
"int21_CGAACGC 2.2\n"
"int21_CGAACGU 3.0\n"
"int21_CGAACUA 3.0\n"
"int21_CGAACUG 3.0\n"
"int21_CGAAGAU 2.4\n"
"int21_CGAAGCG 1.6\n"
"int21_CGAAGGC 2.1\n"
"int21_CGAAGGU 2.4\n"
"int21_CGAAGUA 2.4\n"
"int21_CGAAGUG 2.4\n"
"int21_CGAAUAU 4.8\n"
"int21_CGAAUCG 4.0\n"
"int21_CGAAUGC 4.0\n"
"int21_CGAAUGU 4.8\n"
"int21_CGAAUUA 4.8\n"
"int21_CGAAUUG 4.8\n"
"int21_CGACAAU 3.1\n"
"int21_CGACACG 2.3\n"
"int21_CGACAGC 2.3\n"
"int21_CGACAGU 3.1\n"
"int21_CGACAUA 3.1\n"
"int21_CGACAUG 3.1\n"
"int21_CGACCAU 3.0\n"
"int21_CGACCCG 2.2\n"
"int21_CGACCGC 2.2\n"
"int21_CGACCGU 3.0\n"
"int21_CGACCUA 3.0\n"
"int21_CGACCUG 3.0\n"
"int21_CGACGAU 4.8\n"
"int21_CGACGCG 4.0\n"
"int21_CGACGGC 4.0\n"
"int21_CGACGGU 4.8\n"
"int21_CGACGUA 4.8\n"
"int21_CGACGUG 4.8\n"
"int21_CGACUAU 3.0\n"
"int21_CGACUCG 2.2\n"
"int21_CGACUGC 2.2\n"
"int21_CGACUGU 3.0\n"
"int21_CGACUUA 3.0\n"
"int21_CGACUUG 3.0\n"
"int21_CGAGAAU 2.5\n"
"int21_CGAGACG 1.7\n"
"int21_CGAGAGC 1.7\n"
"int21_CGAGAGU 2.5\n"
"int21_CGAGAUA 2.5\n"
"int21_CGAGAUG 2.5\n"
"int21_CGAGCAU 4.8\n"
"int21_CGAGCCG 4.0\n"
"int21_CGAGCGC 4.0\n"
"int21_CGAGCGU 4.8\n"
"int21_CGAGCUA 4.8\n"
"int21_CGAGCUG 4.8\n"
"int21_CGAGGAU 1.6\n"
"int21_CGAGGCG 0.8\n"
"int21_CGAGGGC 0.8\n"
"int21_CGAGGGU 1.6\n"
"int21_CGAGGUA 1.6\n"
"int21_CGAGGUG 1.6\n"
"int21_CGAGUAU 4.8\n"
"int21_CGAGUCG 4.0\n"
"int21_CGAGUGC 4.0\n"
"int21_CGAGUGU 4.8\n"
"int21_CGAGUUA 4.8\n"
"int21_CGAGUUG 4.8\n"
"int21_CGAUAAU 4.8\n"
"int21_CGAUACG 4.0\n"
"int21_CGAUAGC 4.0\n"
"int21_CGAUAGU 4.8\n"
"int21_CGAUAUA 4.8\n"
"int21_CGAUAUG 4.8\n"
"int21_CGAUCAU 4.8\n"
"int21_CGAUCCG 4.0\n"
"int21_CGAUCGC 4.0\n"
"int21_CGAUCGU 4.8\n"
"int21_CGAUCUA 4.8\n"
"int21_CGAUCUG 4.8\n"
"int21_CGAUGAU 4.8\n"
"int21_CGAUGCG 4.0\n"
"int21_CGAUGGC 4.0\n"
"int21_CGAUGGU 4.8\n"
"int21_CGAUGUA 4.8\n"
"int21_CGAUGUG 4.8\n"
"int21_CGAUUAU 4.8\n"
"int21_CGAUUCG 4.0\n"
"int21_CGAUUGC 4.0\n"
"int21_CGAUUGU 4.8\n"
"int21_CGAUUUA 4.8\n"
"int21_CGAUUUG 4.8\n"
"int21_CGCAAAU 2.9\n"
"int21_CGCAACG 2.1\n"
"int21_CGCAAGC 2.1\n"
"int21_CGCAAGU 2.9\n"
"int21_CGCAAUA 2.9\n"
"int21_CGCAAUG 2.9\n"
"int21_CGCACAU 2.5\n"
"int21_CGCACCG 1.7\n"
"int21_CGCACGC 1.7\n"
"int21_CGCACGU 2.5\n"
"int21_CGCACUA 2.5\n"
"int21_CGCACUG 2.5\n"
"int21_CGCAGAU 2.4\n"
"int21_CGCAGCG 1.6\n"
"int21_CGCAGGC 1.6\n"
"int21_CGCAGGU 2.4\n"
"int21_CGCAGUA 2.4\n"
"int21_CGCAGUG 2.4\n"
"int21_CGCAUAU 4.8\n"
"int21_CGCAUCG 4.0\n"
"int21_CGCAUGC 4.0\n"
"int21_CGCAUGU 4.8\n"
"int21_CGCAUUA 4.8\n"
"int21_CGCAUUG 4.8\n"
"int21_CGCCAAU 3.0\n"
"int21_CGCCACG 2.2\n"
"int21_CGCCAGC 2.2\n"
"int21_CGCCAGU 3.0\n"
"int21_CGCCAUA 3.0\n"
"int21_CGCCAUG 3.0\n"
"int21_CGCCCAU 3.3\n"
"int21_CGCCCCG 2.5\n"
"int21_CGCCCGC 2.5\n"
"int21_CGCCCGU 3.3\n"
"int21_CGCCCUA 3.3\n"
"int21_CGCCCUG 3.3\n"
"int21_CGCCGAU 4.8\n"
"int21_CGCCGCG 4.0\n"
"int21_CGCCGGC 4.0\n"
"int21_CGCCGGU 4.8\n"
"int21_CGCCGUA 4.8\n"
"int21_CGCCGUG 4.8\n"
"int21_CGCCUAU 3.0\n"
"int21_CGCCUCG 2.2\n"
"int21_CGCCUGC 2.2\n"
"int21_CGCCUGU 3.0\n"
"int21_CGCCUUA 3.0\n"
"int21_CGCCUUG 3.0\n"
"int21_CGCGAAU 4.8\n"
"int21_CGCGACG 4.0\n"
"int21_CGCGAGC 4.0\n"
"int21_CGCGAGU 4.8\n"
"int21_CGCGAUA 4.8\n"
"int21_CGCGAUG 4.8\n"
"int21_CGCGCAU 4.8\n"
"int21_CGCGCCG 4.0\n"
"int21_CGCGCGC 4.0\n"
"int21_CGCGCGU 4.8\n"
"int21_CGCGCUA 4.8\n"
"int21_CGCGCUG 4.8\n"
"int21_CGCGGAU 4.8\n"
"int21_CGCGGCG 4.0\n"
"int21_CGCGGGC 4.0\n"
"int21_CGCGGGU 4.8\n"
"int21_CGCGGUA 4.8\n"
"int21_CGCGGUG 4.8\n"
"int21_CGCGUAU 4.8\n"
"int21_CGCGUCG 4.0\n"
"int21_CGCGUGC 4.0\n"
"int21_CGCGUGU 4.8\n"
"int21_CGCGUUA 4.8\n"
"int21_CGCGUUG 4.8\n"
"int21_CGCUAAU 4.8\n"
"int21_CGCUACG 4.0\n"
"int21_CGCUAGC 4.0\n"
"int21_CGCUAGU 4.8\n"
"int21_CGCUAUA 4.8\n"
"int21_CGCUAUG 4.8\n"
"int21_CGCUCAU 3.0\n"
"int21_CGCUCCG 2.2\n"
"int21_CGCUCGC 2.2\n"
"int21_CGCUCGU 3.0\n"
"int21_CGCUCUA 3.0\n"
"int21_CGCUCUG 3.0\n"
"int21_CGCUGAU 4.8\n"
"int21_CGCUGCG 4.0\n"
"int21_CGCUGGC 4.0\n"
"int21_CGCUGGU 4.8\n"
"int21_CGCUGUA 4.8\n"
"int21_CGCUGUG 4.8\n"
"int21_CGCUUAU 2.1\n"
"int21_CGCUUCG 1.3\n"
"int21_CGCUUGC 1.2\n"
"int21_CGCUUGU 2.1\n"
"int21_CGCUUUA 2.1\n"
"int21_CGCUUUG 2.1\n"
"int21_CGGAAAU 1.8\n"
"int21_CGGAACG 1.0\n"
"int21_CGGAAGC 1.2\n"
"int21_CGGAAGU 1.8\n"
"int21_CGGAAUA 1.8\n"
"int21_CGGAAUG 1.8\n"
"int21_CGGACAU 1.4\n"
"int21_CGGACCG 0.6\n"
"int21_CGGACGC 0.6\n"
"int21_CGGACGU 1.4\n"
"int21_CGGACUA 1.4\n"
"int21_CGGACUG 1.4\n"
"int21_CGGAGAU 1.2\n"
"int21_CGGAGCG 0.4\n"
"int21_CGGAGGC 0.4\n"
"int21_CGGAGGU 1.2\n"
"int21_CGGAGUA 1.2\n"
"int21_CGGAGUG 1.2\n"
"int21_CGGAUAU 4.8\n"
"int21_CGGAUCG 4.0\n"
"int21_CGGAUGC 4.0\n"
"int21_CGGAUGU 4.8\n"
"int21_CGGAUUA 4.8\n"
"int21_CGGAUUG 4.8\n"
"int21_CGGCAAU 4.8\n"
"int21_CGGCACG 4.0\n"
"int21_CGGCAGC 4.0\n"
"int21_CGGCAGU 4.8\n"
"int21_CGGCAUA 4.8\n"
"int21_CGGCAUG 4.8\n"
"int21_CGGCCAU 4.8\n"
"int21_CGGCCCG 4.0\n"
"int21_CGGCCGC 4.0\n"
"int21_CGGCCGU 4.8\n"
"int21_CGGCCUA 4.8\n"
"int21_CGGCCUG 4.8\n"
"int21_CGGCGAU 4.8\n"
"int21_CGGCGCG 4.0\n"
"int21_CGGCGGC 4.0\n"
"int21_CGGCGGU 4.8\n"
"int21_CGGCGUA 4.8\n"
"int21_CGGCGUG 4.8\n"
"int21_CGGCUAU 4.8\n"
"int21_CGGCUCG 4.0\n"
"int21_CGGCUGC 4.0\n"
"int21_CGGCUGU 4.8\n"
"int21_CGGCUUA 4.8\n"
"int21_CGGCUUG 4.8\n"
"int21_CGGGAAU 1.6\n"
"int21_CGGGACG 0.8\n"
"int21_CGGGAGC 0.8\n"
"int21_CGGGAGU 1.6\n"
"int21_CGGGAUA 1.6\n"
"int21_CGGGAUG 1.6\n"
"int21_CGGGCAU 4.8\n"
"int21_CGGGCCG 4.0\n"
"int21_CGGGCGC 4.0\n"
"int21_CGGGCGU 4.8\n"
"int21_CGGGCUA 4.8\n"
"int21_CGGGCUG 4.8\n"
"int21_CGGGGAU 3.0\n"
"int21_CGGGGCG 2.2\n"
"int21_CGGGGGC 2.2\n"
"int21_CGGGGGU 3.0\n"
"int21_CGGGGUA 3.0\n"
"int21_CGGGGUG 3.0\n"
"int21_CGGGUAU 4.8\n"
"int21_CGGGUCG 4.0\n"
"int21_CGGGUGC 4.0\n"
"int21_CGGGUGU 4.8\n"
"int21_CGGGUUA 4.8\n"
"int21_CGGGUUG 4.8\n"
"int21_CGGUAAU 4.8\n"
"int21_CGGUACG 4.0\n"
"int21_CGGUAGC 4.0\n"
"int21_CGGUAGU 4.8\n"
"int21_CGGUAUA 4.8\n"
"int21_CGGUAUG 4.8\n"
"int21_CGGUCAU 4.8\n"
"int21_CGGUCCG 4.0\n"
"int21_CGGUCGC 4.0\n"
"int21_CGGUCGU 4.8\n"
"int21_CGGUCUA 4.8\n"
"int21_CGGUCUG 4.8\n"
"int21_CGGUGAU 4.8\n"
"int21_CGGUGCG 4.0\n"
"int21_CGGUGGC 4.0\n"
"int21_CGGUGGU 4.8\n"
"int21_CGGUGUA 4.8\n"
"int21_CGGUGUG 4.8\n"
"int21_CGGUUAU 4.8\n"
"int21_CGGUUCG 4.0\n"
"int21_CGGUUGC 4.0\n"
"int21_CGGUUGU 4.8\n"
"int21_CGGUUUA 4.8\n"
"int21_CGGUUUG 4.8\n"
"int21_CGUAAAU 4.8\n"
"int21_CGUAACG 4.0\n"
"int21_CGUAAGC 4.0\n"
"int21_CGUAAGU 4.8\n"
"int21_CGUAAUA 4.8\n"
"int21_CGUAAUG 4.8\n"
"int21_CGUACAU 4.8\n"
"int21_CGUACCG 4.0\n"
"int21_CGUACGC 4.0\n"
"int21_CGUACGU 4.8\n"
"int21_CGUACUA 4.8\n"
"int21_CGUACUG 4.8\n"
"int21_CGUAGAU 4.8\n"
"int21_CGUAGCG 4.0\n"
"int21_CGUAGGC 4.0\n"
"int21_CGUAGGU 4.8\n"
"int21_CGUAGUA 4.8\n"
"int21_CGUAGUG 4.8\n"
"int21_CGUAUAU 4.8\n"
"int21_CGUAUCG 4.0\n"
"int21_CGUAUGC 4.0\n"
"int21_CGUAUGU 4.8\n"
"int21_CGUAUUA 4.8\n"
"int21_CGUAUUG 4.8\n"
"int21_CGUCAAU 3.3\n"
"int21_CGUCACG 2.5\n"
"int21_CGUCAGC 2.5\n"
"int21_CGUCAGU 3.3\n"
"int21_CGUCAUA 3.3\n"
"int21_CGUCAUG 3.3\n"
"int21_CGUCCAU 2.7\n"
"int21_CGUCCCG 1.9\n"
"int21_CGUCCGC 1.9\n"
"int21_CGUCCGU 2.7\n"
"int21_CGUCCUA 2.7\n"
"int21_CGUCCUG 2.7\n"
"int21_CGUCGAU 4.8\n"
"int21_CGUCGCG 4.0\n"
"int21_CGUCGGC 4.0\n"
"int21_CGUCGGU 4.8\n"
"int21_CGUCGUA 4.8\n"
"int21_CGUCGUG 4.8\n"
"int21_CGUCUAU 3.0\n"
"int21_CGUCUCG 2.2\n"
"int21_CGUCUGC 2.2\n"
"int21_CGUCUGU 3.0\n"
"int21_CGUCUUA 3.0\n"
"int21_CGUCUUG 3.0\n"
"int21_CGUGAAU 4.8\n"
"int21_CGUGACG 4.0\n"
"int21_CGUGAGC 4.0\n"
"int21_CGUGAGU 4.8\n"
"int21_CGUGAUA 4.8\n"
"int21_CGUGAUG 4.8\n"
"int21_CGUGCAU 4.8\n"
"int21_CGUGCCG 4.0\n"
"int21_CGUGCGC 4.0\n"
"int21_CGUGCGU 4.8\n"
"int21_CGUGCUA 4.8\n"
"int21_CGUGCUG 4.8\n"
"int21_CGUGGAU 4.8\n"
"int21_CGUGGCG 4.0\n"
"int21_CGUGGGC 4.0\n"
"int21_CGUGGGU 4.8\n"
"int21_CGUGGUA 4.8\n"
"int21_CGUGGUG 4.8\n"
"int21_CGUGUAU 4.8\n"
"int21_CGUGUCG 4.0\n"
"int21_CGUGUGC 4.0\n"
"int21_CGUGUGU 4.8\n"
"int21_CGUGUUA 4.8\n"
"int21_CGUGUUG 4.8\n"
"int21_CGUUAAU 4.8\n"
"int21_CGUUACG 4.0\n"
"int21_CGUUAGC 4.0\n"
"int21_CGUUAGU 4.8\n"
"int21_CGUUAUA 4.8\n"
"int21_CGUUAUG 4.8\n"
"int21_CGUUCAU 2.5\n"
"int21_CGUUCCG 1.7\n"
"int21_CGUUCGC 1.7\n"
"int21_CGUUCGU 2.5\n"
"int21_CGUUCUA 2.5\n"
"int21_CGUUCUG 2.5\n"
"int21_CGUUGAU 4.8\n"
"int21_CGUUGCG 4.0\n"
"int21_CGUUGGC 4.0\n"
"int21_CGUUGGU 4.8\n"
"int21_CGUUGUA 4.8\n"
"int21_CGUUGUG 4.8\n"
"int21_CGUUUAU 2.0\n"
"int21_CGUUUCG 1.2\n"
"int21_CGUUUGC 1.2\n"
"int21_CGUUUGU 2.0\n"
"int21_CGUUUUA 2.0\n"
"int21_CGUUUUG 2.0\n"
"int21_GCAAAAU 3.2\n"
"int21_GCAAACG 2.3\n"
"int21_GCAAAGC 2.4\n"
"int21_GCAAAGU 3.2\n"
"int21_GCAAAUA 3.2\n"
"int21_GCAAAUG 3.2\n"
"int21_GCAACAU 3.0\n"
"int21_GCAACCG 2.2\n"
"int21_GCAACGC 2.2\n"
"int21_GCAACGU 3.0\n"
"int21_GCAACUA 3.0\n"
"int21_GCAACUG 3.0\n"
"int21_GCAAGAU 2.4\n"
"int21_GCAAGCG 1.1\n"
"int21_GCAAGGC 1.6\n"
"int21_GCAAGGU 2.4\n"
"int21_GCAAGUA 2.4\n"
"int21_GCAAGUG 2.4\n"
"int21_GCAAUAU 4.8\n"
"int21_GCAAUCG 4.0\n"
"int21_GCAAUGC 4.0\n"
"int21_GCAAUGU 4.8\n"
"int21_GCAAUUA 4.8\n"
"int21_GCAAUUG 4.8\n"
"int21_GCACAAU 3.1\n"
"int21_GCACACG 2.3\n"
"int21_GCACAGC 2.3\n"
"int21_GCACAGU 3.1\n"
"int21_GCACAUA 3.1\n"
"int21_GCACAUG 3.1\n"
"int21_GCACCAU 3.0\n"
"int21_GCACCCG 2.2\n"
"int21_GCACCGC 2.2\n"
"int21_GCACCGU 3.0\n"
"int21_GCACCUA 3.0\n"
"int21_GCACCUG 3.0\n"
"int21_GCACGAU 4.8\n"
"int21_GCACGCG 4.0\n"
"int21_GCACGGC 4.0\n"
"int21_GCACGGU 4.8\n"
"int21_GCACGUA 4.8\n"
"int21_GCACGUG 4.8\n"
"int21_GCACUAU 3.0\n"
"int21_GCACUCG 2.2\n"
"int21_GCACUGC 2.2\n"
"int21_GCACUGU 3.0\n"
"int21_GCACUUA 3.0\n"
"int21_GCACUUG 3.0\n"
"int21_GCAGAAU 2.5\n"
"int21_GCAGACG 1.7\n"
"int21_GCAGAGC 1.7\n"
"int21_GCAGAGU 2.5\n"
"int21_GCAGAUA 2.5\n"
"int21_GCAGAUG 2.5\n"
"int21_GCAGCAU 4.8\n"
"int21_GCAGCCG 4.0\n"
"int21_GCAGCGC 4.0\n"
"int21_GCAGCGU 4.8\n"
"int21_GCAGCUA 4.8\n"
"int21_GCAGCUG 4.8\n"
"int21_GCAGGAU 1.6\n"
"int21_GCAGGCG 0.8\n"
"int21_GCAGGGC 0.8\n"
"int21_GCAGGGU 1.6\n"
"int21_GCAGGUA 1.6\n"
"int21_GCAGGUG 1.6\n"
"int21_GCAGUAU 4.8\n"
"int21_GCAGUCG 4.0\n"
"int21_GCAGUGC 4.0\n"
"int21_GCAGUGU 4.8\n"
"int21_GCAGUUA 4.8\n"
"int21_GCAGUUG 4.8\n"
"int21_GCAUAAU 4.8\n"
"int21_GCAUACG 4.0\n"
"int21_GCAUAGC 4.0\n"
"int21_GCAUAGU 4.8\n"
"int21_GCAUAUA 4.8\n"
"int21_GCAUAUG 4.8\n"
"int21_GCAUCAU 4.8\n"
"int21_GCAUCCG 4.0\n"
"int21_GCAUCGC 4.0\n"
"int21_GCAUCGU 4.8\n"
"int21_GCAUCUA 4.8\n"
"int21_GCAUCUG 4.8\n"
"int21_GCAUGAU 4.8\n"
"int21_GCAUGCG 4.0\n"
"int21_GCAUGGC 4.0\n"
"int21_GCAUGGU 4.8\n"
"int21_GCAUGUA 4.8\n"
"int21_GCAUGUG 4.8\n"
"int21_GCAUUAU 4.8\n"
"int21_GCAUUCG 4.0\n"
"int21_GCAUUGC 4.0\n"
"int21_GCAUUGU 4.8\n"
"int21_GCAUUUA 4.8\n"
"int21_GCAUUUG 4.8\n"
"int21_GCCAAAU 2.9\n"
"int21_GCCAACG 2.1\n"
"int21_GCCAAGC 2.1\n"
"int21_GCCAAGU 2.9\n"
"int21_GCCAAUA 2.9\n"
"int21_GCCAAUG 2.9\n"
"int21_GCCACAU 2.5\n"
"int21_GCCACCG 1.7\n"
"int21_GCCACGC 1.7\n"
"int21_GCCACGU 2.5\n"
"int21_GCCACUA 2.5\n"
"int21_GCCACUG 2.5\n"
"int21_GCCAGAU 2.4\n"
"int21_GCCAGCG 1.6\n"
"int21_GCCAGGC 1.6\n"
"int21_GCCAGGU 2.4\n"
"int21_GCCAGUA 2.4\n"
"int21_GCCAGUG 2.4\n"
"int21_GCCAUAU 4.8\n"
"int21_GCCAUCG 4.0\n"
"int21_GCCAUGC 4.0\n"
"int21_GCCAUGU 4.8\n"
"int21_GCCAUUA 4.8\n"
"int21_GCCAUUG 4.8\n"
"int21_GCCCAAU 3.0\n"
"int21_GCCCACG 2.2\n"
"int21_GCCCAGC 2.2\n"
"int21_GCCCAGU 3.0\n"
"int21_GCCCAUA 3.0\n"
"int21_GCCCAUG 3.0\n"
"int21_GCCCCAU 3.3\n"
"int21_GCCCCCG 2.5\n"
"int21_GCCCCGC 2.5\n"
"int21_GCCCCGU 3.3\n"
"int21_GCCCCUA 3.3\n"
"int21_GCCCCUG 3.3\n"
"int21_GCCCGAU 4.8\n"
"int21_GCCCGCG 4.0\n"
"int21_GCCCGGC 4.0\n"
"int21_GCCCGGU 4.8\n"
"int21_GCCCGUA 4.8\n"
"int21_GCCCGUG 4.8\n"
"int21_GCCCUAU 3.0\n"
"int21_GCCCUCG 2.2\n"
"int21_GCCCUGC 2.2\n"
"int21_GCCCUGU 3.0\n"
"int21_GCCCUUA 3.0\n"
"int21_GCCCUUG 3.0\n"
"int21_GCCGAAU 4.8\n"
"int21_GCCGACG 4.0\n"
"int21_GCCGAGC 4.0\n"
"int21_GCCGAGU 4.8\n"
"int21_GCCGAUA 4.8\n"
"int21_GCCGAUG 4.8\n"
"int21_GCCGCAU 4.8\n"
"int21_GCCGCCG 4.0\n"
"int21_GCCGCGC 4.0\n"
"int21_GCCGCGU 4.8\n"
"int21_GCCGCUA 4.8\n"
"int21_GCCGCUG 4.8\n"
"int21_GCCGGAU 4.8\n"
"int21_GCCGGCG 4.0\n"
"int21_GCCGGGC 4.0\n"
"int21_GCCGGGU 4.8\n"
"int21_GCCGGUA 4.8\n"
"int21_GCCGGUG 4.8\n"
"int21_GCCGUAU 4.8\n"
"int21_GCCGUCG 4.0\n"
"int21_GCCGUGC 4.0\n"
"int21_GCCGUGU 4.8\n"
"int21_GCCGUUA 4.8\n"
"int21_GCCGUUG 4.8\n"
"int21_GCCUAAU 4.8\n"
"int21_GCCUACG 4.0\n"
"int21_GCCUAGC 4.0\n"
"int21_GCCUAGU 4.8\n"
"int21_GCCUAUA 4.8\n"
"int21_GCCUAUG 4.8\n"
"int21_GCCUCAU 3.0\n"
"int21_GCCUCCG 2.2\n"
"int21_GCCUCGC 2.2\n"
"int21_GCCUCGU 3.0\n"
"int21_GCCUCUA 3.0\n"
"int21_GCCUCUG 3.0\n"
"int21_GCCUGAU 4.8\n"
"int21_GCCUGCG 4.0\n"
"int21_GCCUGGC 4.0\n"
"int21_GCCUGGU 4.8\n"
"int21_GCCUGUA 4.8\n"
"int21_GCCUGUG 4.8\n"
"int21_GCCUUAU 2.1\n"
"int21_GCCUUCG 1.5\n"
"int21_GCCUUGC 1.3\n"
"int21_GCCUUGU 2.1\n"
"int21_GCCUUUA 2.1\n"
"int21_GCCUUUG 2.1\n"
"int21_GCGAAAU 1.8\n"
"int21_GCGAACG 0.8\n"
"int21_GCGAAGC 1.0\n"
"int21_GCGAAGU 1.8\n"
"int21_GCGAAUA 1.8\n"
"int21_GCGAAUG 1.8\n"
"int21_GCGACAU 1.4\n"
"int21_GCGACCG 0.6\n"
"int21_GCGACGC 0.6\n"
"int21_GCGACGU 1.4\n"
"int21_GCGACUA 1.4\n"
"int21_GCGACUG 1.4\n"
"int21_GCGAGAU 1.2\n"
"int21_GCGAGCG 0.4\n"
"int21_GCGAGGC 0.4\n"
"int21_GCGAGGU 1.2\n"
"int21_GCGAGUA 1.2\n"
"int21_GCGAGUG 1.2\n"
"int21_GCGAUAU 4.8\n"
"int21_GCGAUCG 4.0\n"
"int21_GCGAUGC 4.0\n"
"int21_GCGAUGU 4.8\n"
"int21_GCGAUUA 4.8\n"
"int21_GCGAUUG 4.8\n"
"int21_GCGCAAU 4.8\n"
"int21_GCGCACG 4.0\n"
"int21_GCGCAGC 4.0\n"
"int21_GCGCAGU 4.8\n"
"int21_GCGCAUA 4.8\n"
"int21_GCGCAUG 4.8\n"
"int21_GCGCCAU 4.8\n"
"int21_GCGCCCG 4.0\n"
"int21_GCGCCGC 4.0\n"
"int21_GCGCCGU 4.8\n"
"int21_GCGCCUA 4.8\n"
"int21_GCGCCUG 4.8\n"
"int21_GCGCGAU 4.8\n"
"int21_GCGCGCG 4.0\n"
"int21_GCGCGGC 4.0\n"
"int21_GCGCGGU 4.8\n"
"int21_GCGCGUA 4.8\n"
"int21_GCGCGUG 4.8\n"
"int21_GCGCUAU 4.8\n"
"int21_GCGCUCG 4.0\n"
"int21_GCGCUGC 4.0\n"
"int21_GCGCUGU 4.8\n"
"int21_GCGCUUA 4.8\n"
"int21_GCGCUUG 4.8\n"
"int21_GCGGAAU 1.6\n"
"int21_GCGGACG 0.8\n"
"int21_GCGGAGC 0.8\n"
"int21_GCGGAGU 1.6\n"
"int21_GCGGAUA 1.6\n"
"int21_GCGGAUG 1.6\n"
"int21_GCGGCAU 4.8\n"
"int21_GCGGCCG 4.0\n"
"int21_GCGGCGC 4.0\n"
"int21_GCGGCGU 4.8\n"
"int21_GCGGCUA 4.8\n"
"int21_GCGGCUG 4.8\n"
"int21_GCGGGAU 3.0\n"
"int21_GCGGGCG 2.2\n"
"int21_GCGGGGC 2.2\n"
"int21_GCGGGGU 3.0\n"
"int21_GCGGGUA 3.0\n"
"int21_GCGGGUG 3.0\n"
"int21_GCGGUAU 4.8\n"
"int21_GCGGUCG 4.0\n"
"int21_GCGGUGC 4.0\n"
"int21_GCGGUGU 4.8\n"
"int21_GCGGUUA 4.8\n"
"int21_GCGGUUG 4.8\n"
"int21_GCGUAAU 4.8\n"
"int21_GCGUACG 4.0\n"
"int21_GCGUAGC 4.0\n"
"int21_GCGUAGU 4.8\n"
"int21_GCGUAUA 4.8\n"
"int21_GCGUAUG 4.8\n"
"int21_GCGUCAU 4.8\n"
"int21_GCGUCCG 4.0\n"
"int21_GCGUCGC 4.0\n"
"int21_GCGUCGU 4.8\n"
"int21_GCGUCUA 4.8\n"
"int21_GCGUCUG 4.8\n"
"int21_GCGUGAU 4.8\n"
"int21_GCGUGCG 4.0\n"
"int21_GCGUGGC 4.0\n"
"int21_GCGUGGU 4.8\n"
"int21_GCGUGUA 4.8\n"
"int21_GCGUGUG 4.8\n"
"int21_GCGUUAU 4.8\n"
"int21_GCGUUCG 4.0\n"
"int21_GCGUUGC 4.0\n"
"int21_GCGUUGU 4.8\n"
"int21_GCGUUUA 4.8\n"
"int21_GCGUUUG 4.8\n"
"int21_GCUAAAU 4.8\n"
"int21_GCUAACG 4.0\n"
"int21_GCUAAGC 4.0\n"
"int21_GCUAAGU 4.8\n"
"int21_GCUAAUA 4.8\n"
"int21_GCUAAUG 4.8\n"
"int21_GCUACAU 4.8\n"
"int21_GCUACCG 4.0\n"
"int21_GCUACGC 4.0\n"
"int21_GCUACGU 4.8\n"
"int21_GCUACUA 4.8\n"
"int21_GCUACUG 4.8\n"
"int21_GCUAGAU 4.8\n"
"int21_GCUAGCG 4.0\n"
"int21_GCUAGGC 4.0\n"
"int21_GCUAGGU 4.8\n"
"int21_GCUAGUA 4.8\n"
"int21_GCUAGUG 4.8\n"
"int21_GCUAUAU 4.8\n"
"int21_GCUAUCG 4.0\n"
"int21_GCUAUGC 4.0\n"
"int21_GCUAUGU 4.8\n"
"int21_GCUAUUA 4.8\n"
"int21_GCUAUUG 4.8\n"
"int21_GCUCAAU 3.3\n"
"int21_GCUCACG 2.5\n"
"int21_GCUCAGC 2.5\n"
"int21_GCUCAGU 3.3\n"
"int21_GCUCAUA 3.3\n"
"int21_GCUCAUG 3.3\n"
"int21_GCUCCAU 2.7\n"
"int21_GCUCCCG 1.9\n"
"int21_GCUCCGC 1.9\n"
"int21_GCUCCGU 2.7\n"
"int21_GCUCCUA 2.7\n"
"int21_GCUCCUG 2.7\n"
"int21_GCUCGAU 4.8\n"
"int21_GCUCGCG 4.0\n"
"int21_GCUCGGC 4.0\n"
"int21_GCUCGGU 4.8\n"
"int21_GCUCGUA 4.8\n"
"int21_GCUCGUG 4.8\n"
"int21_GCUCUAU 3.0\n"
"int21_GCUCUCG 2.2\n"
"int21_GCUCUGC 2.2\n"
"int21_GCUCUGU 3.0\n"
"int21_GCUCUUA 3.0\n"
"int21_GCUCUUG 3.0\n"
"int21_GCUGAAU 4.8\n"
"int21_GCUGACG 4.0\n"
"int21_GCUGAGC 4.0\n"
"int21_GCUGAGU 4.8\n"
"int21_GCUGAUA 4.8\n"
"int21_GCUGAUG 4.8\n"
"int21_GCUGCAU 4.8\n"
"int21_GCUGCCG 4.0\n"
"int21_GCUGCGC 4.0\n"
"int21_GCUGCGU 4.8\n"
"int21_GCUGCUA 4.8\n"
"int21_GCUGCUG 4.8\n"
"int21_GCUGGAU 4.8\n"
"int21_GCUGGCG 4.0\n"
"int21_GCUGGGC 4.0\n"
"int21_GCUGGGU 4.8\n"
"int21_GCUGGUA 4.8\n"
"int21_GCUGGUG 4.8\n"
"int21_GCUGUAU 4.8\n"
"int21_GCUGUCG 4.0\n"
"int21_GCUGUGC 4.0\n"
"int21_GCUGUGU 4.8\n"
"int21_GCUGUUA 4.8\n"
"int21_GCUGUUG 4.8\n"
"int21_GCUUAAU 4.8\n"
"int21_GCUUACG 4.0\n"
"int21_GCUUAGC 4.0\n"
"int21_GCUUAGU 4.8\n"
"int21_GCUUAUA 4.8\n"
"int21_GCUUAUG 4.8\n"
"int21_GCUUCAU 2.5\n"
"int21_GCUUCCG 1.7\n"
"int21_GCUUCGC 1.7\n"
"int21_GCUUCGU 2.5\n"
"int21_GCUUCUA 2.5\n"
"int21_GCUUCUG 2.5\n"
"int21_GCUUGAU 4.8\n"
"int21_GCUUGCG 4.0\n"
"int21_GCUUGGC 4.0\n"
"int21_GCUUGGU 4.8\n"
"int21_GCUUGUA 4.8\n"
"int21_GCUUGUG 4.8\n"
"int21_GCUUUAU 2.0\n"
"int21_GCUUUCG 1.2\n"
"int21_GCUUUGC 1.2\n"
"int21_GCUUUGU 2.0\n"
"int21_GCUUUUA 2.0\n"
"int21_GCUUUUG 2.0\n"
"int21_GUAAAAU 3.9\n"
"int21_GUAAACG 3.2\n"
"int21_GUAAAGC 3.2\n"
"int21_GUAAAGU 3.9\n"
"int21_GUAAAUA 3.9\n"
"int21_GUAAAUG 3.9\n"
"int21_GUAACAU 3.7\n"
"int21_GUAACCG 3.0\n"
"int21_GUAACGC 3.0\n"
"int21_GUAACGU 3.7\n"
"int21_GUAACUA 3.7\n"
"int21_GUAACUG 3.7\n"
"int21_GUAAGAU 3.1\n"
"int21_GUAAGCG 2.4\n"
"int21_GUAAGGC 2.4\n"
"int21_GUAAGGU 3.1\n"
"int21_GUAAGUA 3.1\n"
"int21_GUAAGUG 3.1\n"
"int21_GUAAUAU 5.5\n"
"int21_GUAAUCG 4.8\n"
"int21_GUAAUGC 4.8\n"
"int21_GUAAUGU 5.5\n"
"int21_GUAAUUA 5.5\n"
"int21_GUAAUUG 5.5\n"
"int21_GUACAAU 3.8\n"
"int21_GUACACG 3.1\n"
"int21_GUACAGC 3.1\n"
"int21_GUACAGU 3.8\n"
"int21_GUACAUA 3.8\n"
"int21_GUACAUG 3.8\n"
"int21_GUACCAU 3.7\n"
"int21_GUACCCG 3.0\n"
"int21_GUACCGC 3.0\n"
"int21_GUACCGU 3.7\n"
"int21_GUACCUA 3.7\n"
"int21_GUACCUG 3.7\n"
"int21_GUACGAU 5.5\n"
"int21_GUACGCG 4.8\n"
"int21_GUACGGC 4.8\n"
"int21_GUACGGU 5.5\n"
"int21_GUACGUA 5.5\n"
"int21_GUACGUG 5.5\n"
"int21_GUACUAU 3.7\n"
"int21_GUACUCG 3.0\n"
"int21_GUACUGC 3.0\n"
"int21_GUACUGU 3.7\n"
"int21_GUACUUA 3.7\n"
"int21_GUACUUG 3.7\n"
"int21_GUAGAAU 3.2\n"
"int21_GUAGACG 2.5\n"
"int21_GUAGAGC 2.5\n"
"int21_GUAGAGU 3.2\n"
"int21_GUAGAUA 3.2\n"
"int21_GUAGAUG 3.2\n"
"int21_GUAGCAU 5.5\n"
"int21_GUAGCCG 4.8\n"
"int21_GUAGCGC 4.8\n"
"int21_GUAGCGU 5.5\n"
"int21_GUAGCUA 5.5\n"
"int21_GUAGCUG 5.5\n"
"int21_GUAGGAU 2.3\n"
"int21_GUAGGCG 1.6\n"
"int21_GUAGGGC 1.6\n"
"int21_GUAGGGU 2.3\n"
"int21_GUAGGUA 2.3\n"
"int21_GUAGGUG 2.3\n"
"int21_GUAGUAU 5.5\n"
"int21_GUAGUCG 4.8\n"
"int21_GUAGUGC 4.8\n"
"int21_GUAGUGU 5.5\n"
"int21_GUAGUUA 5.5\n"
"int21_GUAGUUG 5.5\n"
"int21_GUAUAAU 5.5\n"
"int21_GUAUACG 4.8\n"
"int21_GUAUAGC 4.8\n"
"int21_GUAUAGU 5.5\n"
"int21_GUAUAUA 5.5\n"
"int21_GUAUAUG 5.5\n"
"int21_GUAUCAU 5.5\n"
"int21_GUAUCCG 4.8\n"
"int21_GUAUCGC 4.8\n"
"int21_GUAUCGU 5.5\n"
"int21_GUAUCUA 5.5\n"
"int21_GUAUCUG 5.5\n"
"int21_GUAUGAU 5.5\n"
"int21_GUAUGCG 4.8\n"
"int21_GUAUGGC 4.8\n"
"int21_GUAUGGU 5.5\n"
"int21_GUAUGUA 5.5\n"
"int21_GUAUGUG 5.5\n"
"int21_GUAUUAU 5.5\n"
"int21_GUAUUCG 4.8\n"
"int21_GUAUUGC 4.8\n"
"int21_GUAUUGU 5.5\n"
"int21_GUAUUUA 5.5\n"
"int21_GUAUUUG 5.5\n"
"int21_GUCAAAU 3.6\n"
"int21_GUCAACG 2.9\n"
"int21_GUCAAGC 2.9\n"
"int21_GUCAAGU 3.6\n"
"int21_GUCAAUA 3.6\n"
"int21_GUCAAUG 3.6\n"
"int21_GUCACAU 3.2\n"
"int21_GUCACCG 2.5\n"
"int21_GUCACGC 2.5\n"
"int21_GUCACGU 3.2\n"
"int21_GUCACUA 3.2\n"
"int21_GUCACUG 3.2\n"
"int21_GUCAGAU 3.1\n"
"int21_GUCAGCG 2.4\n"
"int21_GUCAGGC 2.4\n"
"int21_GUCAGGU 3.1\n"
"int21_GUCAGUA 3.1\n"
"int21_GUCAGUG 3.1\n"
"int21_GUCAUAU 5.5\n"
"int21_GUCAUCG 4.8\n"
"int21_GUCAUGC 4.8\n"
"int21_GUCAUGU 5.5\n"
"int21_GUCAUUA 5.5\n"
"int21_GUCAUUG 5.5\n"
"int21_GUCCAAU 3.7\n"
"int21_GUCCACG 3.0\n"
"int21_GUCCAGC 3.0\n"
"int21_GUCCAGU 3.7\n"
"int21_GUCCAUA 3.7\n"
"int21_GUCCAUG 3.7\n"
"int21_GUCCCAU 4.0\n"
"int21_GUCCCCG 3.3\n"
"int21_GUCCCGC 3.3\n"
"int21_GUCCCGU 4.0\n"
"int21_GUCCCUA 4.0\n"
"int21_GUCCCUG 4.0\n"
"int21_GUCCGAU 5.5\n"
"int21_GUCCGCG 4.8\n"
"int21_GUCCGGC 4.8\n"
"int21_GUCCGGU 5.5\n"
"int21_GUCCGUA 5.5\n"
"int21_GUCCGUG 5.5\n"
"int21_GUCCUAU 3.7\n"
"int21_GUCCUCG 3.0\n"
"int21_GUCCUGC 3.0\n"
"int21_GUCCUGU 3.7\n"
"int21_GUCCUUA 3.7\n"
"int21_GUCCUUG 3.7\n"
"int21_GUCGAAU 5.5\n"
"int21_GUCGACG 4.8\n"
"int21_GUCGAGC 4.8\n"
"int21_GUCGAGU 5.5\n"
"int21_GUCGAUA 5.5\n"
"int21_GUCGAUG 5.5\n"
"int21_GUCGCAU 5.5\n"
"int21_GUCGCCG 4.8\n"
"int21_GUCGCGC 4.8\n"
"int21_GUCGCGU 5.5\n"
"int21_GUCGCUA 5.5\n"
"int21_GUCGCUG 5.5\n"
"int21_GUCGGAU 5.5\n"
"int21_GUCGGCG 4.8\n"
"int21_GUCGGGC 4.8\n"
"int21_GUCGGGU 5.5\n"
"int21_GUCGGUA 5.5\n"
"int21_GUCGGUG 5.5\n"
"int21_GUCGUAU 5.5\n"
"int21_GUCGUCG 4.8\n"
"int21_GUCGUGC 4.8\n"
"int21_GUCGUGU 5.5\n"
"int21_GUCGUUA 5.5\n"
"int21_GUCGUUG 5.5\n"
"int21_GUCUAAU 5.5\n"
"int21_GUCUACG 4.8\n"
"int21_GUCUAGC 4.8\n"
"int21_GUCUAGU 5.5\n"
"int21_GUCUAUA 5.5\n"
"int21_GUCUAUG 5.5\n"
"int21_GUCUCAU 3.7\n"
"int21_GUCUCCG 3.0\n"
"int21_GUCUCGC 3.0\n"
"int21_GUCUCGU 3.7\n"
"int21_GUCUCUA 3.7\n"
"int21_GUCUCUG 3.7\n"
"int21_GUCUGAU 5.5\n"
"int21_GUCUGCG 4.8\n"
"int21_GUCUGGC 4.8\n"
"int21_GUCUGGU 5.5\n"
"int21_GUCUGUA 5.5\n"
"int21_GUCUGUG 5.5\n"
"int21_GUCUUAU 2.8\n"
"int21_GUCUUCG 2.1\n"
"int21_GUCUUGC 2.1\n"
"int21_GUCUUGU 2.8\n"
"int21_GUCUUUA 2.8\n"
"int21_GUCUUUG 2.8\n"
"int21_GUGAAAU 2.5\n"
"int21_GUGAACG 1.8\n"
"int21_GUGAAGC 1.8\n"
"int21_GUGAAGU 2.5\n"
"int21_GUGAAUA 2.5\n"
"int21_GUGAAUG 2.5\n"
"int21_GUGACAU 2.1\n"
"int21_GUGACCG 1.4\n"
"int21_GUGACGC 1.4\n"
"int21_GUGACGU 2.1\n"
"int21_GUGACUA 2.1\n"
"int21_GUGACUG 2.1\n"
"int21_GUGAGAU 1.9\n"
"int21_GUGAGCG 1.2\n"
"int21_GUGAGGC 1.2\n"
"int21_GUGAGGU 1.9\n"
"int21_GUGAGUA 1.9\n"
"int21_GUGAGUG 1.9\n"
"int21_GUGAUAU 5.5\n"
"int21_GUGAUCG 4.8\n"
"int21_GUGAUGC 4.8\n"
"int21_GUGAUGU 5.5\n"
"int21_GUGAUUA 5.5\n"
"int21_GUGAUUG 5.5\n"
"int21_GUGCAAU 5.5\n"
"int21_GUGCACG 4.8\n"
"int21_GUGCAGC 4.8\n"
"int21_GUGCAGU 5.5\n"
"int21_GUGCAUA 5.5\n"
"int21_GUGCAUG 5.5\n"
"int21_GUGCCAU 5.5\n"
"int21_GUGCCCG 4.8\n"
"int21_GUGCCGC 4.8\n"
"int21_GUGCCGU 5.5\n"
"int21_GUGCCUA 5.5\n"
"int21_GUGCCUG 5.5\n"
"int21_GUGCGAU 5.5\n"
"int21_GUGCGCG 4.8\n"
"int21_GUGCGGC 4.8\n"
"int21_GUGCGGU 5.5\n"
"int21_GUGCGUA 5.5\n"
"int21_GUGCGUG 5.5\n"
"int21_GUGCUAU 5.5\n"
"int21_GUGCUCG 4.8\n"
"int21_GUGCUGC 4.8\n"
"int21_GUGCUGU 5.5\n"
"int21_GUGCUUA 5.5\n"
"int21_GUGCUUG 5.5\n"
"int21_GUGGAAU 2.3\n"
"int21_GUGGACG 1.6\n"
"int21_GUGGAGC 1.6\n"
"int21_GUGGAGU 2.3\n"
"int21_GUGGAUA 2.3\n"
"int21_GUGGAUG 2.3\n"
"int21_GUGGCAU 5.5\n"
"int21_GUGGCCG 4.8\n"
"int21_GUGGCGC 4.8\n"
"int21_GUGGCGU 5.5\n"
"int21_GUGGCUA 5.5\n"
"int21_GUGGCUG 5.5\n"
"int21_GUGGGAU 3.7\n"
"int21_GUGGGCG 3.0\n"
"int21_GUGGGGC 3.0\n"
"int21_GUGGGGU 3.7\n"
"int21_GUGGGUA 3.7\n"
"int21_GUGGGUG 3.7\n"
"int21_GUGGUAU 5.5\n"
"int21_GUGGUCG 4.8\n"
"int21_GUGGUGC 4.8\n"
"int21_GUGGUGU 5.5\n"
"int21_GUGGUUA 5.5\n"
"int21_GUGGUUG 5.5\n"
"int21_GUGUAAU 5.5\n"
"int21_GUGUACG 4.8\n"
"int21_GUGUAGC 4.8\n"
"int21_GUGUAGU 5.5\n"
"int21_GUGUAUA 5.5\n"
"int21_GUGUAUG 5.5\n"
"int21_GUGUCAU 5.5\n"
"int21_GUGUCCG 4.8\n"
"int21_GUGUCGC 4.8\n"
"int21_GUGUCGU 5.5\n"
"int21_GUGUCUA 5.5\n"
"int21_GUGUCUG 5.5\n"
"int21_GUGUGAU 5.5\n"
"int21_GUGUGCG 4.8\n"
"int21_GUGUGGC 4.8\n"
"int21_GUGUGGU 5.5\n"
"int21_GUGUGUA 5.5\n"
"int21_GUGUGUG 5.5\n"
"int21_GUGUUAU 5.5\n"
"int21_GUGUUCG 4.8\n"
"int21_GUGUUGC 4.8\n"
"int21_GUGUUGU 5.5\n"
"int21_GUGUUUA 5.5\n"
"int21_GUGUUUG 5.5\n"
"int21_GUUAAAU 5.5\n"
"int21_GUUAACG 4.8\n"
"int21_GUUAAGC 4.8\n"
"int21_GUUAAGU 5.5\n"
"int21_GUUAAUA 5.5\n"
"int21_GUUAAUG 5.5\n"
"int21_GUUACAU 5.5\n"
"int21_GUUACCG 4.8\n"
"int21_GUUACGC 4.8\n"
"int21_GUUACGU 5.5\n"
"int21_GUUACUA 5.5\n"
"int21_GUUACUG 5.5\n"
"int21_GUUAGAU 5.5\n"
"int21_GUUAGCG 4.8\n"
"int21_GUUAGGC 4.8\n"
"int21_GUUAGGU 5.5\n"
"int21_GUUAGUA 5.5\n"
"int21_GUUAGUG 5.5\n"
"int21_GUUAUAU 5.5\n"
"int21_GUUAUCG 4.8\n"
"int21_GUUAUGC 4.8\n"
"int21_GUUAUGU 5.5\n"
"int21_GUUAUUA 5.5\n"
"int21_GUUAUUG 5.5\n"
"int21_GUUCAAU 4.0\n"
"int21_GUUCACG 3.3\n"
"int21_GUUCAGC 3.3\n"
"int21_GUUCAGU 4.0\n"
"int21_GUUCAUA 4.0\n"
"int21_GUUCAUG 4.0\n"
"int21_GUUCCAU 3.4\n"
"int21_GUUCCCG 2.7\n"
"int21_GUUCCGC 2.7\n"
"int21_GUUCCGU 3.4\n"
"int21_GUUCCUA 3.4\n"
"int21_GUUCCUG 3.4\n"
"int21_GUUCGAU 5.5\n"
"int21_GUUCGCG 4.8\n"
"int21_GUUCGGC 4.8\n"
"int21_GUUCGGU 5.5\n"
"int21_GUUCGUA 5.5\n"
"int21_GUUCGUG 5.5\n"
"int21_GUUCUAU 3.7\n"
"int21_GUUCUCG 3.0\n"
"int21_GUUCUGC 3.0\n"
"int21_GUUCUGU 3.7\n"
"int21_GUUCUUA 3.7\n"
"int21_GUUCUUG 3.7\n"
"int21_GUUGAAU 5.5\n"
"int21_GUUGACG 4.8\n"
"int21_GUUGAGC 4.8\n"
"int21_GUUGAGU 5.5\n"
"int21_GUUGAUA 5.5\n"
"int21_GUUGAUG 5.5\n"
"int21_GUUGCAU 5.5\n"
"int21_GUUGCCG 4.8\n"
"int21_GUUGCGC 4.8\n"
"int21_GUUGCGU 5.5\n"
"int21_GUUGCUA 5.5\n"
"int21_GUUGCUG 5.5\n"
"int21_GUUGGAU 5.5\n"
"int21_GUUGGCG 4.8\n"
"int21_GUUGGGC 4.8\n"
"int21_GUUGGGU 5.5\n"
"int21_GUUGGUA 5.5\n"
"int21_GUUGGUG 5.5\n"
"int21_GUUGUAU 5.5\n"
"int21_GUUGUCG 4.8\n"
"int21_GUUGUGC 4.8\n"
"int21_GUUGUGU 5.5\n"
"int21_GUUGUUA 5.5\n"
"int21_GUUGUUG 5.5\n"
"int21_GUUUAAU 5.5\n"
"int21_GUUUACG 4.8\n"
"int21_GUUUAGC 4.8\n"
"int21_GUUUAGU 5.5\n"
"int21_GUUUAUA 5.5\n"
"int21_GUUUAUG 5.5\n"
"int21_GUUUCAU 3.2\n"
"int21_GUUUCCG 2.5\n"
"int21_GUUUCGC 2.5\n"
"int21_GUUUCGU 3.2\n"
"int21_GUUUCUA 3.2\n"
"int21_GUUUCUG 3.2\n"
"int21_GUUUGAU 5.5\n"
"int21_GUUUGCG 4.8\n"
"int21_GUUUGGC 4.8\n"
"int21_GUUUGGU 5.5\n"
"int21_GUUUGUA 5.5\n"
"int21_GUUUGUG 5.5\n"
"int21_GUUUUAU 2.7\n"
"int21_GUUUUCG 2.0\n"
"int21_GUUUUGC 2.0\n"
"int21_GUUUUGU 2.7\n"
"int21_GUUUUUA 2.7\n"
"int21_GUUUUUG 2.7\n"
"int21_UAAAAAU 3.9\n"
"int21_UAAAACG 3.2\n"
"int21_UAAAAGC 3.2\n"
"int21_UAAAAGU 3.9\n"
"int21_UAAAAUA 3.9\n"
"int21_UAAAAUG 3.9\n"
"int21_UAAACAU 3.7\n"
"int21_UAAACCG 3.0\n"
"int21_UAAACGC 3.0\n"
"int21_UAAACGU 3.7\n"
"int21_UAAACUA 3.7\n"
"int21_UAAACUG 3.7\n"
"int21_UAAAGAU 3.1\n"
"int21_UAAAGCG 2.4\n"
"int21_UAAAGGC 2.4\n"
"int21_UAAAGGU 3.1\n"
"int21_UAAAGUA 3.1\n"
"int21_UAAAGUG 3.1\n"
"int21_UAAAUAU 5.5\n"
"int21_UAAAUCG 4.8\n"
"int21_UAAAUGC 4.8\n"
"int21_UAAAUGU 5.5\n"
"int21_UAAAUUA 5.5\n"
"int21_UAAAUUG 5.5\n"
"int21_UAACAAU 3.8\n"
"int21_UAACACG 3.1\n"
"int21_UAACAGC 3.1\n"
"int21_UAACAGU 3.8\n"
"int21_UAACAUA 3.8\n"
"int21_UAACAUG 3.8\n"
"int21_UAACCAU 3.7\n"
"int21_UAACCCG 3.0\n"
"int21_UAACCGC 3.0\n"
"int21_UAACCGU 3.7\n"
"int21_UAACCUA 3.7\n"
"int21_UAACCUG 3.7\n"
"int21_UAACGAU 5.5\n"
"int21_UAACGCG 4.8\n"
"int21_UAACGGC 4.8\n"
"int21_UAACGGU 5.5\n"
"int21_UAACGUA 5.5\n"
"int21_UAACGUG 5.5\n"
"int21_UAACUAU 3.7\n"
"int21_UAACUCG 3.0\n"
"int21_UAACUGC 3.0\n"
"int21_UAACUGU 3.7\n"
"int21_UAACUUA 3.7\n"
"int21_UAACUUG 3.7\n"
"int21_UAAGAAU 3.2\n"
"int21_UAAGACG 2.5\n"
"int21_UAAGAGC 2.5\n"
"int21_UAAGAGU 3.2\n"
"int21_UAAGAUA 3.2\n"
"int21_UAAGAUG 3.2\n"
"int21_UAAGCAU 5.5\n"
"int21_UAAGCCG 4.8\n"
"int21_UAAGCGC 4.8\n"
"int21_UAAGCGU 5.5\n"
"int21_UAAGCUA 5.5\n"
"int21_UAAGCUG 5.5\n"
"int21_UAAGGAU 2.3\n"
"int21_UAAGGCG 1.6\n"
"int21_UAAGGGC 1.6\n"
"int21_UAAGGGU 2.3\n"
"int21_UAAGGUA 2.3\n"
"int21_UAAGGUG 2.3\n"
"int21_UAAGUAU 5.5\n"
"int21_UAAGUCG 4.8\n"
"int21_UAAGUGC 4.8\n"
"int21_UAAGUGU 5.5\n"
"int21_UAAGUUA 5.5\n"
"int21_UAAGUUG 5.5\n"
"int21_UAAUAAU 5.5\n"
"int21_UAAUACG 4.8\n"
"int21_UAAUAGC 4.8\n"
"int21_UAAUAGU 5.5\n"
"int21_UAAUAUA 5.5\n"
"int21_UAAUAUG 5.5\n"
"int21_UAAUCAU 5.5\n"
"int21_UAAUCCG 4.8\n"
"int21_UAAUCGC 4.8\n"
"int21_UAAUCGU 5.5\n"
"int21_UAAUCUA 5.5\n"
"int21_UAAUCUG 5.5\n"
"int21_UAAUGAU 5.5\n"
"int21_UAAUGCG 4.8\n"
"int21_UAAUGGC 4.8\n"
"int21_UAAUGGU 5.5\n"
"int21_UAAUGUA 5.5\n"
"int21_UAAUGUG 5.5\n"
"int21_UAAUUAU 5.5\n"
"int21_UAAUUCG 4.8\n"
"int21_UAAUUGC 4.8\n"
"int21_UAAUUGU 5.5\n"
"int21_UAAUUUA 5.5\n"
"int21_UAAUUUG 5.5\n"
"int21_UACAAAU 3.6\n"
"int21_UACAACG 2.9\n"
"int21_UACAAGC 2.9\n"
"int21_UACAAGU 3.6\n"
"int21_UACAAUA 3.6\n"
"int21_UACAAUG 3.6\n"
"int21_UACACAU 3.2\n"
"int21_UACACCG 2.5\n"
"int21_UACACGC 2.5\n"
"int21_UACACGU 3.2\n"
"int21_UACACUA 3.2\n"
"int21_UACACUG 3.2\n"
"int21_UACAGAU 3.1\n"
"int21_UACAGCG 2.4\n"
"int21_UACAGGC 2.4\n"
"int21_UACAGGU 3.1\n"
"int21_UACAGUA 3.1\n"
"int21_UACAGUG 3.1\n"
"int21_UACAUAU 5.5\n"
"int21_UACAUCG 4.8\n"
"int21_UACAUGC 4.8\n"
"int21_UACAUGU 5.5\n"
"int21_UACAUUA 5.5\n"
"int21_UACAUUG 5.5\n"
"int21_UACCAAU 3.7\n"
"int21_UACCACG 3.0\n"
"int21_UACCAGC 3.0\n"
"int21_UACCAGU 3.7\n"
"int21_UACCAUA 3.7\n"
"int21_UACCAUG 3.7\n"
"int21_UACCCAU 4.0\n"
"int21_UACCCCG 3.3\n"
"int21_UACCCGC 3.3\n"
"int21_UACCCGU 4.0\n"
"int21_UACCCUA 4.0\n"
"int21_UACCCUG 4.0\n"
"int21_UACCGAU 5.5\n"
"int21_UACCGCG 4.8\n"
"int21_UACCGGC 4.8\n"
"int21_UACCGGU 5.5\n"
"int21_UACCGUA 5.5\n"
"int21_UACCGUG 5.5\n"
"int21_UACCUAU 3.7\n"
"int21_UACCUCG 3.0\n"
"int21_UACCUGC 3.0\n"
"int21_UACCUGU 3.7\n"
"int21_UACCUUA 3.7\n"
"int21_UACCUUG 3.7\n"
"int21_UACGAAU 5.5\n"
"int21_UACGACG 4.8\n"
"int21_UACGAGC 4.8\n"
"int21_UACGAGU 5.5\n"
"int21_UACGAUA 5.5\n"
"int21_UACGAUG 5.5\n"
"int21_UACGCAU 5.5\n"
"int21_UACGCCG 4.8\n"
"int21_UACGCGC 4.8\n"
"int21_UACGCGU 5.5\n"
"int21_UACGCUA 5.5\n"
"int21_UACGCUG 5.5\n"
"int21_UACGGAU 5.5\n"
"int21_UACGGCG 4.8\n"
"int21_UACGGGC 4.8\n"
"int21_UACGGGU 5.5\n"
"int21_UACGGUA 5.5\n"
"int21_UACGGUG 5.5\n"
"int21_UACGUAU 5.5\n"
"int21_UACGUCG 4.8\n"
"int21_UACGUGC 4.8\n"
"int21_UACGUGU 5.5\n"
"int21_UACGUUA 5.5\n"
"int21_UACGUUG 5.5\n"
"int21_UACUAAU 5.5\n"
"int21_UACUACG 4.8\n"
"int21_UACUAGC 4.8\n"
"int21_UACUAGU 5.5\n"
"int21_UACUAUA 5.5\n"
"int21_UACUAUG 5.5\n"
"int21_UACUCAU 3.7\n"
"int21_UACUCCG 3.0\n"
"int21_UACUCGC 3.0\n"
"int21_UACUCGU 3.7\n"
"int21_UACUCUA 3.7\n"
"int21_UACUCUG 3.7\n"
"int21_UACUGAU 5.5\n"
"int21_UACUGCG 4.8\n"
"int21_UACUGGC 4.8\n"
"int21_UACUGGU 5.5\n"
"int21_UACUGUA 5.5\n"
"int21_UACUGUG 5.5\n"
"int21_UACUUAU 2.8\n"
"int21_UACUUCG 2.1\n"
"int21_UACUUGC 2.1\n"
"int21_UACUUGU 2.8\n"
"int21_UACUUUA 2.8\n"
"int21_UACUUUG 2.8\n"
"int21_UAGAAAU 2.5\n"
"int21_UAGAACG 1.8\n"
"int21_UAGAAGC 1.8\n"
"int21_UAGAAGU 2.5\n"
"int21_UAGAAUA 2.5\n"
"int21_UAGAAUG 2.5\n"
"int21_UAGACAU 2.1\n"
"int21_UAGACCG 1.4\n"
"int21_UAGACGC 1.4\n"
"int21_UAGACGU 2.1\n"
"int21_UAGACUA 2.1\n"
"int21_UAGACUG 2.1\n"
"int21_UAGAGAU 1.9\n"
"int21_UAGAGCG 1.2\n"
"int21_UAGAGGC 1.2\n"
"int21_UAGAGGU 1.9\n"
"int21_UAGAGUA 1.9\n"
"int21_UAGAGUG 1.9\n"
"int21_UAGAUAU 5.5\n"
"int21_UAGAUCG 4.8\n"
"int21_UAGAUGC 4.8\n"
"int21_UAGAUGU 5.5\n"
"int21_UAGAUUA 5.5\n"
"int21_UAGAUUG 5.5\n"
"int21_UAGCAAU 5.5\n"
"int21_UAGCACG 4.8\n"
"int21_UAGCAGC 4.8\n"
"int21_UAGCAGU 5.5\n"
"int21_UAGCAUA 5.5\n"
"int21_UAGCAUG 5.5\n"
"int21_UAGCCAU 5.5\n"
"int21_UAGCCCG 4.8\n"
"int21_UAGCCGC 4.8\n"
"int21_UAGCCGU 5.5\n"
"int21_UAGCCUA 5.5\n"
"int21_UAGCCUG 5.5\n"
"int21_UAGCGAU 5.5\n"
"int21_UAGCGCG 4.8\n"
"int21_UAGCGGC 4.8\n"
"int21_UAGCGGU 5.5\n"
"int21_UAGCGUA 5.5\n"
"int21_UAGCGUG 5.5\n"
"int21_UAGCUAU 5.5\n"
"int21_UAGCUCG 4.8\n"
"int21_UAGCUGC 4.8\n"
"int21_UAGCUGU 5.5\n"
"int21_UAGCUUA 5.5\n"
"int21_UAGCUUG 5.5\n"
"int21_UAGGAAU 2.3\n"
"int21_UAGGACG 1.6\n"
"int21_UAGGAGC 1.6\n"
"int21_UAGGAGU 2.3\n"
"int21_UAGGAUA 2.3\n"
"int21_UAGGAUG 2.3\n"
"int21_UAGGCAU 5.5\n"
"int21_UAGGCCG 4.8\n"
"int21_UAGGCGC 4.8\n"
"int21_UAGGCGU 5.5\n"
"int21_UAGGCUA 5.5\n"
"int21_UAGGCUG 5.5\n"
"int21_UAGGGAU 3.7\n"
"int21_UAGGGCG 3.0\n"
"int21_UAGGGGC 3.0\n"
"int21_UAGGGGU 3.7\n"
"int21_UAGGGUA 3.7\n"
"int21_UAGGGUG 3.7\n"
"int21_UAGGUAU 5.5\n"
"int21_UAGGUCG 4.8\n"
"int21_UAGGUGC 4.8\n"
"int21_UAGGUGU 5.5\n"
"int21_UAGGUUA 5.5\n"
"int21_UAGGUUG 5.5\n"
"int21_UAGUAAU 5.5\n"
"int21_UAGUACG 4.8\n"
"int21_UAGUAGC 4.8\n"
"int21_UAGUAGU 5.5\n"
"int21_UAGUAUA 5.5\n"
"int21_UAGUAUG 5.5\n"
"int21_UAGUCAU 5.5\n"
"int21_UAGUCCG 4.8\n"
"int21_UAGUCGC 4.8\n"
"int21_UAGUCGU 5.5\n"
"int21_UAGUCUA 5.5\n"
"int21_UAGUCUG 5.5\n"
"int21_UAGUGAU 5.5\n"
"int21_UAGUGCG 4.8\n"
"int21_UAGUGGC 4.8\n"
"int21_UAGUGGU 5.5\n"
"int21_UAGUGUA 5.5\n"
"int21_UAGUGUG 5.5\n"
"int21_UAGUUAU 5.5\n"
"int21_UAGUUCG 4.8\n"
"int21_UAGUUGC 4.8\n"
"int21_UAGUUGU 5.5\n"
"int21_UAGUUUA 5.5\n"
"int21_UAGUUUG 5.5\n"
"int21_UAUAAAU 5.5\n"
"int21_UAUAACG 4.8\n"
"int21_UAUAAGC 4.8\n"
"int21_UAUAAGU 5.5\n"
"int21_UAUAAUA 5.5\n"
"int21_UAUAAUG 5.5\n"
"int21_UAUACAU 5.5\n"
"int21_UAUACCG 4.8\n"
"int21_UAUACGC 4.8\n"
"int21_UAUACGU 5.5\n"
"int21_UAUACUA 5.5\n"
"int21_UAUACUG 5.5\n"
"int21_UAUAGAU 5.5\n"
"int21_UAUAGCG 4.8\n"
"int21_UAUAGGC 4.8\n"
"int21_UAUAGGU 5.5\n"
"int21_UAUAGUA 5.5\n"
"int21_UAUAGUG 5.5\n"
"int21_UAUAUAU 5.5\n"
"int21_UAUAUCG 4.8\n"
"int21_UAUAUGC 4.8\n"
"int21_UAUAUGU 5.5\n"
"int21_UAUAUUA 5.5\n"
"int21_UAUAUUG 5.5\n"
"int21_UAUCAAU 4.0\n"
"int21_UAUCACG 3.3\n"
"int21_UAUCAGC 3.3\n"
"int21_UAUCAGU 4.0\n"
"int21_UAUCAUA 4.0\n"
"int21_UAUCAUG 4.0\n"
"int21_UAUCCAU 3.4\n"
"int21_UAUCCCG 2.7\n"
"int21_UAUCCGC 2.7\n"
"int21_UAUCCGU 3.4\n"
"int21_UAUCCUA 3.4\n"
"int21_UAUCCUG 3.4\n"
"int21_UAUCGAU 5.5\n"
"int21_UAUCGCG 4.8\n"
"int21_UAUCGGC 4.8\n"
"int21_UAUCGGU 5.5\n"
"int21_UAUCGUA 5.5\n"
"int21_UAUCGUG 5.5\n"
"int21_UAUCUAU 3.7\n"
"int21_UAUCUCG 3.0\n"
"int21_UAUCUGC 3.0\n"
"int21_UAUCUGU 3.7\n"
"int21_UAUCUUA 3.7\n"
"int21_UAUCUUG 3.7\n"
"int21_UAUGAAU 5.5\n"
"int21_UAUGACG 4.8\n"
"int21_UAUGAGC 4.8\n"
"int21_UAUGAGU 5.5\n"
"int21_UAUGAUA 5.5\n"
"int21_UAUGAUG 5.5\n"
"int21_UAUGCAU 5.5\n"
"int21_UAUGCCG 4.8\n"
"int21_UAUGCGC 4.8\n"
"int21_UAUGCGU 5.5\n"
"int21_UAUGCUA 5.5\n"
"int21_UAUGCUG 5.5\n"
"int21_UAUGGAU 5.5\n"
"int21_UAUGGCG 4.8\n"
"int21_UAUGGGC 4.8\n"
"int21_UAUGGGU 5.5\n"
"int21_UAUGGUA 5.5\n"
"int21_UAUGGUG 5.5\n"
"int21_UAUGUAU 5.5\n"
"int21_UAUGUCG 4.8\n"
"int21_UAUGUGC 4.8\n"
"int21_UAUGUGU 5.5\n"
"int21_UAUGUUA 5.5\n"
"int21_UAUGUUG 5.5\n"
"int21_UAUUAAU 5.5\n"
"int21_UAUUACG 4.8\n"
"int21_UAUUAGC 4.8\n"
"int21_UAUUAGU 5.5\n"
"int21_UAUUAUA 5.5\n"
"int21_UAUUAUG 5.5\n"
"int21_UAUUCAU 3.2\n"
"int21_UAUUCCG 2.5\n"
"int21_UAUUCGC 2.5\n"
"int21_UAUUCGU 3.2\n"
"int21_UAUUCUA 3.2\n"
"int21_UAUUCUG 3.2\n"
"int21_UAUUGAU 5.5\n"
"int21_UAUUGCG 4.8\n"
"int21_UAUUGGC 4.8\n"
"int21_UAUUGGU 5.5\n"
"int21_UAUUGUA 5.5\n"
"int21_UAUUGUG 5.5\n"
"int21_UAUUUAU 2.7\n"
"int21_UAUUUCG 2.0\n"
"int21_UAUUUGC 2.0\n"
"int21_UAUUUGU 2.7\n"
"int21_UAUUUUA 2.7\n"
"int21_UAUUUUG 2.7\n"
"int21_UGAAAAU 3.9\n"
"int21_UGAAACG 3.2\n"
"int21_UGAAAGC 3.2\n"
"int21_UGAAAGU 3.9\n"
"int21_UGAAAUA 3.9\n"
"int21_UGAAAUG 3.9\n"
"int21_UGAACAU 3.7\n"
"int21_UGAACCG 3.0\n"
"int21_UGAACGC 3.0\n"
"int21_UGAACGU 3.7\n"
"int21_UGAACUA 3.7\n"
"int21_UGAACUG 3.7\n"
"int21_UGAAGAU 3.1\n"
"int21_UGAAGCG 2.4\n"
"int21_UGAAGGC 2.4\n"
"int21_UGAAGGU 3.1\n"
"int21_UGAAGUA 3.1\n"
"int21_UGAAGUG 3.1\n"
"int21_UGAAUAU 5.5\n"
"int21_UGAAUCG 4.8\n"
"int21_UGAAUGC 4.8\n"
"int21_UGAAUGU 5.5\n"
"int21_UGAAUUA 5.5\n"
"int21_UGAAUUG 5.5\n"
"int21_UGACAAU 3.8\n"
"int21_UGACACG 3.1\n"
"int21_UGACAGC 3.1\n"
"int21_UGACAGU 3.8\n"
"int21_UGACAUA 3.8\n"
"int21_UGACAUG 3.8\n"
"int21_UGACCAU 3.7\n"
"int21_UGACCCG 3.0\n"
"int21_UGACCGC 3.0\n"
"int21_UGACCGU 3.7\n"
"int21_UGACCUA 3.7\n"
"int21_UGACCUG 3.7\n"
"int21_UGACGAU 5.5\n"
"int21_UGACGCG 4.8\n"
"int21_UGACGGC 4.8\n"
"int21_UGACGGU 5.5\n"
"int21_UGACGUA 5.5\n"
"int21_UGACGUG 5.5\n"
"int21_UGACUAU 3.7\n"
"int21_UGACUCG 3.0\n"
"int21_UGACUGC 3.0\n"
"int21_UGACUGU 3.7\n"
"int21_UGACUUA 3.7\n"
"int21_UGACUUG 3.7\n"
"int21_UGAGAAU 3.2\n"
"int21_UGAGACG 2.5\n"
"int21_UGAGAGC 2.5\n"
"int21_UGAGAGU 3.2\n"
"int21_UGAGAUA 3.2\n"
"int21_UGAGAUG 3.2\n"
"int21_UGAGCAU 5.5\n"
"int21_UGAGCCG 4.8\n"
"int21_UGAGCGC 4.8\n"
"int21_UGAGCGU 5.5\n"
"int21_UGAGCUA 5.5\n"
"int21_UGAGCUG 5.5\n"
"int21_UGAGGAU 2.3\n"
"int21_UGAGGCG 1.6\n"
"int21_UGAGGGC 1.6\n"
"int21_UGAGGGU 2.3\n"
"int21_UGAGGUA 2.3\n"
"int21_UGAGGUG 2.3\n"
"int21_UGAGUAU 5.5\n"
"int21_UGAGUCG 4.8\n"
"int21_UGAGUGC 4.8\n"
"int21_UGAGUGU 5.5\n"
"int21_UGAGUUA 5.5\n"
"int21_UGAGUUG 5.5\n"
"int21_UGAUAAU 5.5\n"
"int21_UGAUACG 4.8\n"
"int21_UGAUAGC 4.8\n"
"int21_UGAUAGU 5.5\n"
"int21_UGAUAUA 5.5\n"
"int21_UGAUAUG 5.5\n"
"int21_UGAUCAU 5.5\n"
"int21_UGAUCCG 4.8\n"
"int21_UGAUCGC 4.8\n"
"int21_UGAUCGU 5.5\n"
"int21_UGAUCUA 5.5\n"
"int21_UGAUCUG 5.5\n"
"int21_UGAUGAU 5.5\n"
"int21_UGAUGCG 4.8\n"
"int21_UGAUGGC 4.8\n"
"int21_UGAUGGU 5.5\n"
"int21_UGAUGUA 5.5\n"
"int21_UGAUGUG 5.5\n"
"int21_UGAUUAU 5.5\n"
"int21_UGAUUCG 4.8\n"
"int21_UGAUUGC 4.8\n"
"int21_UGAUUGU 5.5\n"
"int21_UGAUUUA 5.5\n"
"int21_UGAUUUG 5.5\n"
"int21_UGCAAAU 3.6\n"
"int21_UGCAACG 2.9\n"
"int21_UGCAAGC 2.9\n"
"int21_UGCAAGU 3.6\n"
"int21_UGCAAUA 3.6\n"
"int21_UGCAAUG 3.6\n"
"int21_UGCACAU 3.2\n"
"int21_UGCACCG 2.5\n"
"int21_UGCACGC 2.5\n"
"int21_UGCACGU 3.2\n"
"int21_UGCACUA 3.2\n"
"int21_UGCACUG 3.2\n"
"int21_UGCAGAU 3.1\n"
"int21_UGCAGCG 2.4\n"
"int21_UGCAGGC 2.4\n"
"int21_UGCAGGU 3.1\n"
"int21_UGCAGUA 3.1\n"
"int21_UGCAGUG 3.1\n"
"int21_UGCAUAU 5.5\n"
"int21_UGCAUCG 4.8\n"
"int21_UGCAUGC 4.8\n"
"int21_UGCAUGU 5.5\n"
"int21_UGCAUUA 5.5\n"
"int21_UGCAUUG 5.5\n"
"int21_UGCCAAU 3.7\n"
"int21_UGCCACG 3.0\n"
"int21_UGCCAGC 3.0\n"
"int21_UGCCAGU 3.7\n"
"int21_UGCCAUA 3.7\n"
"int21_UGCCAUG 3.7\n"
"int21_UGCCCAU 4.0\n"
"int21_UGCCCCG 3.3\n"
"int21_UGCCCGC 3.3\n"
"int21_UGCCCGU 4.0\n"
"int21_UGCCCUA 4.0\n"
"int21_UGCCCUG 4.0\n"
"int21_UGCCGAU 5.5\n"
"int21_UGCCGCG 4.8\n"
"int21_UGCCGGC 4.8\n"
"int21_UGCCGGU 5.5\n"
"int21_UGCCGUA 5.5\n"
"int21_UGCCGUG 5.5\n"
"int21_UGCCUAU 3.7\n"
"int21_UGCCUCG 3.0\n"
"int21_UGCCUGC 3.0\n"
"int21_UGCCUGU 3.7\n"
"int21_UGCCUUA 3.7\n"
"int21_UGCCUUG 3.7\n"
"int21_UGCGAAU 5.5\n"
"int21_UGCGACG 4.8\n"
"int21_UGCGAGC 4.8\n"
"int21_UGCGAGU 5.5\n"
"int21_UGCGAUA 5.5\n"
"int21_UGCGAUG 5.5\n"
"int21_UGCGCAU 5.5\n"
"int21_UGCGCCG 4.8\n"
"int21_UGCGCGC 4.8\n"
"int21_UGCGCGU 5.5\n"
"int21_UGCGCUA 5.5\n"
"int21_UGCGCUG 5.5\n"
"int21_UGCGGAU 5.5\n"
"int21_UGCGGCG 4.8\n"
"int21_UGCGGGC 4.8\n"
"int21_UGCGGGU 5.5\n"
"int21_UGCGGUA 5.5\n"
"int21_UGCGGUG 5.5\n"
"int21_UGCGUAU 5.5\n"
"int21_UGCGUCG 4.8\n"
"int21_UGCGUGC 4.8\n"
"int21_UGCGUGU 5.5\n"
"int21_UGCGUUA 5.5\n"
"int21_UGCGUUG 5.5\n"
"int21_UGCUAAU 5.5\n"
"int21_UGCUACG 4.8\n"
"int21_UGCUAGC 4.8\n"
"int21_UGCUAGU 5.5\n"
"int21_UGCUAUA 5.5\n"
"int21_UGCUAUG 5.5\n"
"int21_UGCUCAU 3.7\n"
"int21_UGCUCCG 3.0\n"
"int21_UGCUCGC 3.0\n"
"int21_UGCUCGU 3.7\n"
"int21_UGCUCUA 3.7\n"
"int21_UGCUCUG 3.7\n"
"int21_UGCUGAU 5.5\n"
"int21_UGCUGCG 4.8\n"
"int21_UGCUGGC 4.8\n"
"int21_UGCUGGU 5.5\n"
"int21_UGCUGUA 5.5\n"
"int21_UGCUGUG 5.5\n"
"int21_UGCUUAU 2.8\n"
"int21_UGCUUCG 2.1\n"
"int21_UGCUUGC 2.1\n"
"int21_UGCUUGU 2.8\n"
"int21_UGCUUUA 2.8\n"
"int21_UGCUUUG 2.8\n"
"int21_UGGAAAU 2.5\n"
"int21_UGGAACG 1.8\n"
"int21_UGGAAGC 1.8\n"
"int21_UGGAAGU 2.5\n"
"int21_UGGAAUA 2.5\n"
"int21_UGGAAUG 2.5\n"
"int21_UGGACAU 2.1\n"
"int21_UGGACCG 1.4\n"
"int21_UGGACGC 1.4\n"
"int21_UGGACGU 2.1\n"
"int21_UGGACUA 2.1\n"
"int21_UGGACUG 2.1\n"
"int21_UGGAGAU 1.9\n"
"int21_UGGAGCG 1.2\n"
"int21_UGGAGGC 1.2\n"
"int21_UGGAGGU 1.9\n"
"int21_UGGAGUA 1.9\n"
"int21_UGGAGUG 1.9\n"
"int21_UGGAUAU 5.5\n"
"int21_UGGAUCG 4.8\n"
"int21_UGGAUGC 4.8\n"
"int21_UGGAUGU 5.5\n"
"int21_UGGAUUA 5.5\n"
"int21_UGGAUUG 5.5\n"
"int21_UGGCAAU 5.5\n"
"int21_UGGCACG 4.8\n"
"int21_UGGCAGC 4.8\n"
"int21_UGGCAGU 5.5\n"
"int21_UGGCAUA 5.5\n"
"int21_UGGCAUG 5.5\n"
"int21_UGGCCAU 5.5\n"
"int21_UGGCCCG 4.8\n"
"int21_UGGCCGC 4.8\n"
"int21_UGGCCGU 5.5\n"
"int21_UGGCCUA 5.5\n"
"int21_UGGCCUG 5.5\n"
"int21_UGGCGAU 5.5\n"
"int21_UGGCGCG 4.8\n"
"int21_UGGCGGC 4.8\n"
"int21_UGGCGGU 5.5\n"
"int21_UGGCGUA 5.5\n"
"int21_UGGCGUG 5.5\n"
"int21_UGGCUAU 5.5\n"
"int21_UGGCUCG 4.8\n"
"int21_UGGCUGC 4.8\n"
"int21_UGGCUGU 5.5\n"
"int21_UGGCUUA 5.5\n"
"int21_UGGCUUG 5.5\n"
"int21_UGGGAAU 2.3\n"
"int21_UGGGACG 1.6\n"
"int21_UGGGAGC 1.6\n"
"int21_UGGGAGU 2.3\n"
"int21_UGGGAUA 2.3\n"
"int21_UGGGAUG 2.3\n"
"int21_UGGGCAU 5.5\n"
"int21_UGGGCCG 4.8\n"
"int21_UGGGCGC 4.8\n"
"int21_UGGGCGU 5.5\n"
"int21_UGGGCUA 5.5\n"
"int21_UGGGCUG 5.5\n"
"int21_UGGGGAU 3.7\n"
"int21_UGGGGCG 3.0\n"
"int21_UGGGGGC 3.0\n"
"int21_UGGGGGU 3.7\n"
"int21_UGGGGUA 3.7\n"
"int21_UGGGGUG 3.7\n"
"int21_UGGGUAU 5.5\n"
"int21_UGGGUCG 4.8\n"
"int21_UGGGUGC 4.8\n"
"int21_UGGGUGU 5.5\n"
"int21_UGGGUUA 5.5\n"
"int21_UGGGUUG 5.5\n"
"int21_UGGUAAU 5.5\n"
"int21_UGGUACG 4.8\n"
"int21_UGGUAGC 4.8\n"
"int21_UGGUAGU 5.5\n"
"int21_UGGUAUA 5.5\n"
"int21_UGGUAUG 5.5\n"
"int21_UGGUCAU 5.5\n"
"int21_UGGUCCG 4.8\n"
"int21_UGGUCGC 4.8\n"
"int21_UGGUCGU 5.5\n"
"int21_UGGUCUA 5.5\n"
"int21_UGGUCUG 5.5\n"
"int21_UGGUGAU 5.5\n"
"int21_UGGUGCG 4.8\n"
"int21_UGGUGGC 4.8\n"
"int21_UGGUGGU 5.5\n"
"int21_UGGUGUA 5.5\n"
"int21_UGGUGUG 5.5\n"
"int21_UGGUUAU 5.5\n"
"int21_UGGUUCG 4.8\n"
"int21_UGGUUGC 4.8\n"
"int21_UGGUUGU 5.5\n"
"int21_UGGUUUA 5.5\n"
"int21_UGGUUUG 5.5\n"
"int21_UGUAAAU 5.5\n"
"int21_UGUAACG 4.8\n"
"int21_UGUAAGC 4.8\n"
"int21_UGUAAGU 5.5\n"
"int21_UGUAAUA 5.5\n"
"int21_UGUAAUG 5.5\n"
"int21_UGUACAU 5.5\n"
"int21_UGUACCG 4.8\n"
"int21_UGUACGC 4.8\n"
"int21_UGUACGU 5.5\n"
"int21_UGUACUA 5.5\n"
"int21_UGUACUG 5.5\n"
"int21_UGUAGAU 5.5\n"
"int21_UGUAGCG 4.8\n"
"int21_UGUAGGC 4.8\n"
"int21_UGUAGGU 5.5\n"
"int21_UGUAGUA 5.5\n"
"int21_UGUAGUG 5.5\n"
"int21_UGUAUAU 5.5\n"
"int21_UGUAUCG 4.8\n"
"int21_UGUAUGC 4.8\n"
"int21_UGUAUGU 5.5\n"
"int21_UGUAUUA 5.5\n"
"int21_UGUAUUG 5.5\n"
"int21_UGUCAAU 4.0\n"
"int21_UGUCACG 3.3\n"
"int21_UGUCAGC 3.3\n"
"int21_UGUCAGU 4.0\n"
"int21_UGUCAUA 4.0\n"
"int21_UGUCAUG 4.0\n"
"int21_UGUCCAU 3.4\n"
"int21_UGUCCCG 2.7\n"
"int21_UGUCCGC 2.7\n"
"int21_UGUCCGU 3.4\n"
"int21_UGUCCUA 3.4\n"
"int21_UGUCCUG 3.4\n"
"int21_UGUCGAU 5.5\n"
"int21_UGUCGCG 4.8\n"
"int21_UGUCGGC 4.8\n"
"int21_UGUCGGU 5.5\n"
"int21_UGUCGUA 5.5\n"
"int21_UGUCGUG 5.5\n"
"int21_UGUCUAU 3.7\n"
"int21_UGUCUCG 3.0\n"
"int21_UGUCUGC 3.0\n"
"int21_UGUCUGU 3.7\n"
"int21_UGUCUUA 3.7\n"
"int21_UGUCUUG 3.7\n"
"int21_UGUGAAU 5.5\n"
"int21_UGUGACG 4.8\n"
"int21_UGUGAGC 4.8\n"
"int21_UGUGAGU 5.5\n"
"int21_UGUGAUA 5.5\n"
"int21_UGUGAUG 5.5\n"
"int21_UGUGCAU 5.5\n"
"int21_UGUGCCG 4.8\n"
"int21_UGUGCGC 4.8\n"
"int21_UGUGCGU 5.5\n"
"int21_UGUGCUA 5.5\n"
"int21_UGUGCUG 5.5\n"
"int21_UGUGGAU 5.5\n"
"int21_UGUGGCG 4.8\n"
"int21_UGUGGGC 4.8\n"
"int21_UGUGGGU 5.5\n"
"int21_UGUGGUA 5.5\n"
"int21_UGUGGUG 5.5\n"
"int21_UGUGUAU 5.5\n"
"int21_UGUGUCG 4.8\n"
"int21_UGUGUGC 4.8\n"
"int21_UGUGUGU 5.5\n"
"int21_UGUGUUA 5.5\n"
"int21_UGUGUUG 5.5\n"
"int21_UGUUAAU 5.5\n"
"int21_UGUUACG 4.8\n"
"int21_UGUUAGC 4.8\n"
"int21_UGUUAGU 5.5\n"
"int21_UGUUAUA 5.5\n"
"int21_UGUUAUG 5.5\n"
"int21_UGUUCAU 3.2\n"
"int21_UGUUCCG 2.5\n"
"int21_UGUUCGC 2.5\n"
"int21_UGUUCGU 3.2\n"
"int21_UGUUCUA 3.2\n"
"int21_UGUUCUG 3.2\n"
"int21_UGUUGAU 5.5\n"
"int21_UGUUGCG 4.8\n"
"int21_UGUUGGC 4.8\n"
"int21_UGUUGGU 5.5\n"
"int21_UGUUGUA 5.5\n"
"int21_UGUUGUG 5.5\n"
"int21_UGUUUAU 2.7\n"
"int21_UGUUUCG 2.0\n"
"int21_UGUUUGC 2.0\n"
"int21_UGUUUGU 2.7\n"
"int21_UGUUUUA 2.7\n"
"int21_UGUUUUG 2.7\n"
"int22_AUAAAAAU 2.8\n"
"int22_AUAAAACG 2.0\n"
"int22_AUAAAAGC 2.1\n"
"int22_AUAAAAGU 2.8\n"
"int22_AUAAAAUA 2.8\n"
"int22_AUAAAAUG 2.8\n"
"int22_AUAAACAU 2.6\n"
"int22_AUAAACCG 2.4\n"
"int22_AUAAACGC 1.8\n"
"int22_AUAAACGU 2.6\n"
"int22_AUAAACUA 2.8\n"
"int22_AUAAACUG 2.8\n"
"int22_AUAAAGAU 1.5\n"
"int22_AUAAAGCG 1.0\n"
"int22_AUAAAGGC 0.7\n"
"int22_AUAAAGGU 1.5\n"
"int22_AUAAAGUA 1.7\n"
"int22_AUAAAGUG 1.7\n"
"int22_AUAAAUAU 2.0\n"
"int22_AUAAAUCG 2.0\n"
"int22_AUAAAUGC 2.0\n"
"int22_AUAAAUGU 2.0\n"
"int22_AUAAAUUA 2.0\n"
"int22_AUAAAUUG 2.0\n"
"int22_AUAACAAU 2.5\n"
"int22_AUAACACG 1.9\n"
"int22_AUAACAGC 1.9\n"
"int22_AUAACAGU 2.5\n"
"int22_AUAACAUA 2.3\n"
"int22_AUAACAUG 2.3\n"
"int22_AUAACCAU 3.1\n"
"int22_AUAACCCG 2.8\n"
"int22_AUAACCGC 2.5\n"
"int22_AUAACCGU 3.1\n"
"int22_AUAACCUA 3.4\n"
"int22_AUAACCUG 3.4\n"
"int22_AUAACGAU 2.0\n"
"int22_AUAACGCG 2.0\n"
"int22_AUAACGGC 2.0\n"
"int22_AUAACGGU 2.0\n"
"int22_AUAACGUA 2.0\n"
"int22_AUAACGUG 2.0\n"
"int22_AUAACUAU 3.1\n"
"int22_AUAACUCG 2.7\n"
"int22_AUAACUGC 2.5\n"
"int22_AUAACUGU 3.1\n"
"int22_AUAACUUA 3.1\n"
"int22_AUAACUUG 3.1\n"
"int22_AUAAGAAU 1.5\n"
"int22_AUAAGACG 1.0\n"
"int22_AUAAGAGC 0.1\n"
"int22_AUAAGAGU 1.5\n"
"int22_AUAAGAUA 1.7\n"
"int22_AUAAGAUG 1.7\n"
"int22_AUAAGCAU 2.0\n"
"int22_AUAAGCCG 2.0\n"
"int22_AUAAGCGC 2.0\n"
"int22_AUAAGCGU 2.0\n"
"int22_AUAAGCUA 2.0\n"
"int22_AUAAGCUG 2.0\n"
"int22_AUAAGGAU 2.1\n"
"int22_AUAAGGCG 1.8\n"
"int22_AUAAGGGC 1.8\n"
"int22_AUAAGGGU 2.1\n"
"int22_AUAAGGUA 2.1\n"
"int22_AUAAGGUG 2.1\n"
"int22_AUAAGUAU 2.3\n"
"int22_AUAAGUCG 1.8\n"
"int22_AUAAGUGC 0.4\n"
"int22_AUAAGUGU 2.3\n"
"int22_AUAAGUUA 2.2\n"
"int22_AUAAGUUG 2.2\n"
"int22_AUAAUAAU 2.0\n"
"int22_AUAAUACG 2.0\n"
"int22_AUAAUAGC 2.0\n"
"int22_AUAAUAGU 2.0\n"
"int22_AUAAUAUA 2.0\n"
"int22_AUAAUAUG 2.0\n"
"int22_AUAAUCAU 3.1\n"
"int22_AUAAUCCG 2.7\n"
"int22_AUAAUCGC 1.5\n"
"int22_AUAAUCGU 3.1\n"
"int22_AUAAUCUA 3.4\n"
"int22_AUAAUCUG 3.4\n"
"int22_AUAAUGAU 1.3\n"
"int22_AUAAUGCG 0.3\n"
"int22_AUAAUGGC 0.0\n"
"int22_AUAAUGGU 1.3\n"
"int22_AUAAUGUA 1.0\n"
"int22_AUAAUGUG 1.0\n"
"int22_AUAAUUAU 2.7\n"
"int22_AUAAUUCG 2.2\n"
"int22_AUAAUUGC 2.1\n"
"int22_AUAAUUGU 2.7\n"
"int22_AUAAUUUA 2.9\n"
"int22_AUAAUUUG 2.9\n"
"int22_AUACAACG 1.9\n"
"int22_AUACAAGC 2.0\n"
"int22_AUACAAGU 2.6\n"
"int22_AUACAAUA 2.6\n"
"int22_AUACAAUG 2.6\n"
"int22_AUACACAU 2.5\n"
"int22_AUACACCG 2.2\n"
"int22_AUACACGC 1.7\n"
"int22_AUACACGU 2.5\n"
"int22_AUACACUA 2.6\n"
"int22_AUACACUG 2.6\n"
"int22_AUACAGAU 1.4\n"
"int22_AUACAGCG 0.9\n"
"int22_AUACAGGC 0.6\n"
"int22_AUACAGGU 1.4\n"
"int22_AUACAGUA 1.6\n"
"int22_AUACAGUG 1.6\n"
"int22_AUACAUAU 2.0\n"
"int22_AUACAUCG 2.0\n"
"int22_AUACAUGC 2.0\n"
"int22_AUACAUGU 2.0\n"
"int22_AUACAUUA 2.0\n"
"int22_AUACAUUG 2.0\n"
"int22_AUACCAAU 2.4\n"
"int22_AUACCACG 1.8\n"
"int22_AUACCAGC 1.7\n"
"int22_AUACCAGU 2.4\n"
"int22_AUACCAUA 2.2\n"
"int22_AUACCAUG 2.2\n"
"int22_AUACCCAU 2.3\n"
"int22_AUACCCCG 2.1\n"
"int22_AUACCCGC 1.7\n"
"int22_AUACCCGU 2.3\n"
"int22_AUACCCUA 2.6\n"
"int22_AUACCCUG 2.6\n"
"int22_AUACCGAU 2.0\n"
"int22_AUACCGCG 2.0\n"
"int22_AUACCGGC 2.0\n"
"int22_AUACCGGU 2.0\n"
"int22_AUACCGUA 2.0\n"
"int22_AUACCGUG 2.0\n"
"int22_AUACCUAU 2.3\n"
"int22_AUACCUCG 1.9\n"
"int22_AUACCUGC 1.8\n"
"int22_AUACCUGU 2.3\n"
"int22_AUACCUUA 2.3\n"
"int22_AUACCUUG 2.3\n"
"int22_AUACGAAU 1.4\n"
"int22_AUACGACG 0.9\n"
"int22_AUACGAGC 0.0\n"
"int22_AUACGAGU 1.4\n"
"int22_AUACGAUA 1.6\n"
"int22_AUACGAUG 1.6\n"
"int22_AUACGCAU 2.0\n"
"int22_AUACGCCG 2.0\n"
"int22_AUACGCGC 2.0\n"
"int22_AUACGCGU 2.0\n"
"int22_AUACGCUA 2.0\n"
"int22_AUACGCUG 2.0\n"
"int22_AUACGGAU 1.9\n"
"int22_AUACGGCG 1.6\n"
"int22_AUACGGGC 1.6\n"
"int22_AUACGGGU 1.9\n"
"int22_AUACGGUA 2.0\n"
"int22_AUACGGUG 2.0\n"
"int22_AUACGUAU 1.2\n"
"int22_AUACGUCG 0.7\n"
"int22_AUACGUGC -0.8\n"
"int22_AUACGUGU 1.2\n"
"int22_AUACGUUA 1.1\n"
"int22_AUACGUUG 1.1\n"
"int22_AUACUAAU 2.0\n"
"int22_AUACUACG 2.0\n"
"int22_AUACUAGC 2.0\n"
"int22_AUACUAGU 2.0\n"
"int22_AUACUAUA 2.0\n"
"int22_AUACUAUG 2.0\n"
"int22_AUACUCAU 2.3\n"
"int22_AUACUCCG 1.9\n"
"int22_AUACUCGC 0.7\n"
"int22_AUACUCGU 2.3\n"
"int22_AUACUCUA 2.6\n"
"int22_AUACUCUG 2.6\n"
"int22_AUACUGAU 0.2\n"
"int22_AUACUGCG -0.8\n"
"int22_AUACUGGC -1.2\n"
"int22_AUACUGGU 0.2\n"
"int22_AUACUGUA -0.2\n"
"int22_AUACUGUG -0.2\n"
"int22_AUACUUAU 1.5\n"
"int22_AUACUUCG 1.0\n"
"int22_AUACUUGC 1.0\n"
"int22_AUACUUGU 1.5\n"
"int22_AUACUUUA 1.8\n"
"int22_AUACUUUG 1.8\n"
"int22_AUAGAACG 0.8\n"
"int22_AUAGAAGC 0.9\n"
"int22_AUAGAAGU 1.5\n"
"int22_AUAGAAUA 1.5\n"
"int22_AUAGAAUG 1.5\n"
"int22_AUAGACCG 1.1\n"
"int22_AUAGACGC 0.6\n"
"int22_AUAGACGU 1.4\n"
"int22_AUAGACUA 1.5\n"
"int22_AUAGACUG 1.5\n"
"int22_AUAGAGAU 0.3\n"
"int22_AUAGAGCG -0.2\n"
"int22_AUAGAGGC -0.5\n"
"int22_AUAGAGGU 0.3\n"
"int22_AUAGAGUA 0.5\n"
"int22_AUAGAGUG 0.5\n"
"int22_AUAGAUAU 2.0\n"
"int22_AUAGAUCG 2.0\n"
"int22_AUAGAUGC 2.0\n"
"int22_AUAGAUGU 2.0\n"
"int22_AUAGAUUA 2.0\n"
"int22_AUAGAUUG 2.0\n"
"int22_AUAGCAAU 1.3\n"
"int22_AUAGCACG 0.7\n"
"int22_AUAGCAGC 0.6\n"
"int22_AUAGCAGU 1.3\n"
"int22_AUAGCAUA 1.1\n"
"int22_AUAGCAUG 1.1\n"
"int22_AUAGCCAU 2.2\n"
"int22_AUAGCCCG 2.0\n"
"int22_AUAGCCGC 1.6\n"
"int22_AUAGCCGU 2.2\n"
"int22_AUAGCCUA 2.5\n"
"int22_AUAGCCUG 2.5\n"
"int22_AUAGCGAU 2.0\n"
"int22_AUAGCGCG 2.0\n"
"int22_AUAGCGGC 2.0\n"
"int22_AUAGCGGU 2.0\n"
"int22_AUAGCGUA 2.0\n"
"int22_AUAGCGUG 2.0\n"
"int22_AUAGCUAU 2.2\n"
"int22_AUAGCUCG 1.8\n"
"int22_AUAGCUGC 1.7\n"
"int22_AUAGCUGU 2.2\n"
"int22_AUAGCUUA 2.2\n"
"int22_AUAGCUUG 2.2\n"
"int22_AUAGGAAU 0.3\n"
"int22_AUAGGACG -0.2\n"
"int22_AUAGGAGC -1.1\n"
"int22_AUAGGAGU 0.3\n"
"int22_AUAGGAUA 0.5\n"
"int22_AUAGGAUG 0.5\n"
"int22_AUAGGCAU 2.0\n"
"int22_AUAGGCCG 2.0\n"
"int22_AUAGGCGC 2.0\n"
"int22_AUAGGCGU 2.0\n"
"int22_AUAGGCUA 2.0\n"
"int22_AUAGGCUG 2.0\n"
"int22_AUAGGGAU 0.8\n"
"int22_AUAGGGCG 0.5\n"
"int22_AUAGGGGC 0.5\n"
"int22_AUAGGGGU 0.8\n"
"int22_AUAGGGUA 0.9\n"
"int22_AUAGGGUG 0.9\n"
"int22_AUAGGUAU 1.9\n"
"int22_AUAGGUCG 1.4\n"
"int22_AUAGGUGC -0.1\n"
"int22_AUAGGUGU 1.9\n"
"int22_AUAGGUUA 1.8\n"
"int22_AUAGGUUG 1.8\n"
"int22_AUAGUAAU 2.0\n"
"int22_AUAGUACG 2.0\n"
"int22_AUAGUAGC 2.0\n"
"int22_AUAGUAGU 2.0\n"
"int22_AUAGUAUA 2.0\n"
"int22_AUAGUAUG 2.0\n"
"int22_AUAGUCAU 2.2\n"
"int22_AUAGUCCG 1.8\n"
"int22_AUAGUCGC 0.7\n"
"int22_AUAGUCGU 2.2\n"
"int22_AUAGUCUA 2.5\n"
"int22_AUAGUCUG 2.5\n"
"int22_AUAGUGAU 0.9\n"
"int22_AUAGUGCG -0.1\n"
"int22_AUAGUGGC -0.5\n"
"int22_AUAGUGGU 0.9\n"
"int22_AUAGUGUA 0.5\n"
"int22_AUAGUGUG 0.5\n"
"int22_AUAGUUAU 2.2\n"
"int22_AUAGUUCG 1.8\n"
"int22_AUAGUUGC 1.7\n"
"int22_AUAGUUGU 2.2\n"
"int22_AUAGUUUA 2.5\n"
"int22_AUAGUUUG 2.5\n"
"int22_AUAUAACG 2.0\n"
"int22_AUAUAAGC 2.0\n"
"int22_AUAUAAGU 2.0\n"
"int22_AUAUAAUA 2.0\n"
"int22_AUAUAAUG 2.0\n"
"int22_AUAUACCG 2.0\n"
"int22_AUAUACGC 2.0\n"
"int22_AUAUACGU 2.0\n"
"int22_AUAUACUA 2.0\n"
"int22_AUAUACUG 2.0\n"
"int22_AUAUAGCG 2.0\n"
"int22_AUAUAGGC 2.0\n"
"int22_AUAUAGGU 2.0\n"
"int22_AUAUAGUA 2.0\n"
"int22_AUAUAGUG 2.0\n"
"int22_AUAUAUAU 2.0\n"
"int22_AUAUAUCG 2.0\n"
"int22_AUAUAUGC 2.0\n"
"int22_AUAUAUGU 2.0\n"
"int22_AUAUAUUA 2.0\n"
"int22_AUAUAUUG 2.0\n"
"int22_AUAUCAAU 2.0\n"
"int22_AUAUCACG 2.0\n"
"int22_AUAUCAGC 2.0\n"
"int22_AUAUCAGU 2.0\n"
"int22_AUAUCAUA 2.0\n"
"int22_AUAUCAUG 2.0\n"
"int22_AUAUCCAU 2.0\n"
"int22_AUAUCCCG 2.0\n"
"int22_AUAUCCGC 2.0\n"
"int22_AUAUCCGU 2.0\n"
"int22_AUAUCCUA 2.0\n"
"int22_AUAUCCUG 2.0\n"
"int22_AUAUCGAU 2.0\n"
"int22_AUAUCGCG 2.0\n"
"int22_AUAUCGGC 2.0\n"
"int22_AUAUCGGU 2.0\n"
"int22_AUAUCGUA 2.0\n"
"int22_AUAUCGUG 2.0\n"
"int22_AUAUCUAU 2.0\n"
"int22_AUAUCUCG 2.0\n"
"int22_AUAUCUGC 2.0\n"
"int22_AUAUCUGU 2.0\n"
"int22_AUAUCUUA 2.0\n"
"int22_AUAUCUUG 2.0\n"
"int22_AUAUGAAU 2.0\n"
"int22_AUAUGACG 2.0\n"
"int22_AUAUGAGC 2.0\n"
"int22_AUAUGAGU 2.0\n"
"int22_AUAUGAUA 2.0\n"
"int22_AUAUGAUG 2.0\n"
"int22_AUAUGCAU 2.0\n"
"int22_AUAUGCCG 2.0\n"
"int22_AUAUGCGC 2.0\n"
"int22_AUAUGCGU 2.0\n"
"int22_AUAUGCUA 2.0\n"
"int22_AUAUGCUG 2.0\n"
"int22_AUAUGGAU 2.0\n"
"int22_AUAUGGCG 2.0\n"
"int22_AUAUGGGC 2.0\n"
"int22_AUAUGGGU 2.0\n"
"int22_AUAUGGUA 2.0\n"
"int22_AUAUGGUG 2.0\n"
"int22_AUAUGUAU 2.0\n"
"int22_AUAUGUCG 2.0\n"
"int22_AUAUGUGC 2.0\n"
"int22_AUAUGUGU 2.0\n"
"int22_AUAUGUUA 2.0\n"
"int22_AUAUGUUG 2.0\n"
"int22_AUAUUAAU 2.0\n"
"int22_AUAUUACG 2.0\n"
"int22_AUAUUAGC 2.0\n"
"int22_AUAUUAGU 2.0\n"
"int22_AUAUUAUA 2.0\n"
"int22_AUAUUAUG 2.0\n"
"int22_AUAUUCAU 2.0\n"
"int22_AUAUUCCG 2.0\n"
"int22_AUAUUCGC 2.0\n"
"int22_AUAUUCGU 2.0\n"
"int22_AUAUUCUA 2.0\n"
"int22_AUAUUCUG 2.0\n"
"int22_AUAUUGAU 2.0\n"
"int22_AUAUUGCG 2.0\n"
"int22_AUAUUGGC 2.0\n"
"int22_AUAUUGGU 2.0\n"
"int22_AUAUUGUA 2.0\n"
"int22_AUAUUGUG 2.0\n"
"int22_AUAUUUAU 2.0\n"
"int22_AUAUUUCG 2.0\n"
"int22_AUAUUUGC 2.0\n"
"int22_AUAUUUGU 2.0\n"
"int22_AUAUUUUA 2.0\n"
"int22_AUAUUUUG 2.0\n"
"int22_AUCAAACG 1.8\n"
"int22_AUCAAAGC 1.9\n"
"int22_AUCAAAGU 2.5\n"
"int22_AUCAAAUA 2.5\n"
"int22_AUCAAAUG 2.5\n"
"int22_AUCAACCG 2.1\n"
"int22_AUCAACGC 1.6\n"
"int22_AUCAACGU 2.4\n"
"int22_AUCAACUA 2.5\n"
"int22_AUCAACUG 2.5\n"
"int22_AUCAAGCG 0.8\n"
"int22_AUCAAGGC 0.5\n"
"int22_AUCAAGGU 1.3\n"
"int22_AUCAAGUA 1.5\n"
"int22_AUCAAGUG 1.5\n"
"int22_AUCAAUCG 2.0\n"
"int22_AUCAAUGC 2.0\n"
"int22_AUCAAUGU 2.0\n"
"int22_AUCAAUUA 2.0\n"
"int22_AUCAAUUG 2.0\n"
"int22_AUCACAAU 2.3\n"
"int22_AUCACACG 1.7\n"
"int22_AUCACAGC 1.6\n"
"int22_AUCACAGU 2.3\n"
"int22_AUCACAUA 2.1\n"
"int22_AUCACAUG 2.1\n"
"int22_AUCACCAU 2.2\n"
"int22_AUCACCCG 2.0\n"
"int22_AUCACCGC 1.6\n"
"int22_AUCACCGU 2.2\n"
"int22_AUCACCUA 2.5\n"
"int22_AUCACCUG 2.5\n"
"int22_AUCACGAU 2.0\n"
"int22_AUCACGCG 2.0\n"
"int22_AUCACGGC 2.0\n"
"int22_AUCACGGU 2.0\n"
"int22_AUCACGUA 2.0\n"
"int22_AUCACGUG 2.0\n"
"int22_AUCACUAU 2.2\n"
"int22_AUCACUCG 1.8\n"
"int22_AUCACUGC 1.7\n"
"int22_AUCACUGU 2.2\n"
"int22_AUCACUUA 2.2\n"
"int22_AUCACUUG 2.2\n"
"int22_AUCAGAAU 1.3\n"
"int22_AUCAGACG 0.8\n"
"int22_AUCAGAGC -0.1\n"
"int22_AUCAGAGU 1.3\n"
"int22_AUCAGAUA 1.5\n"
"int22_AUCAGAUG 1.5\n"
"int22_AUCAGCAU 2.0\n"
"int22_AUCAGCCG 2.0\n"
"int22_AUCAGCGC 2.0\n"
"int22_AUCAGCGU 2.0\n"
"int22_AUCAGCUA 2.0\n"
"int22_AUCAGCUG 2.0\n"
"int22_AUCAGGAU 1.8\n"
"int22_AUCAGGCG 1.5\n"
"int22_AUCAGGGC 1.5\n"
"int22_AUCAGGGU 1.8\n"
"int22_AUCAGGUA 1.9\n"
"int22_AUCAGGUG 1.9\n"
"int22_AUCAGUAU 1.1\n"
"int22_AUCAGUCG 0.6\n"
"int22_AUCAGUGC -0.9\n"
"int22_AUCAGUGU 1.1\n"
"int22_AUCAGUUA 1.0\n"
"int22_AUCAGUUG 1.0\n"
"int22_AUCAUAAU 2.0\n"
"int22_AUCAUACG 2.0\n"
"int22_AUCAUAGC 2.0\n"
"int22_AUCAUAGU 2.0\n"
"int22_AUCAUAUA 2.0\n"
"int22_AUCAUAUG 2.0\n"
"int22_AUCAUCAU 2.2\n"
"int22_AUCAUCCG 1.8\n"
"int22_AUCAUCGC 0.6\n"
"int22_AUCAUCGU 2.2\n"
"int22_AUCAUCUA 2.5\n"
"int22_AUCAUCUG 2.5\n"
"int22_AUCAUGAU 0.1\n"
"int22_AUCAUGCG -0.9\n"
"int22_AUCAUGGC -1.3\n"
"int22_AUCAUGGU 0.1\n"
"int22_AUCAUGUA -0.3\n"
"int22_AUCAUGUG -0.3\n"
"int22_AUCAUUAU 1.4\n"
"int22_AUCAUUCG 0.9\n"
"int22_AUCAUUGC 0.9\n"
"int22_AUCAUUGU 1.4\n"
"int22_AUCAUUUA 1.7\n"
"int22_AUCAUUUG 1.7\n"
"int22_AUCCAACG 2.3\n"
"int22_AUCCAAGC 2.4\n"
"int22_AUCCAAGU 3.1\n"
"int22_AUCCAAUA 3.1\n"
"int22_AUCCAAUG 3.1\n"
"int22_AUCCACCG 2.1\n"
"int22_AUCCACGC 1.5\n"
"int22_AUCCACGU 2.3\n"
"int22_AUCCACUA 2.5\n"
"int22_AUCCACUG 2.5\n"
"int22_AUCCAGCG 1.7\n"
"int22_AUCCAGGC 1.4\n"
"int22_AUCCAGGU 2.2\n"
"int22_AUCCAGUA 2.4\n"
"int22_AUCCAGUG 2.4\n"
"int22_AUCCAUCG 2.0\n"
"int22_AUCCAUGC 2.0\n"
"int22_AUCCAUGU 2.0\n"
"int22_AUCCAUUA 2.0\n"
"int22_AUCCAUUG 2.0\n"
"int22_AUCCCACG 1.6\n"
"int22_AUCCCAGC 1.6\n"
"int22_AUCCCAGU 2.2\n"
"int22_AUCCCAUA 2.0\n"
"int22_AUCCCAUG 2.0\n"
"int22_AUCCCCAU 2.2\n"
"int22_AUCCCCCG 1.9\n"
"int22_AUCCCCGC 1.6\n"
"int22_AUCCCCGU 2.2\n"
"int22_AUCCCCUA 2.5\n"
"int22_AUCCCCUG 2.5\n"
"int22_AUCCCGAU 2.0\n"
"int22_AUCCCGCG 2.0\n"
"int22_AUCCCGGC 2.0\n"
"int22_AUCCCGGU 2.0\n"
"int22_AUCCCGUA 2.0\n"
"int22_AUCCCGUG 2.0\n"
"int22_AUCCCUAU 2.2\n"
"int22_AUCCCUCG 1.8\n"
"int22_AUCCCUGC 1.6\n"
"int22_AUCCCUGU 2.2\n"
"int22_AUCCCUUA 2.2\n"
"int22_AUCCCUUG 2.2\n"
"int22_AUCCGAAU 2.2\n"
"int22_AUCCGACG 1.7\n"
"int22_AUCCGAGC 0.8\n"
"int22_AUCCGAGU 2.2\n"
"int22_AUCCGAUA 2.4\n"
"int22_AUCCGAUG 2.4\n"
"int22_AUCCGCAU 2.0\n"
"int22_AUCCGCCG 2.0\n"
"int22_AUCCGCGC 2.0\n"
"int22_AUCCGCGU 2.0\n"
"int22_AUCCGCUA 2.0\n"
"int22_AUCCGCUG 2.0\n"
"int22_AUCCGGAU 2.4\n"
"int22_AUCCGGCG 2.1\n"
"int22_AUCCGGGC 2.1\n"
"int22_AUCCGGGU 2.4\n"
"int22_AUCCGGUA 2.4\n"
"int22_AUCCGGUG 2.4\n"
"int22_AUCCGUAU 2.0\n"
"int22_AUCCGUCG 1.5\n"
"int22_AUCCGUGC 0.1\n"
"int22_AUCCGUGU 2.0\n"
"int22_AUCCGUUA 1.9\n"
"int22_AUCCGUUG 1.9\n"
"int22_AUCCUAAU 2.0\n"
"int22_AUCCUACG 2.0\n"
"int22_AUCCUAGC 2.0\n"
"int22_AUCCUAGU 2.0\n"
"int22_AUCCUAUA 2.0\n"
"int22_AUCCUAUG 2.0\n"
"int22_AUCCUCAU 2.2\n"
"int22_AUCCUCCG 1.8\n"
"int22_AUCCUCGC 0.6\n"
"int22_AUCCUCGU 2.2\n"
"int22_AUCCUCUA 2.5\n"
"int22_AUCCUCUG 2.5\n"
"int22_AUCCUGAU 1.0\n"
"int22_AUCCUGCG 0.0\n"
"int22_AUCCUGGC -0.3\n"
"int22_AUCCUGGU 1.0\n"
"int22_AUCCUGUA 0.7\n"
"int22_AUCCUGUG 0.7\n"
"int22_AUCCUUAU 1.4\n"
"int22_AUCCUUCG 0.9\n"
"int22_AUCCUUGC 0.8\n"
"int22_AUCCUUGU 1.4\n"
"int22_AUCCUUUA 1.6\n"
"int22_AUCCUUUG 1.6\n"
"int22_AUCGAACG 2.0\n"
"int22_AUCGAAGC 2.0\n"
"int22_AUCGAAGU 2.0\n"
"int22_AUCGAAUA 2.0\n"
"int22_AUCGAAUG 2.0\n"
"int22_AUCGACCG 2.0\n"
"int22_AUCGACGC 2.0\n"
"int22_AUCGACGU 2.0\n"
"int22_AUCGACUA 2.0\n"
"int22_AUCGACUG 2.0\n"
"int22_AUCGAGCG 2.0\n"
"int22_AUCGAGGC 2.0\n"
"int22_AUCGAGGU 2.0\n"
"int22_AUCGAGUA 2.0\n"
"int22_AUCGAGUG 2.0\n"
"int22_AUCGAUCG 2.0\n"
"int22_AUCGAUGC 2.0\n"
"int22_AUCGAUGU 2.0\n"
"int22_AUCGAUUA 2.0\n"
"int22_AUCGAUUG 2.0\n"
"int22_AUCGCACG 2.0\n"
"int22_AUCGCAGC 2.0\n"
"int22_AUCGCAGU 2.0\n"
"int22_AUCGCAUA 2.0\n"
"int22_AUCGCAUG 2.0\n"
"int22_AUCGCCCG 2.0\n"
"int22_AUCGCCGC 2.0\n"
"int22_AUCGCCGU 2.0\n"
"int22_AUCGCCUA 2.0\n"
"int22_AUCGCCUG 2.0\n"
"int22_AUCGCGAU 2.0\n"
"int22_AUCGCGCG 2.0\n"
"int22_AUCGCGGC 2.0\n"
"int22_AUCGCGGU 2.0\n"
"int22_AUCGCGUA 2.0\n"
"int22_AUCGCGUG 2.0\n"
"int22_AUCGCUAU 2.0\n"
"int22_AUCGCUCG 2.0\n"
"int22_AUCGCUGC 2.0\n"
"int22_AUCGCUGU 2.0\n"
"int22_AUCGCUUA 2.0\n"
"int22_AUCGCUUG 2.0\n"
"int22_AUCGGAAU 2.0\n"
"int22_AUCGGACG 2.0\n"
"int22_AUCGGAGC 2.0\n"
"int22_AUCGGAGU 2.0\n"
"int22_AUCGGAUA 2.0\n"
"int22_AUCGGAUG 2.0\n"
"int22_AUCGGCAU 2.0\n"
"int22_AUCGGCCG 2.0\n"
"int22_AUCGGCGC 2.0\n"
"int22_AUCGGCGU 2.0\n"
"int22_AUCGGCUA 2.0\n"
"int22_AUCGGCUG 2.0\n"
"int22_AUCGGGAU 2.0\n"
"int22_AUCGGGCG 2.0\n"
"int22_AUCGGGGC 2.0\n"
"int22_AUCGGGGU 2.0\n"
"int22_AUCGGGUA 2.0\n"
"int22_AUCGGGUG 2.0\n"
"int22_AUCGGUAU 2.0\n"
"int22_AUCGGUCG 2.0\n"
"int22_AUCGGUGC 2.0\n"
"int22_AUCGGUGU 2.0\n"
"int22_AUCGGUUA 2.0\n"
"int22_AUCGGUUG 2.0\n"
"int22_AUCGUAAU 2.0\n"
"int22_AUCGUACG 2.0\n"
"int22_AUCGUAGC 2.0\n"
"int22_AUCGUAGU 2.0\n"
"int22_AUCGUAUA 2.0\n"
"int22_AUCGUAUG 2.0\n"
"int22_AUCGUCAU 2.0\n"
"int22_AUCGUCCG 2.0\n"
"int22_AUCGUCGC 2.0\n"
"int22_AUCGUCGU 2.0\n"
"int22_AUCGUCUA 2.0\n"
"int22_AUCGUCUG 2.0\n"
"int22_AUCGUGAU 2.0\n"
"int22_AUCGUGCG 2.0\n"
"int22_AUCGUGGC 2.0\n"
"int22_AUCGUGGU 2.0\n"
"int22_AUCGUGUA 2.0\n"
"int22_AUCGUGUG 2.0\n"
"int22_AUCGUUAU 2.0\n"
"int22_AUCGUUCG 2.0\n"
"int22_AUCGUUGC 2.0\n"
"int22_AUCGUUGU 2.0\n"
"int22_AUCGUUUA 2.0\n"
"int22_AUCGUUUG 2.0\n"
"int22_AUCUAACG 2.3\n"
"int22_AUCUAAGC 2.4\n"
"int22_AUCUAAGU 3.1\n"
"int22_AUCUAAUA 3.1\n"
"int22_AUCUAAUG 3.1\n"
"int22_AUCUACCG 2.1\n"
"int22_AUCUACGC 1.5\n"
"int22_AUCUACGU 2.3\n"
"int22_AUCUACUA 2.5\n"
"int22_AUCUACUG 2.5\n"
"int22_AUCUAGCG 1.7\n"
"int22_AUCUAGGC 1.4\n"
"int22_AUCUAGGU 2.2\n"
"int22_AUCUAGUA 2.4\n"
"int22_AUCUAGUG 2.4\n"
"int22_AUCUAUCG 2.0\n"
"int22_AUCUAUGC 2.0\n"
"int22_AUCUAUGU 2.0\n"
"int22_AUCUAUUA 2.0\n"
"int22_AUCUAUUG 2.0\n"
"int22_AUCUCACG 1.6\n"
"int22_AUCUCAGC 1.6\n"
"int22_AUCUCAGU 2.2\n"
"int22_AUCUCAUA 2.0\n"
"int22_AUCUCAUG 2.0\n"
"int22_AUCUCCCG 1.9\n"
"int22_AUCUCCGC 1.6\n"
"int22_AUCUCCGU 2.2\n"
"int22_AUCUCCUA 2.5\n"
"int22_AUCUCCUG 2.5\n"
"int22_AUCUCGCG 2.0\n"
"int22_AUCUCGGC 2.0\n"
"int22_AUCUCGGU 2.0\n"
"int22_AUCUCGUA 2.0\n"
"int22_AUCUCGUG 2.0\n"
"int22_AUCUCUAU 2.2\n"
"int22_AUCUCUCG 1.8\n"
"int22_AUCUCUGC 1.6\n"
"int22_AUCUCUGU 2.2\n"
"int22_AUCUCUUA 2.2\n"
"int22_AUCUCUUG 2.2\n"
"int22_AUCUGAAU 2.2\n"
"int22_AUCUGACG 1.7\n"
"int22_AUCUGAGC 0.8\n"
"int22_AUCUGAGU 2.2\n"
"int22_AUCUGAUA 2.4\n"
"int22_AUCUGAUG 2.4\n"
"int22_AUCUGCAU 2.0\n"
"int22_AUCUGCCG 2.0\n"
"int22_AUCUGCGC 2.0\n"
"int22_AUCUGCGU 2.0\n"
"int22_AUCUGCUA 2.0\n"
"int22_AUCUGCUG 2.0\n"
"int22_AUCUGGAU 2.4\n"
"int22_AUCUGGCG 2.1\n"
"int22_AUCUGGGC 2.1\n"
"int22_AUCUGGGU 2.4\n"
"int22_AUCUGGUA 2.4\n"
"int22_AUCUGGUG 2.4\n"
"int22_AUCUGUAU 2.0\n"
"int22_AUCUGUCG 1.5\n"
"int22_AUCUGUGC 0.1\n"
"int22_AUCUGUGU 2.0\n"
"int22_AUCUGUUA 1.9\n"
"int22_AUCUGUUG 1.9\n"
"int22_AUCUUAAU 2.0\n"
"int22_AUCUUACG 2.0\n"
"int22_AUCUUAGC 2.0\n"
"int22_AUCUUAGU 2.0\n"
"int22_AUCUUAUA 2.0\n"
"int22_AUCUUAUG 2.0\n"
"int22_AUCUUCAU 2.2\n"
"int22_AUCUUCCG 1.8\n"
"int22_AUCUUCGC 0.6\n"
"int22_AUCUUCGU 2.2\n"
"int22_AUCUUCUA 2.5\n"
"int22_AUCUUCUG 2.5\n"
"int22_AUCUUGAU 1.0\n"
"int22_AUCUUGCG 0.0\n"
"int22_AUCUUGGC -0.3\n"
"int22_AUCUUGGU 1.0\n"
"int22_AUCUUGUA 0.7\n"
"int22_AUCUUGUG 0.7\n"
"int22_AUCUUUAU 1.4\n"
"int22_AUCUUUCG 0.9\n"
"int22_AUCUUUGC 0.8\n"
"int22_AUCUUUGU 1.4\n"
"int22_AUCUUUUA 1.6\n"
"int22_AUCUUUUG 1.6\n"
"int22_AUGAAACG 0.8\n"
"int22_AUGAAAGC 0.9\n"
"int22_AUGAAAGU 1.5\n"
"int22_AUGAAAUA 1.5\n"
"int22_AUGAAAUG 1.5\n"
"int22_AUGAACCG 1.1\n"
"int22_AUGAACGC 0.6\n"
"int22_AUGAACGU 1.4\n"
"int22_AUGAACUA 1.5\n"
"int22_AUGAACUG 1.5\n"
"int22_AUGAAGCG -0.2\n"
"int22_AUGAAGGC -0.5\n"
"int22_AUGAAGGU 0.3\n"
"int22_AUGAAGUA 0.5\n"
"int22_AUGAAGUG 0.5\n"
"int22_AUGAAUCG 2.0\n"
"int22_AUGAAUGC 2.0\n"
"int22_AUGAAUGU 2.0\n"
"int22_AUGAAUUA 2.0\n"
"int22_AUGAAUUG 2.0\n"
"int22_AUGACACG 0.7\n"
"int22_AUGACAGC 0.6\n"
"int22_AUGACAGU 1.3\n"
"int22_AUGACAUA 1.1\n"
"int22_AUGACAUG 1.1\n"
"int22_AUGACCCG 2.0\n"
"int22_AUGACCGC 1.6\n"
"int22_AUGACCGU 2.2\n"
"int22_AUGACCUA 2.5\n"
"int22_AUGACCUG 2.5\n"
"int22_AUGACGCG 2.0\n"
"int22_AUGACGGC 2.0\n"
"int22_AUGACGGU 2.0\n"
"int22_AUGACGUA 2.0\n"
"int22_AUGACGUG 2.0\n"
"int22_AUGACUCG 1.8\n"
"int22_AUGACUGC 1.7\n"
"int22_AUGACUGU 2.2\n"
"int22_AUGACUUA 2.2\n"
"int22_AUGACUUG 2.2\n"
"int22_AUGAGAAU 0.3\n"
"int22_AUGAGACG -0.2\n"
"int22_AUGAGAGC -1.1\n"
"int22_AUGAGAGU 0.3\n"
"int22_AUGAGAUA 0.5\n"
"int22_AUGAGAUG 0.5\n"
"int22_AUGAGCAU 2.0\n"
"int22_AUGAGCCG 2.0\n"
"int22_AUGAGCGC 2.0\n"
"int22_AUGAGCGU 2.0\n"
"int22_AUGAGCUA 2.0\n"
"int22_AUGAGCUG 2.0\n"
"int22_AUGAGGAU 0.8\n"
"int22_AUGAGGCG 0.5\n"
"int22_AUGAGGGC 0.5\n"
"int22_AUGAGGGU 0.8\n"
"int22_AUGAGGUA 0.9\n"
"int22_AUGAGGUG 0.9\n"
"int22_AUGAGUAU 1.9\n"
"int22_AUGAGUCG 1.4\n"
"int22_AUGAGUGC -0.1\n"
"int22_AUGAGUGU 1.9\n"
"int22_AUGAGUUA 1.8\n"
"int22_AUGAGUUG 1.8\n"
"int22_AUGAUAAU 2.0\n"
"int22_AUGAUACG 2.0\n"
"int22_AUGAUAGC 2.0\n"
"int22_AUGAUAGU 2.0\n"
"int22_AUGAUAUA 2.0\n"
"int22_AUGAUAUG 2.0\n"
"int22_AUGAUCAU 2.2\n"
"int22_AUGAUCCG 1.8\n"
"int22_AUGAUCGC 0.7\n"
"int22_AUGAUCGU 2.2\n"
"int22_AUGAUCUA 2.5\n"
"int22_AUGAUCUG 2.5\n"
"int22_AUGAUGAU 0.9\n"
"int22_AUGAUGCG -0.1\n"
"int22_AUGAUGGC -0.5\n"
"int22_AUGAUGGU 0.9\n"
"int22_AUGAUGUA 0.5\n"
"int22_AUGAUGUG 0.5\n"
"int22_AUGAUUAU 2.2\n"
"int22_AUGAUUCG 1.8\n"
"int22_AUGAUUGC 1.7\n"
"int22_AUGAUUGU 2.2\n"
"int22_AUGAUUUA 2.5\n"
"int22_AUGAUUUG 2.5\n"
"int22_AUGCAACG 2.0\n"
"int22_AUGCAAGC 2.0\n"
"int22_AUGCAAGU 2.0\n"
"int22_AUGCAAUA 2.0\n"
"int22_AUGCAAUG 2.0\n"
"int22_AUGCACCG 2.0\n"
"int22_AUGCACGC 2.0\n"
"int22_AUGCACGU 2.0\n"
"int22_AUGCACUA 2.0\n"
"int22_AUGCACUG 2.0\n"
"int22_AUGCAGCG 2.0\n"
"int22_AUGCAGGC 2.0\n"
"int22_AUGCAGGU 2.0\n"
"int22_AUGCAGUA 2.0\n"
"int22_AUGCAGUG 2.0\n"
"int22_AUGCAUCG 2.0\n"
"int22_AUGCAUGC 2.0\n"
"int22_AUGCAUGU 2.0\n"
"int22_AUGCAUUA 2.0\n"
"int22_AUGCAUUG 2.0\n"
"int22_AUGCCACG 2.0\n"
"int22_AUGCCAGC 2.0\n"
"int22_AUGCCAGU 2.0\n"
"int22_AUGCCAUA 2.0\n"
"int22_AUGCCAUG 2.0\n"
"int22_AUGCCCCG 2.0\n"
"int22_AUGCCCGC 2.0\n"
"int22_AUGCCCGU 2.0\n"
"int22_AUGCCCUA 2.0\n"
"int22_AUGCCCUG 2.0\n"
"int22_AUGCCGCG 2.0\n"
"int22_AUGCCGGC 2.0\n"
"int22_AUGCCGGU 2.0\n"
"int22_AUGCCGUA 2.0\n"
"int22_AUGCCGUG 2.0\n"
"int22_AUGCCUCG 2.0\n"
"int22_AUGCCUGC 2.0\n"
"int22_AUGCCUGU 2.0\n"
"int22_AUGCCUUA 2.0\n"
"int22_AUGCCUUG 2.0\n"
"int22_AUGCGACG 2.0\n"
"int22_AUGCGAGC 2.0\n"
"int22_AUGCGAGU 2.0\n"
"int22_AUGCGAUA 2.0\n"
"int22_AUGCGAUG 2.0\n"
"int22_AUGCGCAU 2.0\n"
"int22_AUGCGCCG 2.0\n"
"int22_AUGCGCGC 2.0\n"
"int22_AUGCGCGU 2.0\n"
"int22_AUGCGCUA 2.0\n"
"int22_AUGCGCUG 2.0\n"
"int22_AUGCGGAU 2.0\n"
"int22_AUGCGGCG 2.0\n"
"int22_AUGCGGGC 2.0\n"
"int22_AUGCGGGU 2.0\n"
"int22_AUGCGGUA 2.0\n"
"int22_AUGCGGUG 2.0\n"
"int22_AUGCGUAU 2.0\n"
"int22_AUGCGUCG 2.0\n"
"int22_AUGCGUGC 2.0\n"
"int22_AUGCGUGU 2.0\n"
"int22_AUGCGUUA 2.0\n"
"int22_AUGCGUUG 2.0\n"
"int22_AUGCUAAU 2.0\n"
"int22_AUGCUACG 2.0\n"
"int22_AUGCUAGC 2.0\n"
"int22_AUGCUAGU 2.0\n"
"int22_AUGCUAUA 2.0\n"
"int22_AUGCUAUG 2.0\n"
"int22_AUGCUCAU 2.0\n"
"int22_AUGCUCCG 2.0\n"
"int22_AUGCUCGC 2.0\n"
"int22_AUGCUCGU 2.0\n"
"int22_AUGCUCUA 2.0\n"
"int22_AUGCUCUG 2.0\n"
"int22_AUGCUGAU 2.0\n"
"int22_AUGCUGCG 2.0\n"
"int22_AUGCUGGC 2.0\n"
"int22_AUGCUGGU 2.0\n"
"int22_AUGCUGUA 2.0\n"
"int22_AUGCUGUG 2.0\n"
"int22_AUGCUUAU 2.0\n"
"int22_AUGCUUCG 2.0\n"
"int22_AUGCUUGC 2.0\n"
"int22_AUGCUUGU 2.0\n"
"int22_AUGCUUUA 2.0\n"
"int22_AUGCUUUG 2.0\n"
"int22_AUGGAACG 1.3\n"
"int22_AUGGAAGC 1.4\n"
"int22_AUGGAAGU 2.1\n"
"int22_AUGGAAUA 2.1\n"
"int22_AUGGAAUG 2.1\n"
"int22_AUGGACCG 1.7\n"
"int22_AUGGACGC 1.1\n"
"int22_AUGGACGU 1.9\n"
"int22_AUGGACUA 2.1\n"
"int22_AUGGACUG 2.1\n"
"int22_AUGGAGCG 0.3\n"
"int22_AUGGAGGC 0.0\n"
"int22_AUGGAGGU 0.8\n"
"int22_AUGGAGUA 1.0\n"
"int22_AUGGAGUG 1.0\n"
"int22_AUGGAUCG 2.0\n"
"int22_AUGGAUGC 2.0\n"
"int22_AUGGAUGU 2.0\n"
"int22_AUGGAUUA 2.0\n"
"int22_AUGGAUUG 2.0\n"
"int22_AUGGCACG 1.2\n"
"int22_AUGGCAGC 1.2\n"
"int22_AUGGCAGU 1.8\n"
"int22_AUGGCAUA 1.6\n"
"int22_AUGGCAUG 1.6\n"
"int22_AUGGCCCG 2.1\n"
"int22_AUGGCCGC 1.8\n"
"int22_AUGGCCGU 2.4\n"
"int22_AUGGCCUA 2.7\n"
"int22_AUGGCCUG 2.7\n"
"int22_AUGGCGCG 2.0\n"
"int22_AUGGCGGC 2.0\n"
"int22_AUGGCGGU 2.0\n"
"int22_AUGGCGUA 2.0\n"
"int22_AUGGCGUG 2.0\n"
"int22_AUGGCUCG 2.0\n"
"int22_AUGGCUGC 1.8\n"
"int22_AUGGCUGU 2.4\n"
"int22_AUGGCUUA 2.4\n"
"int22_AUGGCUUG 2.4\n"
"int22_AUGGGACG 0.3\n"
"int22_AUGGGAGC -0.6\n"
"int22_AUGGGAGU 0.8\n"
"int22_AUGGGAUA 1.0\n"
"int22_AUGGGAUG 1.0\n"
"int22_AUGGGCCG 2.0\n"
"int22_AUGGGCGC 2.0\n"
"int22_AUGGGCGU 2.0\n"
"int22_AUGGGCUA 2.0\n"
"int22_AUGGGCUG 2.0\n"
"int22_AUGGGGAU 1.4\n"
"int22_AUGGGGCG 1.1\n"
"int22_AUGGGGGC 1.1\n"
"int22_AUGGGGGU 1.4\n"
"int22_AUGGGGUA 1.4\n"
"int22_AUGGGGUG 1.4\n"
"int22_AUGGGUAU 1.6\n"
"int22_AUGGGUCG 1.1\n"
"int22_AUGGGUGC -0.3\n"
"int22_AUGGGUGU 1.6\n"
"int22_AUGGGUUA 1.5\n"
"int22_AUGGGUUG 1.5\n"
"int22_AUGGUAAU 2.0\n"
"int22_AUGGUACG 2.0\n"
"int22_AUGGUAGC 2.0\n"
"int22_AUGGUAGU 2.0\n"
"int22_AUGGUAUA 2.0\n"
"int22_AUGGUAUG 2.0\n"
"int22_AUGGUCAU 2.4\n"
"int22_AUGGUCCG 2.0\n"
"int22_AUGGUCGC 0.8\n"
"int22_AUGGUCGU 2.4\n"
"int22_AUGGUCUA 2.7\n"
"int22_AUGGUCUG 2.7\n"
"int22_AUGGUGAU 0.7\n"
"int22_AUGGUGCG -0.4\n"
"int22_AUGGUGGC -0.7\n"
"int22_AUGGUGGU 0.7\n"
"int22_AUGGUGUA 0.3\n"
"int22_AUGGUGUG 0.3\n"
"int22_AUGGUUAU 2.0\n"
"int22_AUGGUUCG 1.5\n"
"int22_AUGGUUGC 1.4\n"
"int22_AUGGUUGU 2.0\n"
"int22_AUGGUUUA 2.2\n"
"int22_AUGGUUUG 2.2\n"
"int22_AUGUAACG 1.6\n"
"int22_AUGUAAGC 1.7\n"
"int22_AUGUAAGU 2.3\n"
"int22_AUGUAAUA 2.3\n"
"int22_AUGUAAUG 2.3\n"
"int22_AUGUACCG 0.9\n"
"int22_AUGUACGC 0.4\n"
"int22_AUGUACGU 1.2\n"
"int22_AUGUACUA 1.3\n"
"int22_AUGUACUG 1.3\n"
"int22_AUGUAGCG 1.4\n"
"int22_AUGUAGGC 1.1\n"
"int22_AUGUAGGU 1.9\n"
"int22_AUGUAGUA 2.1\n"
"int22_AUGUAGUG 2.1\n"
"int22_AUGUAUCG 2.0\n"
"int22_AUGUAUGC 2.0\n"
"int22_AUGUAUGU 2.0\n"
"int22_AUGUAUUA 2.0\n"
"int22_AUGUAUUG 2.0\n"
"int22_AUGUCACG 0.5\n"
"int22_AUGUCAGC 0.4\n"
"int22_AUGUCAGU 1.1\n"
"int22_AUGUCAUA 0.9\n"
"int22_AUGUCAUG 0.9\n"
"int22_AUGUCCCG 1.8\n"
"int22_AUGUCCGC 1.4\n"
"int22_AUGUCCGU 2.0\n"
"int22_AUGUCCUA 2.3\n"
"int22_AUGUCCUG 2.3\n"
"int22_AUGUCGCG 2.0\n"
"int22_AUGUCGGC 2.0\n"
"int22_AUGUCGGU 2.0\n"
"int22_AUGUCGUA 2.0\n"
"int22_AUGUCGUG 2.0\n"
"int22_AUGUCUCG 1.6\n"
"int22_AUGUCUGC 1.5\n"
"int22_AUGUCUGU 2.0\n"
"int22_AUGUCUUA 2.0\n"
"int22_AUGUCUUG 2.0\n"
"int22_AUGUGACG 1.4\n"
"int22_AUGUGAGC 0.5\n"
"int22_AUGUGAGU 1.9\n"
"int22_AUGUGAUA 2.1\n"
"int22_AUGUGAUG 2.1\n"
"int22_AUGUGCCG 2.0\n"
"int22_AUGUGCGC 2.0\n"
"int22_AUGUGCGU 2.0\n"
"int22_AUGUGCUA 2.0\n"
"int22_AUGUGCUG 2.0\n"
"int22_AUGUGGCG 1.3\n"
"int22_AUGUGGGC 1.3\n"
"int22_AUGUGGGU 1.6\n"
"int22_AUGUGGUA 1.7\n"
"int22_AUGUGGUG 1.7\n"
"int22_AUGUGUAU -0.1\n"
"int22_AUGUGUCG -0.6\n"
"int22_AUGUGUGC -2.1\n"
"int22_AUGUGUGU -0.1\n"
"int22_AUGUGUUA -0.2\n"
"int22_AUGUGUUG -0.2\n"
"int22_AUGUUAAU 2.0\n"
"int22_AUGUUACG 2.0\n"
"int22_AUGUUAGC 2.0\n"
"int22_AUGUUAGU 2.0\n"
"int22_AUGUUAUA 2.0\n"
"int22_AUGUUAUG 2.0\n"
"int22_AUGUUCAU 2.0\n"
"int22_AUGUUCCG 1.6\n"
"int22_AUGUUCGC 0.5\n"
"int22_AUGUUCGU 2.0\n"
"int22_AUGUUCUA 2.3\n"
"int22_AUGUUCUG 2.3\n"
"int22_AUGUUGAU -1.1\n"
"int22_AUGUUGCG -2.1\n"
"int22_AUGUUGGC -2.5\n"
"int22_AUGUUGGU -1.1\n"
"int22_AUGUUGUA -1.5\n"
"int22_AUGUUGUG -1.5\n"
"int22_AUGUUUAU 2.0\n"
"int22_AUGUUUCG 1.6\n"
"int22_AUGUUUGC 1.5\n"
"int22_AUGUUUGU 2.0\n"
"int22_AUGUUUUA 2.3\n"
"int22_AUGUUUUG 2.3\n"
"int22_AUUAAACG 2.0\n"
"int22_AUUAAAGC 2.0\n"
"int22_AUUAAAGU 2.0\n"
"int22_AUUAAAUA 2.0\n"
"int22_AUUAAAUG 2.0\n"
"int22_AUUAACCG 2.0\n"
"int22_AUUAACGC 2.0\n"
"int22_AUUAACGU 2.0\n"
"int22_AUUAACUA 2.0\n"
"int22_AUUAACUG 2.0\n"
"int22_AUUAAGCG 2.0\n"
"int22_AUUAAGGC 2.0\n"
"int22_AUUAAGGU 2.0\n"
"int22_AUUAAGUA 2.0\n"
"int22_AUUAAGUG 2.0\n"
"int22_AUUAAUCG 2.0\n"
"int22_AUUAAUGC 2.0\n"
"int22_AUUAAUGU 2.0\n"
"int22_AUUAAUUA 2.0\n"
"int22_AUUAAUUG 2.0\n"
"int22_AUUACACG 2.0\n"
"int22_AUUACAGC 2.0\n"
"int22_AUUACAGU 2.0\n"
"int22_AUUACAUA 2.0\n"
"int22_AUUACAUG 2.0\n"
"int22_AUUACCCG 2.0\n"
"int22_AUUACCGC 2.0\n"
"int22_AUUACCGU 2.0\n"
"int22_AUUACCUA 2.0\n"
"int22_AUUACCUG 2.0\n"
"int22_AUUACGCG 2.0\n"
"int22_AUUACGGC 2.0\n"
"int22_AUUACGGU 2.0\n"
"int22_AUUACGUA 2.0\n"
"int22_AUUACGUG 2.0\n"
"int22_AUUACUCG 2.0\n"
"int22_AUUACUGC 2.0\n"
"int22_AUUACUGU 2.0\n"
"int22_AUUACUUA 2.0\n"
"int22_AUUACUUG 2.0\n"
"int22_AUUAGACG 2.0\n"
"int22_AUUAGAGC 2.0\n"
"int22_AUUAGAGU 2.0\n"
"int22_AUUAGAUA 2.0\n"
"int22_AUUAGAUG 2.0\n"
"int22_AUUAGCCG 2.0\n"
"int22_AUUAGCGC 2.0\n"
"int22_AUUAGCGU 2.0\n"
"int22_AUUAGCUA 2.0\n"
"int22_AUUAGCUG 2.0\n"
"int22_AUUAGGCG 2.0\n"
"int22_AUUAGGGC 2.0\n"
"int22_AUUAGGGU 2.0\n"
"int22_AUUAGGUA 2.0\n"
"int22_AUUAGGUG 2.0\n"
"int22_AUUAGUCG 2.0\n"
"int22_AUUAGUGC 2.0\n"
"int22_AUUAGUGU 2.0\n"
"int22_AUUAGUUA 2.0\n"
"int22_AUUAGUUG 2.0\n"
"int22_AUUAUAAU 2.0\n"
"int22_AUUAUACG 2.0\n"
"int22_AUUAUAGC 2.0\n"
"int22_AUUAUAGU 2.0\n"
"int22_AUUAUAUA 2.0\n"
"int22_AUUAUAUG 2.0\n"
"int22_AUUAUCAU 2.0\n"
"int22_AUUAUCCG 2.0\n"
"int22_AUUAUCGC 2.0\n"
"int22_AUUAUCGU 2.0\n"
"int22_AUUAUCUA 2.0\n"
"int22_AUUAUCUG 2.0\n"
"int22_AUUAUGAU 2.0\n"
"int22_AUUAUGCG 2.0\n"
"int22_AUUAUGGC 2.0\n"
"int22_AUUAUGGU 2.0\n"
"int22_AUUAUGUA 2.0\n"
"int22_AUUAUGUG 2.0\n"
"int22_AUUAUUAU 2.0\n"
"int22_AUUAUUCG 2.0\n"
"int22_AUUAUUGC 2.0\n"
"int22_AUUAUUGU 2.0\n"
"int22_AUUAUUUA 2.0\n"
"int22_AUUAUUUG 2.0\n"
"int22_AUUCAACG 2.3\n"
"int22_AUUCAAGC 2.4\n"
"int22_AUUCAAGU 3.1\n"
"int22_AUUCAAUA 3.1\n"
"int22_AUUCAAUG 3.1\n"
"int22_AUUCACCG 2.1\n"
"int22_AUUCACGC 1.5\n"
"int22_AUUCACGU 2.3\n"
"int22_AUUCACUA 2.5\n"
"int22_AUUCACUG 2.5\n"
"int22_AUUCAGCG 1.7\n"
"int22_AUUCAGGC 1.4\n"
"int22_AUUCAGGU 2.2\n"
"int22_AUUCAGUA 2.4\n"
"int22_AUUCAGUG 2.4\n"
"int22_AUUCAUCG 2.0\n"
"int22_AUUCAUGC 2.0\n"
"int22_AUUCAUGU 2.0\n"
"int22_AUUCAUUA 2.0\n"
"int22_AUUCAUUG 2.0\n"
"int22_AUUCCACG 1.6\n"
"int22_AUUCCAGC 1.6\n"
"int22_AUUCCAGU 2.2\n"
"int22_AUUCCAUA 2.0\n"
"int22_AUUCCAUG 2.0\n"
"int22_AUUCCCCG 1.9\n"
"int22_AUUCCCGC 1.6\n"
"int22_AUUCCCGU 2.2\n"
"int22_AUUCCCUA 2.5\n"
"int22_AUUCCCUG 2.5\n"
"int22_AUUCCGCG 2.0\n"
"int22_AUUCCGGC 2.0\n"
"int22_AUUCCGGU 2.0\n"
"int22_AUUCCGUA 2.0\n"
"int22_AUUCCGUG 2.0\n"
"int22_AUUCCUCG 1.8\n"
"int22_AUUCCUGC 1.6\n"
"int22_AUUCCUGU 2.2\n"
"int22_AUUCCUUA 2.2\n"
"int22_AUUCCUUG 2.2\n"
"int22_AUUCGACG 1.7\n"
"int22_AUUCGAGC 0.8\n"
"int22_AUUCGAGU 2.2\n"
"int22_AUUCGAUA 2.4\n"
"int22_AUUCGAUG 2.4\n"
"int22_AUUCGCCG 2.0\n"
"int22_AUUCGCGC 2.0\n"
"int22_AUUCGCGU 2.0\n"
"int22_AUUCGCUA 2.0\n"
"int22_AUUCGCUG 2.0\n"
"int22_AUUCGGCG 2.1\n"
"int22_AUUCGGGC 2.1\n"
"int22_AUUCGGGU 2.4\n"
"int22_AUUCGGUA 2.4\n"
"int22_AUUCGGUG 2.4\n"
"int22_AUUCGUCG 1.5\n"
"int22_AUUCGUGC 0.1\n"
"int22_AUUCGUGU 2.0\n"
"int22_AUUCGUUA 1.9\n"
"int22_AUUCGUUG 1.9\n"
"int22_AUUCUACG 2.0\n"
"int22_AUUCUAGC 2.0\n"
"int22_AUUCUAGU 2.0\n"
"int22_AUUCUAUA 2.0\n"
"int22_AUUCUAUG 2.0\n"
"int22_AUUCUCAU 2.2\n"
"int22_AUUCUCCG 1.8\n"
"int22_AUUCUCGC 0.6\n"
"int22_AUUCUCGU 2.2\n"
"int22_AUUCUCUA 2.5\n"
"int22_AUUCUCUG 2.5\n"
"int22_AUUCUGAU 1.0\n"
"int22_AUUCUGCG 0.0\n"
"int22_AUUCUGGC -0.3\n"
"int22_AUUCUGGU 1.0\n"
"int22_AUUCUGUA 0.7\n"
"int22_AUUCUGUG 0.7\n"
"int22_AUUCUUAU 1.4\n"
"int22_AUUCUUCG 0.9\n"
"int22_AUUCUUGC 0.8\n"
"int22_AUUCUUGU 1.4\n"
"int22_AUUCUUUA 1.6\n"
"int22_AUUCUUUG 1.6\n"
"int22_AUUGAACG 0.6\n"
"int22_AUUGAAGC 0.7\n"
"int22_AUUGAAGU 1.3\n"
"int22_AUUGAAUA 1.3\n"
"int22_AUUGAAUG 1.3\n"
"int22_AUUGACCG 0.0\n"
"int22_AUUGACGC -0.6\n"
"int22_AUUGACGU 0.2\n"
"int22_AUUGACUA 0.3\n"
"int22_AUUGACUG 0.3\n"
"int22_AUUGAGCG 0.4\n"
"int22_AUUGAGGC 0.1\n"
"int22_AUUGAGGU 0.9\n"
"int22_AUUGAGUA 1.1\n"
"int22_AUUGAGUG 1.1\n"
"int22_AUUGAUCG 2.0\n"
"int22_AUUGAUGC 2.0\n"
"int22_AUUGAUGU 2.0\n"
"int22_AUUGAUUA 2.0\n"
"int22_AUUGAUUG 2.0\n"
"int22_AUUGCACG -0.5\n"
"int22_AUUGCAGC -0.5\n"
"int22_AUUGCAGU 0.1\n"
"int22_AUUGCAUA -0.1\n"
"int22_AUUGCAUG -0.1\n"
"int22_AUUGCCCG 0.8\n"
"int22_AUUGCCGC 0.5\n"
"int22_AUUGCCGU 1.0\n"
"int22_AUUGCCUA 1.3\n"
"int22_AUUGCCUG 1.3\n"
"int22_AUUGCGCG 2.0\n"
"int22_AUUGCGGC 2.0\n"
"int22_AUUGCGGU 2.0\n"
"int22_AUUGCGUA 2.0\n"
"int22_AUUGCGUG 2.0\n"
"int22_AUUGCUCG 0.7\n"
"int22_AUUGCUGC 0.5\n"
"int22_AUUGCUGU 1.0\n"
"int22_AUUGCUUA 1.0\n"
"int22_AUUGCUUG 1.0\n"
"int22_AUUGGACG 0.4\n"
"int22_AUUGGAGC -0.5\n"
"int22_AUUGGAGU 0.9\n"
"int22_AUUGGAUA 1.1\n"
"int22_AUUGGAUG 1.1\n"
"int22_AUUGGCCG 2.0\n"
"int22_AUUGGCGC 2.0\n"
"int22_AUUGGCGU 2.0\n"
"int22_AUUGGCUA 2.0\n"
"int22_AUUGGCUG 2.0\n"
"int22_AUUGGGCG 0.4\n"
"int22_AUUGGGGC 0.4\n"
"int22_AUUGGGGU 0.7\n"
"int22_AUUGGGUA 0.7\n"
"int22_AUUGGGUG 0.7\n"
"int22_AUUGGUCG -1.6\n"
"int22_AUUGGUGC -3.1\n"
"int22_AUUGGUGU -1.1\n"
"int22_AUUGGUUA -1.2\n"
"int22_AUUGGUUG -1.2\n"
"int22_AUUGUACG 2.0\n"
"int22_AUUGUAGC 2.0\n"
"int22_AUUGUAGU 2.0\n"
"int22_AUUGUAUA 2.0\n"
"int22_AUUGUAUG 2.0\n"
"int22_AUUGUCCG 0.7\n"
"int22_AUUGUCGC -0.5\n"
"int22_AUUGUCGU 1.0\n"
"int22_AUUGUCUA 1.3\n"
"int22_AUUGUCUG 1.3\n"
"int22_AUUGUGAU -2.1\n"
"int22_AUUGUGCG -3.1\n"
"int22_AUUGUGGC -3.5\n"
"int22_AUUGUGGU -2.1\n"
"int22_AUUGUGUA -2.5\n"
"int22_AUUGUGUG -2.5\n"
"int22_AUUGUUAU 1.1\n"
"int22_AUUGUUCG 0.6\n"
"int22_AUUGUUGC 0.5\n"
"int22_AUUGUUGU 1.1\n"
"int22_AUUGUUUA 1.3\n"
"int22_AUUGUUUG 1.3\n"
"int22_AUUUAACG 1.9\n"
"int22_AUUUAAGC 2.0\n"
"int22_AUUUAAGU 2.7\n"
"int22_AUUUAAUA 2.7\n"
"int22_AUUUAAUG 2.7\n"
"int22_AUUUACCG 1.3\n"
"int22_AUUUACGC 0.7\n"
"int22_AUUUACGU 1.5\n"
"int22_AUUUACUA 1.7\n"
"int22_AUUUACUG 1.7\n"
"int22_AUUUAGCG 1.8\n"
"int22_AUUUAGGC 1.5\n"
"int22_AUUUAGGU 2.2\n"
"int22_AUUUAGUA 2.4\n"
"int22_AUUUAGUG 2.4\n"
"int22_AUUUAUCG 2.0\n"
"int22_AUUUAUGC 2.0\n"
"int22_AUUUAUGU 2.0\n"
"int22_AUUUAUUA 2.0\n"
"int22_AUUUAUUG 2.0\n"
"int22_AUUUCACG 0.8\n"
"int22_AUUUCAGC 0.8\n"
"int22_AUUUCAGU 1.4\n"
"int22_AUUUCAUA 1.2\n"
"int22_AUUUCAUG 1.2\n"
"int22_AUUUCCCG 1.1\n"
"int22_AUUUCCGC 0.8\n"
"int22_AUUUCCGU 1.4\n"
"int22_AUUUCCUA 1.7\n"
"int22_AUUUCCUG 1.7\n"
"int22_AUUUCGCG 2.0\n"
"int22_AUUUCGGC 2.0\n"
"int22_AUUUCGGU 2.0\n"
"int22_AUUUCGUA 2.0\n"
"int22_AUUUCGUG 2.0\n"
"int22_AUUUCUCG 1.0\n"
"int22_AUUUCUGC 0.8\n"
"int22_AUUUCUGU 1.4\n"
"int22_AUUUCUUA 1.4\n"
"int22_AUUUCUUG 1.4\n"
"int22_AUUUGACG 1.8\n"
"int22_AUUUGAGC 0.8\n"
"int22_AUUUGAGU 2.2\n"
"int22_AUUUGAUA 2.4\n"
"int22_AUUUGAUG 2.4\n"
"int22_AUUUGCCG 2.0\n"
"int22_AUUUGCGC 2.0\n"
"int22_AUUUGCGU 2.0\n"
"int22_AUUUGCUA 2.0\n"
"int22_AUUUGCUG 2.0\n"
"int22_AUUUGGCG 1.7\n"
"int22_AUUUGGGC 1.7\n"
"int22_AUUUGGGU 2.0\n"
"int22_AUUUGGUA 2.0\n"
"int22_AUUUGGUG 2.0\n"
"int22_AUUUGUCG 1.6\n"
"int22_AUUUGUGC 0.1\n"
"int22_AUUUGUGU 2.0\n"
"int22_AUUUGUUA 1.9\n"
"int22_AUUUGUUG 1.9\n"
"int22_AUUUUACG 2.0\n"
"int22_AUUUUAGC 2.0\n"
"int22_AUUUUAGU 2.0\n"
"int22_AUUUUAUA 2.0\n"
"int22_AUUUUAUG 2.0\n"
"int22_AUUUUCCG 1.0\n"
"int22_AUUUUCGC -0.2\n"
"int22_AUUUUCGU 1.4\n"
"int22_AUUUUCUA 1.7\n"
"int22_AUUUUCUG 1.7\n"
"int22_AUUUUGCG 0.0\n"
"int22_AUUUUGGC -0.3\n"
"int22_AUUUUGGU 1.1\n"
"int22_AUUUUGUA 0.7\n"
"int22_AUUUUGUG 0.7\n"
"int22_AUUUUUAU 0.6\n"
"int22_AUUUUUCG 0.1\n"
"int22_AUUUUUGC 0.0\n"
"int22_AUUUUUGU 0.6\n"
"int22_AUUUUUUA 0.8\n"
"int22_AUUUUUUG 0.8\n"
"int22_CGAAAACG 1.3\n"
"int22_CGAAAAGC 0.5\n"
"int22_CGAAAAGU 2.0\n"
"int22_CGAAAAUA 2.0\n"
"int22_CGAAAAUG 2.0\n"
"int22_CGAAACCG 1.6\n"
"int22_CGAAACGC 1.1\n"
"int22_CGAAACGU 1.9\n"
"int22_CGAAACUA 2.0\n"
"int22_CGAAACUG 2.0\n"
"int22_CGAAAGCG 0.3\n"
"int22_CGAAAGGC 0.4\n"
"int22_CGAAAGGU 0.8\n"
"int22_CGAAAGUA 1.0\n"
"int22_CGAAAGUG 1.0\n"
"int22_CGAAAUCG 2.0\n"
"int22_CGAAAUGC 2.0\n"
"int22_CGAAAUGU 2.0\n"
"int22_CGAAAUUA 2.0\n"
"int22_CGAAAUUG 2.0\n"
"int22_CGAACACG 1.2\n"
"int22_CGAACAGC 1.1\n"
"int22_CGAACAGU 1.8\n"
"int22_CGAACAUA 1.6\n"
"int22_CGAACAUG 1.6\n"
"int22_CGAACCCG 2.1\n"
"int22_CGAACCGC 1.7\n"
"int22_CGAACCGU 2.3\n"
"int22_CGAACCUA 2.6\n"
"int22_CGAACCUG 2.6\n"
"int22_CGAACGCG 2.0\n"
"int22_CGAACGGC 2.0\n"
"int22_CGAACGGU 2.0\n"
"int22_CGAACGUA 2.0\n"
"int22_CGAACGUG 2.0\n"
"int22_CGAACUCG 1.9\n"
"int22_CGAACUGC 1.8\n"
"int22_CGAACUGU 2.3\n"
"int22_CGAACUUA 2.3\n"
"int22_CGAACUUG 2.3\n"
"int22_CGAAGACG 0.3\n"
"int22_CGAAGAGC -0.3\n"
"int22_CGAAGAGU 0.8\n"
"int22_CGAAGAUA 1.0\n"
"int22_CGAAGAUG 1.0\n"
"int22_CGAAGCCG 2.0\n"
"int22_CGAAGCGC 2.0\n"
"int22_CGAAGCGU 2.0\n"
"int22_CGAAGCUA 2.0\n"
"int22_CGAAGCUG 2.0\n"
"int22_CGAAGGCG 1.0\n"
"int22_CGAAGGGC 1.0\n"
"int22_CGAAGGGU 1.3\n"
"int22_CGAAGGUA 1.4\n"
"int22_CGAAGGUG 1.4\n"
"int22_CGAAGUCG 1.1\n"
"int22_CGAAGUGC -0.5\n"
"int22_CGAAGUGU 1.6\n"
"int22_CGAAGUUA 1.5\n"
"int22_CGAAGUUG 1.5\n"
"int22_CGAAUACG 2.0\n"
"int22_CGAAUAGC 2.0\n"
"int22_CGAAUAGU 2.0\n"
"int22_CGAAUAUA 2.0\n"
"int22_CGAAUAUG 2.0\n"
"int22_CGAAUCCG 1.9\n"
"int22_CGAAUCGC 0.7\n"
"int22_CGAAUCGU 2.3\n"
"int22_CGAAUCUA 2.6\n"
"int22_CGAAUCUG 2.6\n"
"int22_CGAAUGCG -0.4\n"
"int22_CGAAUGGC 0.1\n"
"int22_CGAAUGGU 0.6\n"
"int22_CGAAUGUA 0.2\n"
"int22_CGAAUGUG 0.2\n"
"int22_CGAAUUCG 1.4\n"
"int22_CGAAUUGC 1.5\n"
"int22_CGAAUUGU 1.9\n"
"int22_CGAAUUUA 2.2\n"
"int22_CGAAUUUG 2.2\n"
"int22_CGACAAGC 0.6\n"
"int22_CGACAAGU 2.4\n"
"int22_CGACAAUA 2.4\n"
"int22_CGACAAUG 2.4\n"
"int22_CGACACCG 2.0\n"
"int22_CGACACGC 1.1\n"
"int22_CGACACGU 2.2\n"
"int22_CGACACUA 2.4\n"
"int22_CGACACUG 2.4\n"
"int22_CGACAGCG 0.6\n"
"int22_CGACAGGC 0.5\n"
"int22_CGACAGGU 1.1\n"
"int22_CGACAGUA 1.3\n"
"int22_CGACAGUG 1.3\n"
"int22_CGACAUCG 2.0\n"
"int22_CGACAUGC 2.0\n"
"int22_CGACAUGU 2.0\n"
"int22_CGACAUUA 2.0\n"
"int22_CGACAUUG 2.0\n"
"int22_CGACCACG 1.5\n"
"int22_CGACCAGC 1.5\n"
"int22_CGACCAGU 2.1\n"
"int22_CGACCAUA 1.9\n"
"int22_CGACCAUG 1.9\n"
"int22_CGACCCCG 1.8\n"
"int22_CGACCCGC 1.5\n"
"int22_CGACCCGU 2.1\n"
"int22_CGACCCUA 2.4\n"
"int22_CGACCCUG 2.4\n"
"int22_CGACCGCG 2.0\n"
"int22_CGACCGGC 2.0\n"
"int22_CGACCGGU 2.0\n"
"int22_CGACCGUA 2.0\n"
"int22_CGACCGUG 2.0\n"
"int22_CGACCUCG 1.7\n"
"int22_CGACCUGC 1.5\n"
"int22_CGACCUGU 2.1\n"
"int22_CGACCUUA 2.1\n"
"int22_CGACCUUG 2.1\n"
"int22_CGACGACG 0.6\n"
"int22_CGACGAGC 0.1\n"
"int22_CGACGAGU 1.1\n"
"int22_CGACGAUA 1.3\n"
"int22_CGACGAUG 1.3\n"
"int22_CGACGCCG 2.0\n"
"int22_CGACGCGC 2.0\n"
"int22_CGACGCGU 2.0\n"
"int22_CGACGCUA 2.0\n"
"int22_CGACGCUG 2.0\n"
"int22_CGACGGCG 1.4\n"
"int22_CGACGGGC 1.4\n"
"int22_CGACGGGU 1.7\n"
"int22_CGACGGUA 1.7\n"
"int22_CGACGGUG 1.7\n"
"int22_CGACGUCG 0.4\n"
"int22_CGACGUGC -0.6\n"
"int22_CGACGUGU 0.9\n"
"int22_CGACGUUA 0.8\n"
"int22_CGACGUUG 0.8\n"
"int22_CGACUACG 2.0\n"
"int22_CGACUAGC 2.0\n"
"int22_CGACUAGU 2.0\n"
"int22_CGACUAUA 2.0\n"
"int22_CGACUAUG 2.0\n"
"int22_CGACUCCG 1.7\n"
"int22_CGACUCGC 0.5\n"
"int22_CGACUCGU 2.1\n"
"int22_CGACUCUA 2.4\n"
"int22_CGACUCUG 2.4\n"
"int22_CGACUGCG -1.1\n"
"int22_CGACUGGC -0.7\n"
"int22_CGACUGGU 0.0\n"
"int22_CGACUGUA -0.4\n"
"int22_CGACUGUG -0.4\n"
"int22_CGACUUCG 0.8\n"
"int22_CGACUUGC 0.0\n"
"int22_CGACUUGU 1.3\n"
"int22_CGACUUUA 1.5\n"
"int22_CGACUUUG 1.5\n"
"int22_CGAGAAGC 0.0\n"
"int22_CGAGAAGU 1.0\n"
"int22_CGAGAAUA 1.0\n"
"int22_CGAGAAUG 1.0\n"
"int22_CGAGACGC -1.0\n"
"int22_CGAGACGU 0.9\n"
"int22_CGAGACUA 1.0\n"
"int22_CGAGACUG 1.0\n"
"int22_CGAGAGCG -0.7\n"
"int22_CGAGAGGC -0.7\n"
"int22_CGAGAGGU -0.2\n"
"int22_CGAGAGUA 0.0\n"
"int22_CGAGAGUG 0.0\n"
"int22_CGAGAUCG 2.0\n"
"int22_CGAGAUGC 2.0\n"
"int22_CGAGAUGU 2.0\n"
"int22_CGAGAUUA 2.0\n"
"int22_CGAGAUUG 2.0\n"
"int22_CGAGCACG 0.2\n"
"int22_CGAGCAGC -0.7\n"
"int22_CGAGCAGU 0.8\n"
"int22_CGAGCAUA 0.6\n"
"int22_CGAGCAUG 0.6\n"
"int22_CGAGCCCG 1.5\n"
"int22_CGAGCCGC -0.6\n"
"int22_CGAGCCGU 1.7\n"
"int22_CGAGCCUA 2.0\n"
"int22_CGAGCCUG 2.0\n"
"int22_CGAGCGCG 2.0\n"
"int22_CGAGCGGC 2.0\n"
"int22_CGAGCGGU 2.0\n"
"int22_CGAGCGUA 2.0\n"
"int22_CGAGCGUG 2.0\n"
"int22_CGAGCUCG 1.3\n"
"int22_CGAGCUGC 1.2\n"
"int22_CGAGCUGU 1.7\n"
"int22_CGAGCUUA 1.7\n"
"int22_CGAGCUUG 1.7\n"
"int22_CGAGGACG -0.7\n"
"int22_CGAGGAGC -1.6\n"
"int22_CGAGGAGU -0.2\n"
"int22_CGAGGAUA 0.0\n"
"int22_CGAGGAUG 0.0\n"
"int22_CGAGGCCG 2.0\n"
"int22_CGAGGCGC 2.0\n"
"int22_CGAGGCGU 2.0\n"
"int22_CGAGGCUA 2.0\n"
"int22_CGAGGCUG 2.0\n"
"int22_CGAGGGCG 0.0\n"
"int22_CGAGGGGC 0.0\n"
"int22_CGAGGGGU 0.3\n"
"int22_CGAGGGUA 0.4\n"
"int22_CGAGGGUG 0.4\n"
"int22_CGAGGUCG 0.9\n"
"int22_CGAGGUGC -0.6\n"
"int22_CGAGGUGU 1.4\n"
"int22_CGAGGUUA 1.3\n"
"int22_CGAGGUUG 1.3\n"
"int22_CGAGUACG 2.0\n"
"int22_CGAGUAGC 2.0\n"
"int22_CGAGUAGU 2.0\n"
"int22_CGAGUAUA 2.0\n"
"int22_CGAGUAUG 2.0\n"
"int22_CGAGUCCG 1.3\n"
"int22_CGAGUCGC 0.2\n"
"int22_CGAGUCGU 1.7\n"
"int22_CGAGUCUA 2.0\n"
"int22_CGAGUCUG 2.0\n"
"int22_CGAGUGCG -0.6\n"
"int22_CGAGUGGC -0.8\n"
"int22_CGAGUGGU 0.4\n"
"int22_CGAGUGUA 0.0\n"
"int22_CGAGUGUG 0.0\n"
"int22_CGAGUUCG 1.3\n"
"int22_CGAGUUGC 0.9\n"
"int22_CGAGUUGU 1.8\n"
"int22_CGAGUUUA 2.0\n"
"int22_CGAGUUUG 2.0\n"
"int22_CGAUAAGC 2.0\n"
"int22_CGAUAAGU 2.0\n"
"int22_CGAUAAUA 2.0\n"
"int22_CGAUAAUG 2.0\n"
"int22_CGAUACGC 2.0\n"
"int22_CGAUACGU 2.0\n"
"int22_CGAUACUA 2.0\n"
"int22_CGAUACUG 2.0\n"
"int22_CGAUAGGC 2.0\n"
"int22_CGAUAGGU 2.0\n"
"int22_CGAUAGUA 2.0\n"
"int22_CGAUAGUG 2.0\n"
"int22_CGAUAUCG 2.0\n"
"int22_CGAUAUGC 2.0\n"
"int22_CGAUAUGU 2.0\n"
"int22_CGAUAUUA 2.0\n"
"int22_CGAUAUUG 2.0\n"
"int22_CGAUCACG 2.0\n"
"int22_CGAUCAGC 2.0\n"
"int22_CGAUCAGU 2.0\n"
"int22_CGAUCAUA 2.0\n"
"int22_CGAUCAUG 2.0\n"
"int22_CGAUCCCG 2.0\n"
"int22_CGAUCCGC 2.0\n"
"int22_CGAUCCGU 2.0\n"
"int22_CGAUCCUA 2.0\n"
"int22_CGAUCCUG 2.0\n"
"int22_CGAUCGCG 2.0\n"
"int22_CGAUCGGC 2.0\n"
"int22_CGAUCGGU 2.0\n"
"int22_CGAUCGUA 2.0\n"
"int22_CGAUCGUG 2.0\n"
"int22_CGAUCUCG 2.0\n"
"int22_CGAUCUGC 2.0\n"
"int22_CGAUCUGU 2.0\n"
"int22_CGAUCUUA 2.0\n"
"int22_CGAUCUUG 2.0\n"
"int22_CGAUGACG 2.0\n"
"int22_CGAUGAGC 2.0\n"
"int22_CGAUGAGU 2.0\n"
"int22_CGAUGAUA 2.0\n"
"int22_CGAUGAUG 2.0\n"
"int22_CGAUGCCG 2.0\n"
"int22_CGAUGCGC 2.0\n"
"int22_CGAUGCGU 2.0\n"
"int22_CGAUGCUA 2.0\n"
"int22_CGAUGCUG 2.0\n"
"int22_CGAUGGCG 2.0\n"
"int22_CGAUGGGC 2.0\n"
"int22_CGAUGGGU 2.0\n"
"int22_CGAUGGUA 2.0\n"
"int22_CGAUGGUG 2.0\n"
"int22_CGAUGUCG 2.0\n"
"int22_CGAUGUGC 2.0\n"
"int22_CGAUGUGU 2.0\n"
"int22_CGAUGUUA 2.0\n"
"int22_CGAUGUUG 2.0\n"
"int22_CGAUUACG 2.0\n"
"int22_CGAUUAGC 2.0\n"
"int22_CGAUUAGU 2.0\n"
"int22_CGAUUAUA 2.0\n"
"int22_CGAUUAUG 2.0\n"
"int22_CGAUUCCG 2.0\n"
"int22_CGAUUCGC 2.0\n"
"int22_CGAUUCGU 2.0\n"
"int22_CGAUUCUA 2.0\n"
"int22_CGAUUCUG 2.0\n"
"int22_CGAUUGCG 2.0\n"
"int22_CGAUUGGC 2.0\n"
"int22_CGAUUGGU 2.0\n"
"int22_CGAUUGUA 2.0\n"
"int22_CGAUUGUG 2.0\n"
"int22_CGAUUUCG 2.0\n"
"int22_CGAUUUGC 2.0\n"
"int22_CGAUUUGU 2.0\n"
"int22_CGAUUUUA 2.0\n"
"int22_CGAUUUUG 2.0\n"
"int22_CGCAAAGC 1.3\n"
"int22_CGCAAAGU 1.9\n"
"int22_CGCAAAUA 1.9\n"
"int22_CGCAAAUG 1.9\n"
"int22_CGCAACGC 1.0\n"
"int22_CGCAACGU 1.8\n"
"int22_CGCAACUA 1.9\n"
"int22_CGCAACUG 1.9\n"
"int22_CGCAAGGC 0.7\n"
"int22_CGCAAGGU 0.7\n"
"int22_CGCAAGUA 0.9\n"
"int22_CGCAAGUG 0.9\n"
"int22_CGCAAUGC 2.0\n"
"int22_CGCAAUGU 2.0\n"
"int22_CGCAAUUA 2.0\n"
"int22_CGCAAUUG 2.0\n"
"int22_CGCACACG 1.1\n"
"int22_CGCACAGC 1.0\n"
"int22_CGCACAGU 1.7\n"
"int22_CGCACAUA 1.5\n"
"int22_CGCACAUG 1.5\n"
"int22_CGCACCCG 1.4\n"
"int22_CGCACCGC 1.0\n"
"int22_CGCACCGU 1.6\n"
"int22_CGCACCUA 1.9\n"
"int22_CGCACCUG 1.9\n"
"int22_CGCACGCG 2.0\n"
"int22_CGCACGGC 2.0\n"
"int22_CGCACGGU 2.0\n"
"int22_CGCACGUA 2.0\n"
"int22_CGCACGUG 2.0\n"
"int22_CGCACUCG 1.2\n"
"int22_CGCACUGC 1.1\n"
"int22_CGCACUGU 1.6\n"
"int22_CGCACUUA 1.6\n"
"int22_CGCACUUG 1.6\n"
"int22_CGCAGACG 0.2\n"
"int22_CGCAGAGC -0.7\n"
"int22_CGCAGAGU 0.7\n"
"int22_CGCAGAUA 0.9\n"
"int22_CGCAGAUG 0.9\n"
"int22_CGCAGCCG 2.0\n"
"int22_CGCAGCGC 2.0\n"
"int22_CGCAGCGU 2.0\n"
"int22_CGCAGCUA 2.0\n"
"int22_CGCAGCUG 2.0\n"
"int22_CGCAGGCG 0.9\n"
"int22_CGCAGGGC 0.9\n"
"int22_CGCAGGGU 1.2\n"
"int22_CGCAGGUA 1.3\n"
"int22_CGCAGGUG 1.3\n"
"int22_CGCAGUCG 0.0\n"
"int22_CGCAGUGC -1.5\n"
"int22_CGCAGUGU 0.5\n"
"int22_CGCAGUUA 0.4\n"
"int22_CGCAGUUG 0.4\n"
"int22_CGCAUACG 2.0\n"
"int22_CGCAUAGC 2.0\n"
"int22_CGCAUAGU 2.0\n"
"int22_CGCAUAUA 2.0\n"
"int22_CGCAUAUG 2.0\n"
"int22_CGCAUCCG 1.2\n"
"int22_CGCAUCGC 0.0\n"
"int22_CGCAUCGU 1.6\n"
"int22_CGCAUCUA 1.9\n"
"int22_CGCAUCUG 1.9\n"
"int22_CGCAUGCG -1.5\n"
"int22_CGCAUGGC -1.9\n"
"int22_CGCAUGGU -0.5\n"
"int22_CGCAUGUA -0.9\n"
"int22_CGCAUGUG -0.9\n"
"int22_CGCAUUCG 0.3\n"
"int22_CGCAUUGC -0.2\n"
"int22_CGCAUUGU 0.8\n"
"int22_CGCAUUUA 1.1\n"
"int22_CGCAUUUG 1.1\n"
"int22_CGCCAAGC 2.2\n"
"int22_CGCCAAGU 2.8\n"
"int22_CGCCAAUA 2.8\n"
"int22_CGCCAAUG 2.8\n"
"int22_CGCCACGC 1.9\n"
"int22_CGCCACGU 2.1\n"
"int22_CGCCACUA 2.2\n"
"int22_CGCCACUG 2.2\n"
"int22_CGCCAGGC 0.7\n"
"int22_CGCCAGGU 2.0\n"
"int22_CGCCAGUA 2.2\n"
"int22_CGCCAGUG 2.2\n"
"int22_CGCCAUGC 2.0\n"
"int22_CGCCAUGU 2.0\n"
"int22_CGCCAUUA 2.0\n"
"int22_CGCCAUUG 2.0\n"
"int22_CGCCCAGC 1.3\n"
"int22_CGCCCAGU 2.0\n"
"int22_CGCCCAUA 1.8\n"
"int22_CGCCCAUG 1.8\n"
"int22_CGCCCCCG 1.7\n"
"int22_CGCCCCGC 1.3\n"
"int22_CGCCCCGU 1.9\n"
"int22_CGCCCCUA 2.2\n"
"int22_CGCCCCUG 2.2\n"
"int22_CGCCCGCG 2.0\n"
"int22_CGCCCGGC 2.0\n"
"int22_CGCCCGGU 2.0\n"
"int22_CGCCCGUA 2.0\n"
"int22_CGCCCGUG 2.0\n"
"int22_CGCCCUCG 1.5\n"
"int22_CGCCCUGC 1.4\n"
"int22_CGCCCUGU 1.9\n"
"int22_CGCCCUUA 1.9\n"
"int22_CGCCCUUG 1.9\n"
"int22_CGCCGACG 1.5\n"
"int22_CGCCGAGC 0.7\n"
"int22_CGCCGAGU 2.0\n"
"int22_CGCCGAUA 2.2\n"
"int22_CGCCGAUG 2.2\n"
"int22_CGCCGCCG 2.0\n"
"int22_CGCCGCGC 2.0\n"
"int22_CGCCGCGU 2.0\n"
"int22_CGCCGCUA 2.0\n"
"int22_CGCCGCUG 2.0\n"
"int22_CGCCGGCG 1.8\n"
"int22_CGCCGGGC 1.8\n"
"int22_CGCCGGGU 2.1\n"
"int22_CGCCGGUA 2.2\n"
"int22_CGCCGGUG 2.2\n"
"int22_CGCCGUCG 1.3\n"
"int22_CGCCGUGC -0.2\n"
"int22_CGCCGUGU 1.8\n"
"int22_CGCCGUUA 1.7\n"
"int22_CGCCGUUG 1.7\n"
"int22_CGCCUACG 2.0\n"
"int22_CGCCUAGC 2.0\n"
"int22_CGCCUAGU 2.0\n"
"int22_CGCCUAUA 2.0\n"
"int22_CGCCUAUG 2.0\n"
"int22_CGCCUCCG 1.5\n"
"int22_CGCCUCGC 0.3\n"
"int22_CGCCUCGU 1.9\n"
"int22_CGCCUCUA 2.2\n"
"int22_CGCCUCUG 2.2\n"
"int22_CGCCUGCG -0.2\n"
"int22_CGCCUGGC -0.3\n"
"int22_CGCCUGGU 0.8\n"
"int22_CGCCUGUA 0.4\n"
"int22_CGCCUGUG 0.4\n"
"int22_CGCCUUCG 0.6\n"
"int22_CGCCUUGC -0.1\n"
"int22_CGCCUUGU 1.1\n"
"int22_CGCCUUUA 1.4\n"
"int22_CGCCUUUG 1.4\n"
"int22_CGCGAAGC 2.0\n"
"int22_CGCGAAGU 2.0\n"
"int22_CGCGAAUA 2.0\n"
"int22_CGCGAAUG 2.0\n"
"int22_CGCGACGC 2.0\n"
"int22_CGCGACGU 2.0\n"
"int22_CGCGACUA 2.0\n"
"int22_CGCGACUG 2.0\n"
"int22_CGCGAGGC 2.0\n"
"int22_CGCGAGGU 2.0\n"
"int22_CGCGAGUA 2.0\n"
"int22_CGCGAGUG 2.0\n"
"int22_CGCGAUGC 2.0\n"
"int22_CGCGAUGU 2.0\n"
"int22_CGCGAUUA 2.0\n"
"int22_CGCGAUUG 2.0\n"
"int22_CGCGCAGC 2.0\n"
"int22_CGCGCAGU 2.0\n"
"int22_CGCGCAUA 2.0\n"
"int22_CGCGCAUG 2.0\n"
"int22_CGCGCCGC 2.0\n"
"int22_CGCGCCGU 2.0\n"
"int22_CGCGCCUA 2.0\n"
"int22_CGCGCCUG 2.0\n"
"int22_CGCGCGCG 2.0\n"
"int22_CGCGCGGC 2.0\n"
"int22_CGCGCGGU 2.0\n"
"int22_CGCGCGUA 2.0\n"
"int22_CGCGCGUG 2.0\n"
"int22_CGCGCUCG 2.0\n"
"int22_CGCGCUGC 2.0\n"
"int22_CGCGCUGU 2.0\n"
"int22_CGCGCUUA 2.0\n"
"int22_CGCGCUUG 2.0\n"
"int22_CGCGGACG 2.0\n"
"int22_CGCGGAGC 2.0\n"
"int22_CGCGGAGU 2.0\n"
"int22_CGCGGAUA 2.0\n"
"int22_CGCGGAUG 2.0\n"
"int22_CGCGGCCG 2.0\n"
"int22_CGCGGCGC 2.0\n"
"int22_CGCGGCGU 2.0\n"
"int22_CGCGGCUA 2.0\n"
"int22_CGCGGCUG 2.0\n"
"int22_CGCGGGCG 2.0\n"
"int22_CGCGGGGC 2.0\n"
"int22_CGCGGGGU 2.0\n"
"int22_CGCGGGUA 2.0\n"
"int22_CGCGGGUG 2.0\n"
"int22_CGCGGUCG 2.0\n"
"int22_CGCGGUGC 2.0\n"
"int22_CGCGGUGU 2.0\n"
"int22_CGCGGUUA 2.0\n"
"int22_CGCGGUUG 2.0\n"
"int22_CGCGUACG 2.0\n"
"int22_CGCGUAGC 2.0\n"
"int22_CGCGUAGU 2.0\n"
"int22_CGCGUAUA 2.0\n"
"int22_CGCGUAUG 2.0\n"
"int22_CGCGUCCG 2.0\n"
"int22_CGCGUCGC 2.0\n"
"int22_CGCGUCGU 2.0\n"
"int22_CGCGUCUA 2.0\n"
"int22_CGCGUCUG 2.0\n"
"int22_CGCGUGCG 2.0\n"
"int22_CGCGUGGC 2.0\n"
"int22_CGCGUGGU 2.0\n"
"int22_CGCGUGUA 2.0\n"
"int22_CGCGUGUG 2.0\n"
"int22_CGCGUUCG 2.0\n"
"int22_CGCGUUGC 2.0\n"
"int22_CGCGUUGU 2.0\n"
"int22_CGCGUUUA 2.0\n"
"int22_CGCGUUUG 2.0\n"
"int22_CGCUAAGC 2.0\n"
"int22_CGCUAAGU 2.7\n"
"int22_CGCUAAUA 2.7\n"
"int22_CGCUAAUG 2.7\n"
"int22_CGCUACGC 1.1\n"
"int22_CGCUACGU 1.9\n"
"int22_CGCUACUA 2.1\n"
"int22_CGCUACUG 2.1\n"
"int22_CGCUAGGC 1.0\n"
"int22_CGCUAGGU 1.8\n"
"int22_CGCUAGUA 2.0\n"
"int22_CGCUAGUG 2.0\n"
"int22_CGCUAUGC 2.0\n"
"int22_CGCUAUGU 2.0\n"
"int22_CGCUAUUA 2.0\n"
"int22_CGCUAUUG 2.0\n"
"int22_CGCUCAGC 1.2\n"
"int22_CGCUCAGU 1.8\n"
"int22_CGCUCAUA 1.6\n"
"int22_CGCUCAUG 1.6\n"
"int22_CGCUCCGC 1.2\n"
"int22_CGCUCCGU 1.8\n"
"int22_CGCUCCUA 2.1\n"
"int22_CGCUCCUG 2.1\n"
"int22_CGCUCGGC 2.0\n"
"int22_CGCUCGGU 2.0\n"
"int22_CGCUCGUA 2.0\n"
"int22_CGCUCGUG 2.0\n"
"int22_CGCUCUCG 1.4\n"
"int22_CGCUCUGC 1.2\n"
"int22_CGCUCUGU 1.8\n"
"int22_CGCUCUUA 1.8\n"
"int22_CGCUCUUG 1.8\n"
"int22_CGCUGACG 1.3\n"
"int22_CGCUGAGC 0.4\n"
"int22_CGCUGAGU 1.8\n"
"int22_CGCUGAUA 2.0\n"
"int22_CGCUGAUG 2.0\n"
"int22_CGCUGCCG 2.0\n"
"int22_CGCUGCGC 2.0\n"
"int22_CGCUGCGU 2.0\n"
"int22_CGCUGCUA 2.0\n"
"int22_CGCUGCUG 2.0\n"
"int22_CGCUGGCG 1.7\n"
"int22_CGCUGGGC 1.7\n"
"int22_CGCUGGGU 2.0\n"
"int22_CGCUGGUA 2.0\n"
"int22_CGCUGGUG 2.0\n"
"int22_CGCUGUCG 1.1\n"
"int22_CGCUGUGC -0.3\n"
"int22_CGCUGUGU 1.6\n"
"int22_CGCUGUUA 1.5\n"
"int22_CGCUGUUG 1.5\n"
"int22_CGCUUACG 2.0\n"
"int22_CGCUUAGC 2.0\n"
"int22_CGCUUAGU 2.0\n"
"int22_CGCUUAUA 2.0\n"
"int22_CGCUUAUG 2.0\n"
"int22_CGCUUCCG 1.4\n"
"int22_CGCUUCGC 1.7\n"
"int22_CGCUUCGU 1.8\n"
"int22_CGCUUCUA 2.1\n"
"int22_CGCUUCUG 2.1\n"
"int22_CGCUUGCG -0.4\n"
"int22_CGCUUGGC -0.7\n"
"int22_CGCUUGGU 0.7\n"
"int22_CGCUUGUA 0.3\n"
"int22_CGCUUGUG 0.3\n"
"int22_CGCUUUCG 0.5\n"
"int22_CGCUUUGC 0.2\n"
"int22_CGCUUUGU 1.0\n"
"int22_CGCUUUUA 1.2\n"
"int22_CGCUUUUG 1.2\n"
"int22_CGGAAAGC -0.2\n"
"int22_CGGAAAGU 1.0\n"
"int22_CGGAAAUA 1.0\n"
"int22_CGGAAAUG 1.0\n"
"int22_CGGAACGC 0.7\n"
"int22_CGGAACGU 0.9\n"
"int22_CGGAACUA 1.0\n"
"int22_CGGAACUG 1.0\n"
"int22_CGGAAGGC -0.5\n"
"int22_CGGAAGGU -0.2\n"
"int22_CGGAAGUA 0.0\n"
"int22_CGGAAGUG 0.0\n"
"int22_CGGAAUGC 2.0\n"
"int22_CGGAAUGU 2.0\n"
"int22_CGGAAUUA 2.0\n"
"int22_CGGAAUUG 2.0\n"
"int22_CGGACAGC -0.4\n"
"int22_CGGACAGU 0.8\n"
"int22_CGGACAUA 0.6\n"
"int22_CGGACAUG 0.6\n"
"int22_CGGACCGC 1.1\n"
"int22_CGGACCGU 1.7\n"
"int22_CGGACCUA 2.0\n"
"int22_CGGACCUG 2.0\n"
"int22_CGGACGGC 2.0\n"
"int22_CGGACGGU 2.0\n"
"int22_CGGACGUA 2.0\n"
"int22_CGGACGUG 2.0\n"
"int22_CGGACUGC 1.2\n"
"int22_CGGACUGU 1.7\n"
"int22_CGGACUUA 1.7\n"
"int22_CGGACUUG 1.7\n"
"int22_CGGAGACG -0.7\n"
"int22_CGGAGAGC -1.7\n"
"int22_CGGAGAGU -0.2\n"
"int22_CGGAGAUA 0.0\n"
"int22_CGGAGAUG 0.0\n"
"int22_CGGAGCCG 2.0\n"
"int22_CGGAGCGC 2.0\n"
"int22_CGGAGCGU 2.0\n"
"int22_CGGAGCUA 2.0\n"
"int22_CGGAGCUG 2.0\n"
"int22_CGGAGGCG 0.0\n"
"int22_CGGAGGGC 0.0\n"
"int22_CGGAGGGU 0.3\n"
"int22_CGGAGGUA 0.4\n"
"int22_CGGAGGUG 0.4\n"
"int22_CGGAGUCG 0.9\n"
"int22_CGGAGUGC -1.3\n"
"int22_CGGAGUGU 1.4\n"
"int22_CGGAGUUA 1.3\n"
"int22_CGGAGUUG 1.3\n"
"int22_CGGAUACG 2.0\n"
"int22_CGGAUAGC 2.0\n"
"int22_CGGAUAGU 2.0\n"
"int22_CGGAUAUA 2.0\n"
"int22_CGGAUAUG 2.0\n"
"int22_CGGAUCCG 1.3\n"
"int22_CGGAUCGC 0.2\n"
"int22_CGGAUCGU 1.7\n"
"int22_CGGAUCUA 2.0\n"
"int22_CGGAUCUG 2.0\n"
"int22_CGGAUGCG -0.6\n"
"int22_CGGAUGGC -0.9\n"
"int22_CGGAUGGU 0.4\n"
"int22_CGGAUGUA 0.0\n"
"int22_CGGAUGUG 0.0\n"
"int22_CGGAUUCG 1.3\n"
"int22_CGGAUUGC 0.9\n"
"int22_CGGAUUGU 1.8\n"
"int22_CGGAUUUA 2.0\n"
"int22_CGGAUUUG 2.0\n"
"int22_CGGCAAGC 2.0\n"
"int22_CGGCAAGU 2.0\n"
"int22_CGGCAAUA 2.0\n"
"int22_CGGCAAUG 2.0\n"
"int22_CGGCACGC 2.0\n"
"int22_CGGCACGU 2.0\n"
"int22_CGGCACUA 2.0\n"
"int22_CGGCACUG 2.0\n"
"int22_CGGCAGGC 2.0\n"
"int22_CGGCAGGU 2.0\n"
"int22_CGGCAGUA 2.0\n"
"int22_CGGCAGUG 2.0\n"
"int22_CGGCAUGC 2.0\n"
"int22_CGGCAUGU 2.0\n"
"int22_CGGCAUUA 2.0\n"
"int22_CGGCAUUG 2.0\n"
"int22_CGGCCAGC 2.0\n"
"int22_CGGCCAGU 2.0\n"
"int22_CGGCCAUA 2.0\n"
"int22_CGGCCAUG 2.0\n"
"int22_CGGCCCGC 2.0\n"
"int22_CGGCCCGU 2.0\n"
"int22_CGGCCCUA 2.0\n"
"int22_CGGCCCUG 2.0\n"
"int22_CGGCCGGC 2.0\n"
"int22_CGGCCGGU 2.0\n"
"int22_CGGCCGUA 2.0\n"
"int22_CGGCCGUG 2.0\n"
"int22_CGGCCUGC 2.0\n"
"int22_CGGCCUGU 2.0\n"
"int22_CGGCCUUA 2.0\n"
"int22_CGGCCUUG 2.0\n"
"int22_CGGCGAGC 2.0\n"
"int22_CGGCGAGU 2.0\n"
"int22_CGGCGAUA 2.0\n"
"int22_CGGCGAUG 2.0\n"
"int22_CGGCGCCG 2.0\n"
"int22_CGGCGCGC 2.0\n"
"int22_CGGCGCGU 2.0\n"
"int22_CGGCGCUA 2.0\n"
"int22_CGGCGCUG 2.0\n"
"int22_CGGCGGCG 2.0\n"
"int22_CGGCGGGC 2.0\n"
"int22_CGGCGGGU 2.0\n"
"int22_CGGCGGUA 2.0\n"
"int22_CGGCGGUG 2.0\n"
"int22_CGGCGUCG 2.0\n"
"int22_CGGCGUGC 2.0\n"
"int22_CGGCGUGU 2.0\n"
"int22_CGGCGUUA 2.0\n"
"int22_CGGCGUUG 2.0\n"
"int22_CGGCUACG 2.0\n"
"int22_CGGCUAGC 2.0\n"
"int22_CGGCUAGU 2.0\n"
"int22_CGGCUAUA 2.0\n"
"int22_CGGCUAUG 2.0\n"
"int22_CGGCUCCG 2.0\n"
"int22_CGGCUCGC 2.0\n"
"int22_CGGCUCGU 2.0\n"
"int22_CGGCUCUA 2.0\n"
"int22_CGGCUCUG 2.0\n"
"int22_CGGCUGCG 2.0\n"
"int22_CGGCUGGC 2.0\n"
"int22_CGGCUGGU 2.0\n"
"int22_CGGCUGUA 2.0\n"
"int22_CGGCUGUG 2.0\n"
"int22_CGGCUUCG 2.0\n"
"int22_CGGCUUGC 2.0\n"
"int22_CGGCUUGU 2.0\n"
"int22_CGGCUUUA 2.0\n"
"int22_CGGCUUUG 2.0\n"
"int22_CGGGAAGC 1.1\n"
"int22_CGGGAAGU 1.8\n"
"int22_CGGGAAUA 1.8\n"
"int22_CGGGAAUG 1.8\n"
"int22_CGGGACGC 0.8\n"
"int22_CGGGACGU 1.6\n"
"int22_CGGGACUA 1.8\n"
"int22_CGGGACUG 1.8\n"
"int22_CGGGAGGC -0.2\n"
"int22_CGGGAGGU 0.5\n"
"int22_CGGGAGUA 0.7\n"
"int22_CGGGAGUG 0.7\n"
"int22_CGGGAUGC 2.0\n"
"int22_CGGGAUGU 2.0\n"
"int22_CGGGAUUA 2.0\n"
"int22_CGGGAUUG 2.0\n"
"int22_CGGGCAGC 0.9\n"
"int22_CGGGCAGU 1.5\n"
"int22_CGGGCAUA 1.3\n"
"int22_CGGGCAUG 1.3\n"
"int22_CGGGCCGC 1.5\n"
"int22_CGGGCCGU 2.1\n"
"int22_CGGGCCUA 2.4\n"
"int22_CGGGCCUG 2.4\n"
"int22_CGGGCGGC 2.0\n"
"int22_CGGGCGGU 2.0\n"
"int22_CGGGCGUA 2.0\n"
"int22_CGGGCGUG 2.0\n"
"int22_CGGGCUGC 1.5\n"
"int22_CGGGCUGU 2.1\n"
"int22_CGGGCUUA 2.1\n"
"int22_CGGGCUUG 2.1\n"
"int22_CGGGGAGC -0.9\n"
"int22_CGGGGAGU 0.5\n"
"int22_CGGGGAUA 0.7\n"
"int22_CGGGGAUG 0.7\n"
"int22_CGGGGCGC 2.0\n"
"int22_CGGGGCGU 2.0\n"
"int22_CGGGGCUA 2.0\n"
"int22_CGGGGCUG 2.0\n"
"int22_CGGGGGCG 0.8\n"
"int22_CGGGGGGC 0.8\n"
"int22_CGGGGGGU 1.1\n"
"int22_CGGGGGUA 1.1\n"
"int22_CGGGGGUG 1.1\n"
"int22_CGGGGUCG 0.9\n"
"int22_CGGGGUGC -0.6\n"
"int22_CGGGGUGU 1.3\n"
"int22_CGGGGUUA 1.2\n"
"int22_CGGGGUUG 1.2\n"
"int22_CGGGUACG 2.0\n"
"int22_CGGGUAGC 2.0\n"
"int22_CGGGUAGU 2.0\n"
"int22_CGGGUAUA 2.0\n"
"int22_CGGGUAUG 2.0\n"
"int22_CGGGUCCG 1.7\n"
"int22_CGGGUCGC 0.5\n"
"int22_CGGGUCGU 2.1\n"
"int22_CGGGUCUA 2.4\n"
"int22_CGGGUCUG 2.4\n"
"int22_CGGGUGCG -0.7\n"
"int22_CGGGUGGC -1.0\n"
"int22_CGGGUGGU 0.4\n"
"int22_CGGGUGUA 0.0\n"
"int22_CGGGUGUG 0.0\n"
"int22_CGGGUUCG 1.2\n"
"int22_CGGGUUGC 1.1\n"
"int22_CGGGUUGU 1.7\n"
"int22_CGGGUUUA 1.9\n"
"int22_CGGGUUUG 1.9\n"
"int22_CGGUAAGC 0.9\n"
"int22_CGGUAAGU 1.8\n"
"int22_CGGUAAUA 1.8\n"
"int22_CGGUAAUG 1.8\n"
"int22_CGGUACGC -0.1\n"
"int22_CGGUACGU 0.7\n"
"int22_CGGUACUA 0.8\n"
"int22_CGGUACUG 0.8\n"
"int22_CGGUAGGC 0.6\n"
"int22_CGGUAGGU 1.4\n"
"int22_CGGUAGUA 1.6\n"
"int22_CGGUAGUG 1.6\n"
"int22_CGGUAUGC 2.0\n"
"int22_CGGUAUGU 2.0\n"
"int22_CGGUAUUA 2.0\n"
"int22_CGGUAUUG 2.0\n"
"int22_CGGUCAGC 0.0\n"
"int22_CGGUCAGU 0.6\n"
"int22_CGGUCAUA 0.4\n"
"int22_CGGUCAUG 0.4\n"
"int22_CGGUCCGC 1.0\n"
"int22_CGGUCCGU 1.5\n"
"int22_CGGUCCUA 1.8\n"
"int22_CGGUCCUG 1.8\n"
"int22_CGGUCGGC 2.0\n"
"int22_CGGUCGGU 2.0\n"
"int22_CGGUCGUA 2.0\n"
"int22_CGGUCGUG 2.0\n"
"int22_CGGUCUGC 1.0\n"
"int22_CGGUCUGU 1.5\n"
"int22_CGGUCUUA 1.5\n"
"int22_CGGUCUUG 1.5\n"
"int22_CGGUGAGC 0.3\n"
"int22_CGGUGAGU 1.4\n"
"int22_CGGUGAUA 1.6\n"
"int22_CGGUGAUG 1.6\n"
"int22_CGGUGCGC 2.0\n"
"int22_CGGUGCGU 2.0\n"
"int22_CGGUGCUA 2.0\n"
"int22_CGGUGCUG 2.0\n"
"int22_CGGUGGGC 0.9\n"
"int22_CGGUGGGU 1.1\n"
"int22_CGGUGGUA 1.2\n"
"int22_CGGUGGUG 1.2\n"
"int22_CGGUGUCG -1.1\n"
"int22_CGGUGUGC -2.4\n"
"int22_CGGUGUGU -0.6\n"
"int22_CGGUGUUA -0.7\n"
"int22_CGGUGUUG -0.7\n"
"int22_CGGUUACG 2.0\n"
"int22_CGGUUAGC 2.0\n"
"int22_CGGUUAGU 2.0\n"
"int22_CGGUUAUA 2.0\n"
"int22_CGGUUAUG 2.0\n"
"int22_CGGUUCCG 1.1\n"
"int22_CGGUUCGC 0.0\n"
"int22_CGGUUCGU 1.5\n"
"int22_CGGUUCUA 1.8\n"
"int22_CGGUUCUG 1.8\n"
"int22_CGGUUGCG -2.6\n"
"int22_CGGUUGGC -3.0\n"
"int22_CGGUUGGU -1.6\n"
"int22_CGGUUGUA -2.0\n"
"int22_CGGUUGUG -2.0\n"
"int22_CGGUUUCG 1.1\n"
"int22_CGGUUUGC 0.6\n"
"int22_CGGUUUGU 1.6\n"
"int22_CGGUUUUA 1.8\n"
"int22_CGGUUUUG 1.8\n"
"int22_CGUAAAGC 2.0\n"
"int22_CGUAAAGU 2.0\n"
"int22_CGUAAAUA 2.0\n"
"int22_CGUAAAUG 2.0\n"
"int22_CGUAACGC 2.0\n"
"int22_CGUAACGU 2.0\n"
"int22_CGUAACUA 2.0\n"
"int22_CGUAACUG 2.0\n"
"int22_CGUAAGGC 2.0\n"
"int22_CGUAAGGU 2.0\n"
"int22_CGUAAGUA 2.0\n"
"int22_CGUAAGUG 2.0\n"
"int22_CGUAAUGC 2.0\n"
"int22_CGUAAUGU 2.0\n"
"int22_CGUAAUUA 2.0\n"
"int22_CGUAAUUG 2.0\n"
"int22_CGUACAGC 2.0\n"
"int22_CGUACAGU 2.0\n"
"int22_CGUACAUA 2.0\n"
"int22_CGUACAUG 2.0\n"
"int22_CGUACCGC 2.0\n"
"int22_CGUACCGU 2.0\n"
"int22_CGUACCUA 2.0\n"
"int22_CGUACCUG 2.0\n"
"int22_CGUACGGC 2.0\n"
"int22_CGUACGGU 2.0\n"
"int22_CGUACGUA 2.0\n"
"int22_CGUACGUG 2.0\n"
"int22_CGUACUGC 2.0\n"
"int22_CGUACUGU 2.0\n"
"int22_CGUACUUA 2.0\n"
"int22_CGUACUUG 2.0\n"
"int22_CGUAGAGC 2.0\n"
"int22_CGUAGAGU 2.0\n"
"int22_CGUAGAUA 2.0\n"
"int22_CGUAGAUG 2.0\n"
"int22_CGUAGCGC 2.0\n"
"int22_CGUAGCGU 2.0\n"
"int22_CGUAGCUA 2.0\n"
"int22_CGUAGCUG 2.0\n"
"int22_CGUAGGGC 2.0\n"
"int22_CGUAGGGU 2.0\n"
"int22_CGUAGGUA 2.0\n"
"int22_CGUAGGUG 2.0\n"
"int22_CGUAGUGC 2.0\n"
"int22_CGUAGUGU 2.0\n"
"int22_CGUAGUUA 2.0\n"
"int22_CGUAGUUG 2.0\n"
"int22_CGUAUACG 2.0\n"
"int22_CGUAUAGC 2.0\n"
"int22_CGUAUAGU 2.0\n"
"int22_CGUAUAUA 2.0\n"
"int22_CGUAUAUG 2.0\n"
"int22_CGUAUCCG 2.0\n"
"int22_CGUAUCGC 2.0\n"
"int22_CGUAUCGU 2.0\n"
"int22_CGUAUCUA 2.0\n"
"int22_CGUAUCUG 2.0\n"
"int22_CGUAUGCG 2.0\n"
"int22_CGUAUGGC 2.0\n"
"int22_CGUAUGGU 2.0\n"
"int22_CGUAUGUA 2.0\n"
"int22_CGUAUGUG 2.0\n"
"int22_CGUAUUCG 2.0\n"
"int22_CGUAUUGC 2.0\n"
"int22_CGUAUUGU 2.0\n"
"int22_CGUAUUUA 2.0\n"
"int22_CGUAUUUG 2.0\n"
"int22_CGUCAAGC 2.0\n"
"int22_CGUCAAGU 2.7\n"
"int22_CGUCAAUA 2.7\n"
"int22_CGUCAAUG 2.7\n"
"int22_CGUCACGC 1.1\n"
"int22_CGUCACGU 1.9\n"
"int22_CGUCACUA 2.1\n"
"int22_CGUCACUG 2.1\n"
"int22_CGUCAGGC 0.5\n"
"int22_CGUCAGGU 1.8\n"
"int22_CGUCAGUA 2.0\n"
"int22_CGUCAGUG 2.0\n"
"int22_CGUCAUGC 2.0\n"
"int22_CGUCAUGU 2.0\n"
"int22_CGUCAUUA 2.0\n"
"int22_CGUCAUUG 2.0\n"
"int22_CGUCCAGC 1.2\n"
"int22_CGUCCAGU 1.8\n"
"int22_CGUCCAUA 1.6\n"
"int22_CGUCCAUG 1.6\n"
"int22_CGUCCCGC 1.2\n"
"int22_CGUCCCGU 1.8\n"
"int22_CGUCCCUA 2.1\n"
"int22_CGUCCCUG 2.1\n"
"int22_CGUCCGGC 2.0\n"
"int22_CGUCCGGU 2.0\n"
"int22_CGUCCGUA 2.0\n"
"int22_CGUCCGUG 2.0\n"
"int22_CGUCCUGC 1.2\n"
"int22_CGUCCUGU 1.8\n"
"int22_CGUCCUUA 1.8\n"
"int22_CGUCCUUG 1.8\n"
"int22_CGUCGAGC 0.4\n"
"int22_CGUCGAGU 1.8\n"
"int22_CGUCGAUA 2.0\n"
"int22_CGUCGAUG 2.0\n"
"int22_CGUCGCGC 2.0\n"
"int22_CGUCGCGU 2.0\n"
"int22_CGUCGCUA 2.0\n"
"int22_CGUCGCUG 2.0\n"
"int22_CGUCGGGC 1.7\n"
"int22_CGUCGGGU 2.0\n"
"int22_CGUCGGUA 2.0\n"
"int22_CGUCGGUG 2.0\n"
"int22_CGUCGUGC -0.1\n"
"int22_CGUCGUGU 1.6\n"
"int22_CGUCGUUA 1.5\n"
"int22_CGUCGUUG 1.5\n"
"int22_CGUCUAGC 2.0\n"
"int22_CGUCUAGU 2.0\n"
"int22_CGUCUAUA 2.0\n"
"int22_CGUCUAUG 2.0\n"
"int22_CGUCUCCG 1.4\n"
"int22_CGUCUCGC 0.2\n"
"int22_CGUCUCGU 1.8\n"
"int22_CGUCUCUA 2.1\n"
"int22_CGUCUCUG 2.1\n"
"int22_CGUCUGCG -0.4\n"
"int22_CGUCUGGC -0.7\n"
"int22_CGUCUGGU 0.7\n"
"int22_CGUCUGUA 0.3\n"
"int22_CGUCUGUG 0.3\n"
"int22_CGUCUUCG 0.5\n"
"int22_CGUCUUGC 0.4\n"
"int22_CGUCUUGU 1.0\n"
"int22_CGUCUUUA 1.2\n"
"int22_CGUCUUUG 1.2\n"
"int22_CGUGAAGC -0.1\n"
"int22_CGUGAAGU 0.3\n"
"int22_CGUGAAUA 0.3\n"
"int22_CGUGAAUG 0.3\n"
"int22_CGUGACGC -1.6\n"
"int22_CGUGACGU -0.8\n"
"int22_CGUGACUA -0.7\n"
"int22_CGUGACUG -0.7\n"
"int22_CGUGAGGC -0.6\n"
"int22_CGUGAGGU -0.1\n"
"int22_CGUGAGUA 0.1\n"
"int22_CGUGAGUG 0.1\n"
"int22_CGUGAUGC 2.0\n"
"int22_CGUGAUGU 2.0\n"
"int22_CGUGAUUA 2.0\n"
"int22_CGUGAUUG 2.0\n"
"int22_CGUGCAGC -1.6\n"
"int22_CGUGCAGU -0.9\n"
"int22_CGUGCAUA -1.1\n"
"int22_CGUGCAUG -1.1\n"
"int22_CGUGCCGC -0.6\n"
"int22_CGUGCCGU 0.0\n"
"int22_CGUGCCUA 0.3\n"
"int22_CGUGCCUG 0.3\n"
"int22_CGUGCGGC 2.0\n"
"int22_CGUGCGGU 2.0\n"
"int22_CGUGCGUA 2.0\n"
"int22_CGUGCGUG 2.0\n"
"int22_CGUGCUGC -0.5\n"
"int22_CGUGCUGU 0.0\n"
"int22_CGUGCUUA 0.0\n"
"int22_CGUGCUUG 0.0\n"
"int22_CGUGGAGC -1.6\n"
"int22_CGUGGAGU -0.1\n"
"int22_CGUGGAUA 0.1\n"
"int22_CGUGGAUG 0.1\n"
"int22_CGUGGCGC 2.0\n"
"int22_CGUGGCGU 2.0\n"
"int22_CGUGGCUA 2.0\n"
"int22_CGUGGCUG 2.0\n"
"int22_CGUGGGGC -0.7\n"
"int22_CGUGGGGU -0.4\n"
"int22_CGUGGGUA -0.3\n"
"int22_CGUGGGUG -0.3\n"
"int22_CGUGGUGC -4.1\n"
"int22_CGUGGUGU -2.1\n"
"int22_CGUGGUUA -2.2\n"
"int22_CGUGGUUG -2.2\n"
"int22_CGUGUAGC 2.0\n"
"int22_CGUGUAGU 2.0\n"
"int22_CGUGUAUA 2.0\n"
"int22_CGUGUAUG 2.0\n"
"int22_CGUGUCGC -1.6\n"
"int22_CGUGUCGU 0.0\n"
"int22_CGUGUCUA 0.3\n"
"int22_CGUGUCUG 0.3\n"
"int22_CGUGUGCG -4.2\n"
"int22_CGUGUGGC -4.4\n"
"int22_CGUGUGGU -3.1\n"
"int22_CGUGUGUA -3.5\n"
"int22_CGUGUGUG -3.5\n"
"int22_CGUGUUCG -0.5\n"
"int22_CGUGUUGC -1.0\n"
"int22_CGUGUUGU 0.0\n"
"int22_CGUGUUUA 0.3\n"
"int22_CGUGUUUG 0.3\n"
"int22_CGUUAAGC 1.4\n"
"int22_CGUUAAGU 2.2\n"
"int22_CGUUAAUA 2.2\n"
"int22_CGUUAAUG 2.2\n"
"int22_CGUUACGC 0.3\n"
"int22_CGUUACGU 1.0\n"
"int22_CGUUACUA 1.2\n"
"int22_CGUUACUG 1.2\n"
"int22_CGUUAGGC 1.4\n"
"int22_CGUUAGGU 1.8\n"
"int22_CGUUAGUA 1.9\n"
"int22_CGUUAGUG 1.9\n"
"int22_CGUUAUGC 2.0\n"
"int22_CGUUAUGU 2.0\n"
"int22_CGUUAUUA 2.0\n"
"int22_CGUUAUUG 2.0\n"
"int22_CGUUCAGC 0.3\n"
"int22_CGUUCAGU 0.9\n"
"int22_CGUUCAUA 0.7\n"
"int22_CGUUCAUG 0.7\n"
"int22_CGUUCCGC 0.3\n"
"int22_CGUUCCGU 0.9\n"
"int22_CGUUCCUA 1.2\n"
"int22_CGUUCCUG 1.2\n"
"int22_CGUUCGGC 2.0\n"
"int22_CGUUCGGU 2.0\n"
"int22_CGUUCGUA 2.0\n"
"int22_CGUUCGUG 2.0\n"
"int22_CGUUCUGC 0.3\n"
"int22_CGUUCUGU 0.9\n"
"int22_CGUUCUUA 0.9\n"
"int22_CGUUCUUG 0.9\n"
"int22_CGUUGAGC 0.5\n"
"int22_CGUUGAGU 1.8\n"
"int22_CGUUGAUA 1.9\n"
"int22_CGUUGAUG 1.9\n"
"int22_CGUUGCGC 2.0\n"
"int22_CGUUGCGU 2.0\n"
"int22_CGUUGCUA 2.0\n"
"int22_CGUUGCUG 2.0\n"
"int22_CGUUGGGC 1.2\n"
"int22_CGUUGGGU 1.5\n"
"int22_CGUUGGUA 1.5\n"
"int22_CGUUGGUG 1.5\n"
"int22_CGUUGUGC 0.1\n"
"int22_CGUUGUGU 1.6\n"
"int22_CGUUGUUA 1.5\n"
"int22_CGUUGUUG 1.5\n"
"int22_CGUUUAGC 2.0\n"
"int22_CGUUUAGU 2.0\n"
"int22_CGUUUAUA 2.0\n"
"int22_CGUUUAUG 2.0\n"
"int22_CGUUUCGC 0.1\n"
"int22_CGUUUCGU 0.9\n"
"int22_CGUUUCUA 1.2\n"
"int22_CGUUUCUG 1.2\n"
"int22_CGUUUGGC -1.0\n"
"int22_CGUUUGGU 0.6\n"
"int22_CGUUUGUA 0.2\n"
"int22_CGUUUGUG 0.2\n"
"int22_CGUUUUCG -0.4\n"
"int22_CGUUUUGC 0.6\n"
"int22_CGUUUUGU 0.1\n"
"int22_CGUUUUUA 0.3\n"
"int22_CGUUUUUG 0.3\n"
"int22_GCAAAAGC 1.5\n"
"int22_GCAAAAGU 2.1\n"
"int22_GCAAAAUA 2.1\n"
"int22_GCAAAAUG 2.1\n"
"int22_GCAAACGC 1.2\n"
"int22_GCAAACGU 2.0\n"
"int22_GCAAACUA 2.1\n"
"int22_GCAAACUG 2.1\n"
"int22_GCAAAGGC 0.1\n"
"int22_GCAAAGGU 0.9\n"
"int22_GCAAAGUA 1.1\n"
"int22_GCAAAGUG 1.1\n"
"int22_GCAAAUGC 2.0\n"
"int22_GCAAAUGU 2.0\n"
"int22_GCAAAUUA 2.0\n"
"int22_GCAAAUUG 2.0\n"
"int22_GCAACAGC 1.2\n"
"int22_GCAACAGU 1.9\n"
"int22_GCAACAUA 1.7\n"
"int22_GCAACAUG 1.7\n"
"int22_GCAACCGC 1.8\n"
"int22_GCAACCGU 2.4\n"
"int22_GCAACCUA 2.7\n"
"int22_GCAACCUG 2.7\n"
"int22_GCAACGGC 2.0\n"
"int22_GCAACGGU 2.0\n"
"int22_GCAACGUA 2.0\n"
"int22_GCAACGUG 2.0\n"
"int22_GCAACUGC 1.9\n"
"int22_GCAACUGU 2.4\n"
"int22_GCAACUUA 2.4\n"
"int22_GCAACUUG 2.4\n"
"int22_GCAAGAGC -0.5\n"
"int22_GCAAGAGU 0.9\n"
"int22_GCAAGAUA 1.1\n"
"int22_GCAAGAUG 1.1\n"
"int22_GCAAGCGC 2.0\n"
"int22_GCAAGCGU 2.0\n"
"int22_GCAAGCUA 2.0\n"
"int22_GCAAGCUG 2.0\n"
"int22_GCAAGGGC 1.1\n"
"int22_GCAAGGGU 1.4\n"
"int22_GCAAGGUA 1.5\n"
"int22_GCAAGGUG 1.5\n"
"int22_GCAAGUGC -0.3\n"
"int22_GCAAGUGU 1.7\n"
"int22_GCAAGUUA 1.6\n"
"int22_GCAAGUUG 1.6\n"
"int22_GCAAUAGC 2.0\n"
"int22_GCAAUAGU 2.0\n"
"int22_GCAAUAUA 2.0\n"
"int22_GCAAUAUG 2.0\n"
"int22_GCAAUCGC 0.8\n"
"int22_GCAAUCGU 2.4\n"
"int22_GCAAUCUA 2.7\n"
"int22_GCAAUCUG 2.7\n"
"int22_GCAAUGGC -0.7\n"
"int22_GCAAUGGU 0.7\n"
"int22_GCAAUGUA 0.3\n"
"int22_GCAAUGUG 0.3\n"
"int22_GCAAUUGC 1.5\n"
"int22_GCAAUUGU 2.0\n"
"int22_GCAAUUUA 2.3\n"
"int22_GCAAUUUG 2.3\n"
"int22_GCACAAGU 1.8\n"
"int22_GCACAAUA 1.8\n"
"int22_GCACAAUG 1.8\n"
"int22_GCACACGC 0.9\n"
"int22_GCACACGU 1.7\n"
"int22_GCACACUA 1.8\n"
"int22_GCACACUG 1.8\n"
"int22_GCACAGGC -0.2\n"
"int22_GCACAGGU 0.6\n"
"int22_GCACAGUA 0.8\n"
"int22_GCACAGUG 0.8\n"
"int22_GCACAUGC 2.0\n"
"int22_GCACAUGU 2.0\n"
"int22_GCACAUUA 2.0\n"
"int22_GCACAUUG 2.0\n"
"int22_GCACCAGC 0.9\n"
"int22_GCACCAGU 1.6\n"
"int22_GCACCAUA 1.4\n"
"int22_GCACCAUG 1.4\n"
"int22_GCACCCGC 0.9\n"
"int22_GCACCCGU 1.5\n"
"int22_GCACCCUA 1.8\n"
"int22_GCACCCUG 1.8\n"
"int22_GCACCGGC 2.0\n"
"int22_GCACCGGU 2.0\n"
"int22_GCACCGUA 2.0\n"
"int22_GCACCGUG 2.0\n"
"int22_GCACCUGC 1.0\n"
"int22_GCACCUGU 1.5\n"
"int22_GCACCUUA 1.5\n"
"int22_GCACCUUG 1.5\n"
"int22_GCACGAGC -0.8\n"
"int22_GCACGAGU 0.6\n"
"int22_GCACGAUA 0.8\n"
"int22_GCACGAUG 0.8\n"
"int22_GCACGCGC 2.0\n"
"int22_GCACGCGU 2.0\n"
"int22_GCACGCUA 2.0\n"
"int22_GCACGCUG 2.0\n"
"int22_GCACGGGC 0.8\n"
"int22_GCACGGGU 1.1\n"
"int22_GCACGGUA 1.2\n"
"int22_GCACGGUG 1.2\n"
"int22_GCACGUGC -1.6\n"
"int22_GCACGUGU 0.4\n"
"int22_GCACGUUA 0.3\n"
"int22_GCACGUUG 0.3\n"
"int22_GCACUAGC 2.0\n"
"int22_GCACUAGU 2.0\n"
"int22_GCACUAUA 2.0\n"
"int22_GCACUAUG 2.0\n"
"int22_GCACUCGC 0.0\n"
"int22_GCACUCGU 1.5\n"
"int22_GCACUCUA 1.8\n"
"int22_GCACUCUG 1.8\n"
"int22_GCACUGGC -2.0\n"
"int22_GCACUGGU -0.6\n"
"int22_GCACUGUA -1.0\n"
"int22_GCACUGUG -1.0\n"
"int22_GCACUUGC 0.2\n"
"int22_GCACUUGU 0.7\n"
"int22_GCACUUUA 1.0\n"
"int22_GCACUUUG 1.0\n"
"int22_GCAGAAGU 0.7\n"
"int22_GCAGAAUA 0.7\n"
"int22_GCAGAAUG 0.7\n"
"int22_GCAGACGU 0.6\n"
"int22_GCAGACUA 0.7\n"
"int22_GCAGACUG 0.7\n"
"int22_GCAGAGGC -1.3\n"
"int22_GCAGAGGU -0.5\n"
"int22_GCAGAGUA -0.3\n"
"int22_GCAGAGUG -0.3\n"
"int22_GCAGAUGC 2.0\n"
"int22_GCAGAUGU 2.0\n"
"int22_GCAGAUUA 2.0\n"
"int22_GCAGAUUG 2.0\n"
"int22_GCAGCAGC -0.1\n"
"int22_GCAGCAGU 0.5\n"
"int22_GCAGCAUA 0.3\n"
"int22_GCAGCAUG 0.3\n"
"int22_GCAGCCGC 0.9\n"
"int22_GCAGCCGU 1.4\n"
"int22_GCAGCCUA 1.7\n"
"int22_GCAGCCUG 1.7\n"
"int22_GCAGCGGC 2.0\n"
"int22_GCAGCGGU 2.0\n"
"int22_GCAGCGUA 2.0\n"
"int22_GCAGCGUG 2.0\n"
"int22_GCAGCUGC 0.9\n"
"int22_GCAGCUGU 1.4\n"
"int22_GCAGCUUA 1.4\n"
"int22_GCAGCUUG 1.4\n"
"int22_GCAGGAGC -1.9\n"
"int22_GCAGGAGU -0.5\n"
"int22_GCAGGAUA -0.3\n"
"int22_GCAGGAUG -0.3\n"
"int22_GCAGGCGC 2.0\n"
"int22_GCAGGCGU 2.0\n"
"int22_GCAGGCUA 2.0\n"
"int22_GCAGGCUG 2.0\n"
"int22_GCAGGGGC -0.2\n"
"int22_GCAGGGGU 0.0\n"
"int22_GCAGGGUA 0.1\n"
"int22_GCAGGGUG 0.1\n"
"int22_GCAGGUGC -0.9\n"
"int22_GCAGGUGU 1.1\n"
"int22_GCAGGUUA 1.0\n"
"int22_GCAGGUUG 1.0\n"
"int22_GCAGUAGC 2.0\n"
"int22_GCAGUAGU 2.0\n"
"int22_GCAGUAUA 2.0\n"
"int22_GCAGUAUG 2.0\n"
"int22_GCAGUCGC -0.1\n"
"int22_GCAGUCGU 1.4\n"
"int22_GCAGUCUA 1.7\n"
"int22_GCAGUCUG 1.7\n"
"int22_GCAGUGGC -1.3\n"
"int22_GCAGUGGU 0.1\n"
"int22_GCAGUGUA -0.3\n"
"int22_GCAGUGUG -0.3\n"
"int22_GCAGUUGC 0.9\n"
"int22_GCAGUUGU 1.5\n"
"int22_GCAGUUUA 1.7\n"
"int22_GCAGUUUG 1.7\n"
"int22_GCAUAAGU 2.0\n"
"int22_GCAUAAUA 2.0\n"
"int22_GCAUAAUG 2.0\n"
"int22_GCAUACGU 2.0\n"
"int22_GCAUACUA 2.0\n"
"int22_GCAUACUG 2.0\n"
"int22_GCAUAGGU 2.0\n"
"int22_GCAUAGUA 2.0\n"
"int22_GCAUAGUG 2.0\n"
"int22_GCAUAUGC 2.0\n"
"int22_GCAUAUGU 2.0\n"
"int22_GCAUAUUA 2.0\n"
"int22_GCAUAUUG 2.0\n"
"int22_GCAUCAGC 2.0\n"
"int22_GCAUCAGU 2.0\n"
"int22_GCAUCAUA 2.0\n"
"int22_GCAUCAUG 2.0\n"
"int22_GCAUCCGC 2.0\n"
"int22_GCAUCCGU 2.0\n"
"int22_GCAUCCUA 2.0\n"
"int22_GCAUCCUG 2.0\n"
"int22_GCAUCGGC 2.0\n"
"int22_GCAUCGGU 2.0\n"
"int22_GCAUCGUA 2.0\n"
"int22_GCAUCGUG 2.0\n"
"int22_GCAUCUGC 2.0\n"
"int22_GCAUCUGU 2.0\n"
"int22_GCAUCUUA 2.0\n"
"int22_GCAUCUUG 2.0\n"
"int22_GCAUGAGC 2.0\n"
"int22_GCAUGAGU 2.0\n"
"int22_GCAUGAUA 2.0\n"
"int22_GCAUGAUG 2.0\n"
"int22_GCAUGCGC 2.0\n"
"int22_GCAUGCGU 2.0\n"
"int22_GCAUGCUA 2.0\n"
"int22_GCAUGCUG 2.0\n"
"int22_GCAUGGGC 2.0\n"
"int22_GCAUGGGU 2.0\n"
"int22_GCAUGGUA 2.0\n"
"int22_GCAUGGUG 2.0\n"
"int22_GCAUGUGC 2.0\n"
"int22_GCAUGUGU 2.0\n"
"int22_GCAUGUUA 2.0\n"
"int22_GCAUGUUG 2.0\n"
"int22_GCAUUAGC 2.0\n"
"int22_GCAUUAGU 2.0\n"
"int22_GCAUUAUA 2.0\n"
"int22_GCAUUAUG 2.0\n"
"int22_GCAUUCGC 2.0\n"
"int22_GCAUUCGU 2.0\n"
"int22_GCAUUCUA 2.0\n"
"int22_GCAUUCUG 2.0\n"
"int22_GCAUUGGC 2.0\n"
"int22_GCAUUGGU 2.0\n"
"int22_GCAUUGUA 2.0\n"
"int22_GCAUUGUG 2.0\n"
"int22_GCAUUUGC 2.0\n"
"int22_GCAUUUGU 2.0\n"
"int22_GCAUUUUA 2.0\n"
"int22_GCAUUUUG 2.0\n"
"int22_GCCAAAGU 1.9\n"
"int22_GCCAAAUA 1.9\n"
"int22_GCCAAAUG 1.9\n"
"int22_GCCAACGU 1.7\n"
"int22_GCCAACUA 1.9\n"
"int22_GCCAACUG 1.9\n"
"int22_GCCAAGGU 0.6\n"
"int22_GCCAAGUA 0.8\n"
"int22_GCCAAGUG 0.8\n"
"int22_GCCAAUGU 2.0\n"
"int22_GCCAAUUA 2.0\n"
"int22_GCCAAUUG 2.0\n"
"int22_GCCACAGC 1.0\n"
"int22_GCCACAGU 1.6\n"
"int22_GCCACAUA 1.4\n"
"int22_GCCACAUG 1.4\n"
"int22_GCCACCGC 1.0\n"
"int22_GCCACCGU 1.6\n"
"int22_GCCACCUA 1.9\n"
"int22_GCCACCUG 1.9\n"
"int22_GCCACGGC 2.0\n"
"int22_GCCACGGU 2.0\n"
"int22_GCCACGUA 2.0\n"
"int22_GCCACGUG 2.0\n"
"int22_GCCACUGC 1.0\n"
"int22_GCCACUGU 1.6\n"
"int22_GCCACUUA 1.6\n"
"int22_GCCACUUG 1.6\n"
"int22_GCCAGAGC -0.8\n"
"int22_GCCAGAGU 0.6\n"
"int22_GCCAGAUA 0.8\n"
"int22_GCCAGAUG 0.8\n"
"int22_GCCAGCGC 2.0\n"
"int22_GCCAGCGU 2.0\n"
"int22_GCCAGCUA 2.0\n"
"int22_GCCAGCUG 2.0\n"
"int22_GCCAGGGC 0.9\n"
"int22_GCCAGGGU 1.2\n"
"int22_GCCAGGUA 1.2\n"
"int22_GCCAGGUG 1.2\n"
"int22_GCCAGUGC -1.5\n"
"int22_GCCAGUGU 0.4\n"
"int22_GCCAGUUA 0.3\n"
"int22_GCCAGUUG 0.3\n"
"int22_GCCAUAGC 2.0\n"
"int22_GCCAUAGU 2.0\n"
"int22_GCCAUAUA 2.0\n"
"int22_GCCAUAUG 2.0\n"
"int22_GCCAUCGC 0.0\n"
"int22_GCCAUCGU 1.6\n"
"int22_GCCAUCUA 1.9\n"
"int22_GCCAUCUG 1.9\n"
"int22_GCCAUGGC -1.9\n"
"int22_GCCAUGGU -0.5\n"
"int22_GCCAUGUA -0.9\n"
"int22_GCCAUGUG -0.9\n"
"int22_GCCAUUGC 0.2\n"
"int22_GCCAUUGU 0.8\n"
"int22_GCCAUUUA 1.0\n"
"int22_GCCAUUUG 1.0\n"
"int22_GCCCAAGU 2.5\n"
"int22_GCCCAAUA 2.5\n"
"int22_GCCCAAUG 2.5\n"
"int22_GCCCACGU 1.7\n"
"int22_GCCCACUA 1.9\n"
"int22_GCCCACUG 1.9\n"
"int22_GCCCAGGU 1.6\n"
"int22_GCCCAGUA 1.8\n"
"int22_GCCCAGUG 1.8\n"
"int22_GCCCAUGU 2.0\n"
"int22_GCCCAUUA 2.0\n"
"int22_GCCCAUUG 2.0\n"
"int22_GCCCCAGU 1.6\n"
"int22_GCCCCAUA 1.4\n"
"int22_GCCCCAUG 1.4\n"
"int22_GCCCCCGC 1.0\n"
"int22_GCCCCCGU 1.6\n"
"int22_GCCCCCUA 1.9\n"
"int22_GCCCCCUG 1.9\n"
"int22_GCCCCGGC 2.0\n"
"int22_GCCCCGGU 2.0\n"
"int22_GCCCCGUA 2.0\n"
"int22_GCCCCGUG 2.0\n"
"int22_GCCCCUGC 1.0\n"
"int22_GCCCCUGU 1.6\n"
"int22_GCCCCUUA 1.6\n"
"int22_GCCCCUUG 1.6\n"
"int22_GCCCGAGC 0.2\n"
"int22_GCCCGAGU 1.6\n"
"int22_GCCCGAUA 1.8\n"
"int22_GCCCGAUG 1.8\n"
"int22_GCCCGCGC 2.0\n"
"int22_GCCCGCGU 2.0\n"
"int22_GCCCGCUA 2.0\n"
"int22_GCCCGCUG 2.0\n"
"int22_GCCCGGGC 1.5\n"
"int22_GCCCGGGU 1.8\n"
"int22_GCCCGGUA 1.8\n"
"int22_GCCCGGUG 1.8\n"
"int22_GCCCGUGC -0.5\n"
"int22_GCCCGUGU 1.4\n"
"int22_GCCCGUUA 1.3\n"
"int22_GCCCGUUG 1.3\n"
"int22_GCCCUAGC 2.0\n"
"int22_GCCCUAGU 2.0\n"
"int22_GCCCUAUA 2.0\n"
"int22_GCCCUAUG 2.0\n"
"int22_GCCCUCGC 0.0\n"
"int22_GCCCUCGU 1.6\n"
"int22_GCCCUCUA 1.9\n"
"int22_GCCCUCUG 1.9\n"
"int22_GCCCUGGC -0.9\n"
"int22_GCCCUGGU 0.5\n"
"int22_GCCCUGUA 0.1\n"
"int22_GCCCUGUG 0.1\n"
"int22_GCCCUUGC 0.2\n"
"int22_GCCCUUGU 0.8\n"
"int22_GCCCUUUA 1.0\n"
"int22_GCCCUUUG 1.0\n"
"int22_GCCGAAGU 2.0\n"
"int22_GCCGAAUA 2.0\n"
"int22_GCCGAAUG 2.0\n"
"int22_GCCGACGU 2.0\n"
"int22_GCCGACUA 2.0\n"
"int22_GCCGACUG 2.0\n"
"int22_GCCGAGGU 2.0\n"
"int22_GCCGAGUA 2.0\n"
"int22_GCCGAGUG 2.0\n"
"int22_GCCGAUGU 2.0\n"
"int22_GCCGAUUA 2.0\n"
"int22_GCCGAUUG 2.0\n"
"int22_GCCGCAGU 2.0\n"
"int22_GCCGCAUA 2.0\n"
"int22_GCCGCAUG 2.0\n"
"int22_GCCGCCGU 2.0\n"
"int22_GCCGCCUA 2.0\n"
"int22_GCCGCCUG 2.0\n"
"int22_GCCGCGGC 2.0\n"
"int22_GCCGCGGU 2.0\n"
"int22_GCCGCGUA 2.0\n"
"int22_GCCGCGUG 2.0\n"
"int22_GCCGCUGC 2.0\n"
"int22_GCCGCUGU 2.0\n"
"int22_GCCGCUUA 2.0\n"
"int22_GCCGCUUG 2.0\n"
"int22_GCCGGAGC 2.0\n"
"int22_GCCGGAGU 2.0\n"
"int22_GCCGGAUA 2.0\n"
"int22_GCCGGAUG 2.0\n"
"int22_GCCGGCGC 2.0\n"
"int22_GCCGGCGU 2.0\n"
"int22_GCCGGCUA 2.0\n"
"int22_GCCGGCUG 2.0\n"
"int22_GCCGGGGC 2.0\n"
"int22_GCCGGGGU 2.0\n"
"int22_GCCGGGUA 2.0\n"
"int22_GCCGGGUG 2.0\n"
"int22_GCCGGUGC 2.0\n"
"int22_GCCGGUGU 2.0\n"
"int22_GCCGGUUA 2.0\n"
"int22_GCCGGUUG 2.0\n"
"int22_GCCGUAGC 2.0\n"
"int22_GCCGUAGU 2.0\n"
"int22_GCCGUAUA 2.0\n"
"int22_GCCGUAUG 2.0\n"
"int22_GCCGUCGC 2.0\n"
"int22_GCCGUCGU 2.0\n"
"int22_GCCGUCUA 2.0\n"
"int22_GCCGUCUG 2.0\n"
"int22_GCCGUGGC 2.0\n"
"int22_GCCGUGGU 2.0\n"
"int22_GCCGUGUA 2.0\n"
"int22_GCCGUGUG 2.0\n"
"int22_GCCGUUGC 2.0\n"
"int22_GCCGUUGU 2.0\n"
"int22_GCCGUUUA 2.0\n"
"int22_GCCGUUUG 2.0\n"
"int22_GCCUAAGU 2.5\n"
"int22_GCCUAAUA 2.5\n"
"int22_GCCUAAUG 2.5\n"
"int22_GCCUACGU 1.8\n"
"int22_GCCUACUA 1.9\n"
"int22_GCCUACUG 1.9\n"
"int22_GCCUAGGU 1.7\n"
"int22_GCCUAGUA 1.9\n"
"int22_GCCUAGUG 1.9\n"
"int22_GCCUAUGU 2.0\n"
"int22_GCCUAUUA 2.0\n"
"int22_GCCUAUUG 2.0\n"
"int22_GCCUCAGU 1.7\n"
"int22_GCCUCAUA 1.5\n"
"int22_GCCUCAUG 1.5\n"
"int22_GCCUCCGU 1.6\n"
"int22_GCCUCCUA 1.9\n"
"int22_GCCUCCUG 1.9\n"
"int22_GCCUCGGU 2.0\n"
"int22_GCCUCGUA 2.0\n"
"int22_GCCUCGUG 2.0\n"
"int22_GCCUCUGC 1.1\n"
"int22_GCCUCUGU 1.6\n"
"int22_GCCUCUUA 1.6\n"
"int22_GCCUCUUG 1.6\n"
"int22_GCCUGAGC 0.3\n"
"int22_GCCUGAGU 1.7\n"
"int22_GCCUGAUA 1.9\n"
"int22_GCCUGAUG 1.9\n"
"int22_GCCUGCGC 2.0\n"
"int22_GCCUGCGU 2.0\n"
"int22_GCCUGCUA 2.0\n"
"int22_GCCUGCUG 2.0\n"
"int22_GCCUGGGC 1.5\n"
"int22_GCCUGGGU 1.8\n"
"int22_GCCUGGUA 1.9\n"
"int22_GCCUGGUG 1.9\n"
"int22_GCCUGUGC -0.5\n"
"int22_GCCUGUGU 1.5\n"
"int22_GCCUGUUA 1.4\n"
"int22_GCCUGUUG 1.4\n"
"int22_GCCUUAGC 2.0\n"
"int22_GCCUUAGU 2.0\n"
"int22_GCCUUAUA 2.0\n"
"int22_GCCUUAUG 2.0\n"
"int22_GCCUUCGC 0.0\n"
"int22_GCCUUCGU 1.6\n"
"int22_GCCUUCUA 1.9\n"
"int22_GCCUUCUG 1.9\n"
"int22_GCCUUGGC -0.9\n"
"int22_GCCUUGGU 0.5\n"
"int22_GCCUUGUA 0.1\n"
"int22_GCCUUGUG 0.1\n"
"int22_GCCUUUGC 0.3\n"
"int22_GCCUUUGU 0.8\n"
"int22_GCCUUUUA 1.1\n"
"int22_GCCUUUUG 1.1\n"
"int22_GCGAAAGU 0.1\n"
"int22_GCGAAAUA 0.1\n"
"int22_GCGAAAUG 0.1\n"
"int22_GCGAACGU 0.0\n"
"int22_GCGAACUA 0.1\n"
"int22_GCGAACUG 0.1\n"
"int22_GCGAAGGU -1.1\n"
"int22_GCGAAGUA -0.9\n"
"int22_GCGAAGUG -0.9\n"
"int22_GCGAAUGU 2.0\n"
"int22_GCGAAUUA 2.0\n"
"int22_GCGAAUUG 2.0\n"
"int22_GCGACAGU -0.1\n"
"int22_GCGACAUA -0.3\n"
"int22_GCGACAUG -0.3\n"
"int22_GCGACCGU 0.8\n"
"int22_GCGACCUA 1.1\n"
"int22_GCGACCUG 1.1\n"
"int22_GCGACGGU 2.0\n"
"int22_GCGACGUA 2.0\n"
"int22_GCGACGUG 2.0\n"
"int22_GCGACUGU 0.8\n"
"int22_GCGACUUA 0.8\n"
"int22_GCGACUUG 0.8\n"
"int22_GCGAGAGC -2.6\n"
"int22_GCGAGAGU -1.1\n"
"int22_GCGAGAUA -0.9\n"
"int22_GCGAGAUG -0.9\n"
"int22_GCGAGCGC 2.0\n"
"int22_GCGAGCGU 2.0\n"
"int22_GCGAGCUA 2.0\n"
"int22_GCGAGCUG 2.0\n"
"int22_GCGAGGGC -0.9\n"
"int22_GCGAGGGU -0.6\n"
"int22_GCGAGGUA -0.5\n"
"int22_GCGAGGUG -0.5\n"
"int22_GCGAGUGC -1.5\n"
"int22_GCGAGUGU 0.5\n"
"int22_GCGAGUUA 0.4\n"
"int22_GCGAGUUG 0.4\n"
"int22_GCGAUAGC 2.0\n"
"int22_GCGAUAGU 2.0\n"
"int22_GCGAUAUA 2.0\n"
"int22_GCGAUAUG 2.0\n"
"int22_GCGAUCGC -0.8\n"
"int22_GCGAUCGU 0.8\n"
"int22_GCGAUCUA 1.1\n"
"int22_GCGAUCUG 1.1\n"
"int22_GCGAUGGC -1.9\n"
"int22_GCGAUGGU -0.5\n"
"int22_GCGAUGUA -0.9\n"
"int22_GCGAUGUG -0.9\n"
"int22_GCGAUUGC 0.3\n"
"int22_GCGAUUGU 0.8\n"
"int22_GCGAUUUA 1.1\n"
"int22_GCGAUUUG 1.1\n"
"int22_GCGCAAGU 2.0\n"
"int22_GCGCAAUA 2.0\n"
"int22_GCGCAAUG 2.0\n"
"int22_GCGCACGU 2.0\n"
"int22_GCGCACUA 2.0\n"
"int22_GCGCACUG 2.0\n"
"int22_GCGCAGGU 2.0\n"
"int22_GCGCAGUA 2.0\n"
"int22_GCGCAGUG 2.0\n"
"int22_GCGCAUGU 2.0\n"
"int22_GCGCAUUA 2.0\n"
"int22_GCGCAUUG 2.0\n"
"int22_GCGCCAGU 2.0\n"
"int22_GCGCCAUA 2.0\n"
"int22_GCGCCAUG 2.0\n"
"int22_GCGCCCGU 2.0\n"
"int22_GCGCCCUA 2.0\n"
"int22_GCGCCCUG 2.0\n"
"int22_GCGCCGGU 2.0\n"
"int22_GCGCCGUA 2.0\n"
"int22_GCGCCGUG 2.0\n"
"int22_GCGCCUGU 2.0\n"
"int22_GCGCCUUA 2.0\n"
"int22_GCGCCUUG 2.0\n"
"int22_GCGCGAGU 2.0\n"
"int22_GCGCGAUA 2.0\n"
"int22_GCGCGAUG 2.0\n"
"int22_GCGCGCGC 2.0\n"
"int22_GCGCGCGU 2.0\n"
"int22_GCGCGCUA 2.0\n"
"int22_GCGCGCUG 2.0\n"
"int22_GCGCGGGC 2.0\n"
"int22_GCGCGGGU 2.0\n"
"int22_GCGCGGUA 2.0\n"
"int22_GCGCGGUG 2.0\n"
"int22_GCGCGUGC 2.0\n"
"int22_GCGCGUGU 2.0\n"
"int22_GCGCGUUA 2.0\n"
"int22_GCGCGUUG 2.0\n"
"int22_GCGCUAGC 2.0\n"
"int22_GCGCUAGU 2.0\n"
"int22_GCGCUAUA 2.0\n"
"int22_GCGCUAUG 2.0\n"
"int22_GCGCUCGC 2.0\n"
"int22_GCGCUCGU 2.0\n"
"int22_GCGCUCUA 2.0\n"
"int22_GCGCUCUG 2.0\n"
"int22_GCGCUGGC 2.0\n"
"int22_GCGCUGGU 2.0\n"
"int22_GCGCUGUA 2.0\n"
"int22_GCGCUGUG 2.0\n"
"int22_GCGCUUGC 2.0\n"
"int22_GCGCUUGU 2.0\n"
"int22_GCGCUUUA 2.0\n"
"int22_GCGCUUUG 2.0\n"
"int22_GCGGAAGU 1.8\n"
"int22_GCGGAAUA 1.8\n"
"int22_GCGGAAUG 1.8\n"
"int22_GCGGACGU 1.6\n"
"int22_GCGGACUA 1.8\n"
"int22_GCGGACUG 1.8\n"
"int22_GCGGAGGU 0.5\n"
"int22_GCGGAGUA 0.7\n"
"int22_GCGGAGUG 0.7\n"
"int22_GCGGAUGU 2.0\n"
"int22_GCGGAUUA 2.0\n"
"int22_GCGGAUUG 2.0\n"
"int22_GCGGCAGU 1.5\n"
"int22_GCGGCAUA 1.3\n"
"int22_GCGGCAUG 1.3\n"
"int22_GCGGCCGU 2.1\n"
"int22_GCGGCCUA 2.4\n"
"int22_GCGGCCUG 2.4\n"
"int22_GCGGCGGU 2.0\n"
"int22_GCGGCGUA 2.0\n"
"int22_GCGGCGUG 2.0\n"
"int22_GCGGCUGU 2.1\n"
"int22_GCGGCUUA 2.1\n"
"int22_GCGGCUUG 2.1\n"
"int22_GCGGGAGU 0.5\n"
"int22_GCGGGAUA 0.7\n"
"int22_GCGGGAUG 0.7\n"
"int22_GCGGGCGU 2.0\n"
"int22_GCGGGCUA 2.0\n"
"int22_GCGGGCUG 2.0\n"
"int22_GCGGGGGC 0.8\n"
"int22_GCGGGGGU 1.1\n"
"int22_GCGGGGUA 1.1\n"
"int22_GCGGGGUG 1.1\n"
"int22_GCGGGUGC -0.6\n"
"int22_GCGGGUGU 1.3\n"
"int22_GCGGGUUA 1.2\n"
"int22_GCGGGUUG 1.2\n"
"int22_GCGGUAGC 2.0\n"
"int22_GCGGUAGU 2.0\n"
"int22_GCGGUAUA 2.0\n"
"int22_GCGGUAUG 2.0\n"
"int22_GCGGUCGC 0.5\n"
"int22_GCGGUCGU 2.1\n"
"int22_GCGGUCUA 2.4\n"
"int22_GCGGUCUG 2.4\n"
"int22_GCGGUGGC -1.0\n"
"int22_GCGGUGGU 0.4\n"
"int22_GCGGUGUA 0.0\n"
"int22_GCGGUGUG 0.0\n"
"int22_GCGGUUGC 1.1\n"
"int22_GCGGUUGU 1.7\n"
"int22_GCGGUUUA 1.9\n"
"int22_GCGGUUUG 1.9\n"
"int22_GCGUAAGU 0.4\n"
"int22_GCGUAAUA 0.4\n"
"int22_GCGUAAUG 0.4\n"
"int22_GCGUACGU -0.8\n"
"int22_GCGUACUA -0.6\n"
"int22_GCGUACUG -0.6\n"
"int22_GCGUAGGU -0.1\n"
"int22_GCGUAGUA 0.1\n"
"int22_GCGUAGUG 0.1\n"
"int22_GCGUAUGU 2.0\n"
"int22_GCGUAUUA 2.0\n"
"int22_GCGUAUUG 2.0\n"
"int22_GCGUCAGU -0.9\n"
"int22_GCGUCAUA -1.1\n"
"int22_GCGUCAUG -1.1\n"
"int22_GCGUCCGU 0.1\n"
"int22_GCGUCCUA 0.4\n"
"int22_GCGUCCUG 0.4\n"
"int22_GCGUCGGU 2.0\n"
"int22_GCGUCGUA 2.0\n"
"int22_GCGUCGUG 2.0\n"
"int22_GCGUCUGU 0.1\n"
"int22_GCGUCUUA 0.1\n"
"int22_GCGUCUUG 0.1\n"
"int22_GCGUGAGU -0.1\n"
"int22_GCGUGAUA 0.1\n"
"int22_GCGUGAUG 0.1\n"
"int22_GCGUGCGU 2.0\n"
"int22_GCGUGCUA 2.0\n"
"int22_GCGUGCUG 2.0\n"
"int22_GCGUGGGU -0.3\n"
"int22_GCGUGGUA -0.3\n"
"int22_GCGUGGUG -0.3\n"
"int22_GCGUGUGC -4.1\n"
"int22_GCGUGUGU -2.1\n"
"int22_GCGUGUUA -2.2\n"
"int22_GCGUGUUG -2.2\n"
"int22_GCGUUAGC 2.0\n"
"int22_GCGUUAGU 2.0\n"
"int22_GCGUUAUA 2.0\n"
"int22_GCGUUAUG 2.0\n"
"int22_GCGUUCGC -1.5\n"
"int22_GCGUUCGU 0.1\n"
"int22_GCGUUCUA 0.4\n"
"int22_GCGUUCUG 0.4\n"
"int22_GCGUUGGC -4.5\n"
"int22_GCGUUGGU -3.1\n"
"int22_GCGUUGUA -3.5\n"
"int22_GCGUUGUG -3.5\n"
"int22_GCGUUUGC -0.5\n"
"int22_GCGUUUGU 0.1\n"
"int22_GCGUUUUA 0.3\n"
"int22_GCGUUUUG 0.3\n"
"int22_GCUAAAGU 2.0\n"
"int22_GCUAAAUA 2.0\n"
"int22_GCUAAAUG 2.0\n"
"int22_GCUAACGU 2.0\n"
"int22_GCUAACUA 2.0\n"
"int22_GCUAACUG 2.0\n"
"int22_GCUAAGGU 2.0\n"
"int22_GCUAAGUA 2.0\n"
"int22_GCUAAGUG 2.0\n"
"int22_GCUAAUGU 2.0\n"
"int22_GCUAAUUA 2.0\n"
"int22_GCUAAUUG 2.0\n"
"int22_GCUACAGU 2.0\n"
"int22_GCUACAUA 2.0\n"
"int22_GCUACAUG 2.0\n"
"int22_GCUACCGU 2.0\n"
"int22_GCUACCUA 2.0\n"
"int22_GCUACCUG 2.0\n"
"int22_GCUACGGU 2.0\n"
"int22_GCUACGUA 2.0\n"
"int22_GCUACGUG 2.0\n"
"int22_GCUACUGU 2.0\n"
"int22_GCUACUUA 2.0\n"
"int22_GCUACUUG 2.0\n"
"int22_GCUAGAGU 2.0\n"
"int22_GCUAGAUA 2.0\n"
"int22_GCUAGAUG 2.0\n"
"int22_GCUAGCGU 2.0\n"
"int22_GCUAGCUA 2.0\n"
"int22_GCUAGCUG 2.0\n"
"int22_GCUAGGGU 2.0\n"
"int22_GCUAGGUA 2.0\n"
"int22_GCUAGGUG 2.0\n"
"int22_GCUAGUGU 2.0\n"
"int22_GCUAGUUA 2.0\n"
"int22_GCUAGUUG 2.0\n"
"int22_GCUAUAGC 2.0\n"
"int22_GCUAUAGU 2.0\n"
"int22_GCUAUAUA 2.0\n"
"int22_GCUAUAUG 2.0\n"
"int22_GCUAUCGC 2.0\n"
"int22_GCUAUCGU 2.0\n"
"int22_GCUAUCUA 2.0\n"
"int22_GCUAUCUG 2.0\n"
"int22_GCUAUGGC 2.0\n"
"int22_GCUAUGGU 2.0\n"
"int22_GCUAUGUA 2.0\n"
"int22_GCUAUGUG 2.0\n"
"int22_GCUAUUGC 2.0\n"
"int22_GCUAUUGU 2.0\n"
"int22_GCUAUUUA 2.0\n"
"int22_GCUAUUUG 2.0\n"
"int22_GCUCAAGU 1.5\n"
"int22_GCUCAAUA 1.5\n"
"int22_GCUCAAUG 1.5\n"
"int22_GCUCACGU 0.7\n"
"int22_GCUCACUA 0.9\n"
"int22_GCUCACUG 0.9\n"
"int22_GCUCAGGU 0.7\n"
"int22_GCUCAGUA 0.9\n"
"int22_GCUCAGUG 0.9\n"
"int22_GCUCAUGU 2.0\n"
"int22_GCUCAUUA 2.0\n"
"int22_GCUCAUUG 2.0\n"
"int22_GCUCCAGU 0.6\n"
"int22_GCUCCAUA 0.4\n"
"int22_GCUCCAUG 0.4\n"
"int22_GCUCCCGU 0.6\n"
"int22_GCUCCCUA 0.9\n"
"int22_GCUCCCUG 0.9\n"
"int22_GCUCCGGU 2.0\n"
"int22_GCUCCGUA 2.0\n"
"int22_GCUCCGUG 2.0\n"
"int22_GCUCCUGU 0.6\n"
"int22_GCUCCUUA 0.6\n"
"int22_GCUCCUUG 0.6\n"
"int22_GCUCGAGU 0.7\n"
"int22_GCUCGAUA 0.9\n"
"int22_GCUCGAUG 0.9\n"
"int22_GCUCGCGU 2.0\n"
"int22_GCUCGCUA 2.0\n"
"int22_GCUCGCUG 2.0\n"
"int22_GCUCGGGU 0.8\n"
"int22_GCUCGGUA 0.8\n"
"int22_GCUCGGUG 0.8\n"
"int22_GCUCGUGU 0.5\n"
"int22_GCUCGUUA 0.4\n"
"int22_GCUCGUUG 0.4\n"
"int22_GCUCUAGU 2.0\n"
"int22_GCUCUAUA 2.0\n"
"int22_GCUCUAUG 2.0\n"
"int22_GCUCUCGC -1.0\n"
"int22_GCUCUCGU 0.6\n"
"int22_GCUCUCUA 0.9\n"
"int22_GCUCUCUG 0.9\n"
"int22_GCUCUGGC -1.9\n"
"int22_GCUCUGGU -0.5\n"
"int22_GCUCUGUA -0.9\n"
"int22_GCUCUGUG -0.9\n"
"int22_GCUCUUGC -0.7\n"
"int22_GCUCUUGU -0.2\n"
"int22_GCUCUUUA 0.0\n"
"int22_GCUCUUUG 0.0\n"
"int22_GCUGAAGU 0.0\n"
"int22_GCUGAAUA 0.0\n"
"int22_GCUGAAUG 0.0\n"
"int22_GCUGACGU -1.2\n"
"int22_GCUGACUA -1.0\n"
"int22_GCUGACUG -1.0\n"
"int22_GCUGAGGU -0.5\n"
"int22_GCUGAGUA -0.3\n"
"int22_GCUGAGUG -0.3\n"
"int22_GCUGAUGU 2.0\n"
"int22_GCUGAUUA 2.0\n"
"int22_GCUGAUUG 2.0\n"
"int22_GCUGCAGU -1.3\n"
"int22_GCUGCAUA -1.5\n"
"int22_GCUGCAUG -1.5\n"
"int22_GCUGCCGU -0.3\n"
"int22_GCUGCCUA 0.0\n"
"int22_GCUGCCUG 0.0\n"
"int22_GCUGCGGU 2.0\n"
"int22_GCUGCGUA 2.0\n"
"int22_GCUGCGUG 2.0\n"
"int22_GCUGCUGU -0.3\n"
"int22_GCUGCUUA -0.3\n"
"int22_GCUGCUUG -0.3\n"
"int22_GCUGGAGU -0.5\n"
"int22_GCUGGAUA -0.3\n"
"int22_GCUGGAUG -0.3\n"
"int22_GCUGGCGU 2.0\n"
"int22_GCUGGCUA 2.0\n"
"int22_GCUGGCUG 2.0\n"
"int22_GCUGGGGU -0.7\n"
"int22_GCUGGGUA -0.7\n"
"int22_GCUGGGUG -0.7\n"
"int22_GCUGGUGU -2.5\n"
"int22_GCUGGUUA -2.6\n"
"int22_GCUGGUUG -2.6\n"
"int22_GCUGUAGU 2.0\n"
"int22_GCUGUAUA 2.0\n"
"int22_GCUGUAUG 2.0\n"
"int22_GCUGUCGU -0.3\n"
"int22_GCUGUCUA 0.0\n"
"int22_GCUGUCUG 0.0\n"
"int22_GCUGUGGC -4.9\n"
"int22_GCUGUGGU -3.5\n"
"int22_GCUGUGUA -3.9\n"
"int22_GCUGUGUG -3.9\n"
"int22_GCUGUUGC -0.9\n"
"int22_GCUGUUGU -0.3\n"
"int22_GCUGUUUA -0.1\n"
"int22_GCUGUUUG -0.1\n"
"int22_GCUUAAGU 2.1\n"
"int22_GCUUAAUA 2.1\n"
"int22_GCUUAAUG 2.1\n"
"int22_GCUUACGU 1.0\n"
"int22_GCUUACUA 1.1\n"
"int22_GCUUACUG 1.1\n"
"int22_GCUUAGGU 1.7\n"
"int22_GCUUAGUA 1.9\n"
"int22_GCUUAGUG 1.9\n"
"int22_GCUUAUGU 2.0\n"
"int22_GCUUAUUA 2.0\n"
"int22_GCUUAUUG 2.0\n"
"int22_GCUUCAGU 0.9\n"
"int22_GCUUCAUA 0.7\n"
"int22_GCUUCAUG 0.7\n"
"int22_GCUUCCGU 0.8\n"
"int22_GCUUCCUA 1.1\n"
"int22_GCUUCCUG 1.1\n"
"int22_GCUUCGGU 2.0\n"
"int22_GCUUCGUA 2.0\n"
"int22_GCUUCGUG 2.0\n"
"int22_GCUUCUGU 0.8\n"
"int22_GCUUCUUA 0.8\n"
"int22_GCUUCUUG 0.8\n"
"int22_GCUUGAGU 1.7\n"
"int22_GCUUGAUA 1.9\n"
"int22_GCUUGAUG 1.9\n"
"int22_GCUUGCGU 2.0\n"
"int22_GCUUGCUA 2.0\n"
"int22_GCUUGCUG 2.0\n"
"int22_GCUUGGGU 1.4\n"
"int22_GCUUGGUA 1.5\n"
"int22_GCUUGGUG 1.5\n"
"int22_GCUUGUGU 1.5\n"
"int22_GCUUGUUA 1.4\n"
"int22_GCUUGUUG 1.4\n"
"int22_GCUUUAGU 2.0\n"
"int22_GCUUUAUA 2.0\n"
"int22_GCUUUAUG 2.0\n"
"int22_GCUUUCGU 0.8\n"
"int22_GCUUUCUA 1.1\n"
"int22_GCUUUCUG 1.1\n"
"int22_GCUUUGGU 0.5\n"
"int22_GCUUUGUA 0.1\n"
"int22_GCUUUGUG 0.1\n"
"int22_GCUUUUGC -0.5\n"
"int22_GCUUUUGU 0.0\n"
"int22_GCUUUUUA 0.3\n"
"int22_GCUUUUUG 0.3\n"
"int22_GUAAAAGU 2.8\n"
"int22_GUAAAAUA 2.8\n"
"int22_GUAAAAUG 2.8\n"
"int22_GUAAACGU 2.6\n"
"int22_GUAAACUA 2.8\n"
"int22_GUAAACUG 2.8\n"
"int22_GUAAAGGU 1.5\n"
"int22_GUAAAGUA 1.7\n"
"int22_GUAAAGUG 1.7\n"
"int22_GUAAAUGU 2.0\n"
"int22_GUAAAUUA 2.0\n"
"int22_GUAAAUUG 2.0\n"
"int22_GUAACAGU 2.5\n"
"int22_GUAACAUA 2.3\n"
"int22_GUAACAUG 2.3\n"
"int22_GUAACCGU 3.1\n"
"int22_GUAACCUA 3.4\n"
"int22_GUAACCUG 3.4\n"
"int22_GUAACGGU 2.0\n"
"int22_GUAACGUA 2.0\n"
"int22_GUAACGUG 2.0\n"
"int22_GUAACUGU 3.1\n"
"int22_GUAACUUA 3.1\n"
"int22_GUAACUUG 3.1\n"
"int22_GUAAGAGU 1.5\n"
"int22_GUAAGAUA 1.7\n"
"int22_GUAAGAUG 1.7\n"
"int22_GUAAGCGU 2.0\n"
"int22_GUAAGCUA 2.0\n"
"int22_GUAAGCUG 2.0\n"
"int22_GUAAGGGU 2.1\n"
"int22_GUAAGGUA 2.1\n"
"int22_GUAAGGUG 2.1\n"
"int22_GUAAGUGU 2.3\n"
"int22_GUAAGUUA 2.2\n"
"int22_GUAAGUUG 2.2\n"
"int22_GUAAUAGU 2.0\n"
"int22_GUAAUAUA 2.0\n"
"int22_GUAAUAUG 2.0\n"
"int22_GUAAUCGU 3.1\n"
"int22_GUAAUCUA 3.4\n"
"int22_GUAAUCUG 3.4\n"
"int22_GUAAUGGU 1.3\n"
"int22_GUAAUGUA 1.0\n"
"int22_GUAAUGUG 1.0\n"
"int22_GUAAUUGU 2.7\n"
"int22_GUAAUUUA 2.9\n"
"int22_GUAAUUUG 2.9\n"
"int22_GUACAAUA 2.6\n"
"int22_GUACAAUG 2.6\n"
"int22_GUACACGU 2.5\n"
"int22_GUACACUA 2.6\n"
"int22_GUACACUG 2.6\n"
"int22_GUACAGGU 1.4\n"
"int22_GUACAGUA 1.6\n"
"int22_GUACAGUG 1.6\n"
"int22_GUACAUGU 2.0\n"
"int22_GUACAUUA 2.0\n"
"int22_GUACAUUG 2.0\n"
"int22_GUACCAGU 2.4\n"
"int22_GUACCAUA 2.2\n"
"int22_GUACCAUG 2.2\n"
"int22_GUACCCGU 2.3\n"
"int22_GUACCCUA 2.6\n"
"int22_GUACCCUG 2.6\n"
"int22_GUACCGGU 2.0\n"
"int22_GUACCGUA 2.0\n"
"int22_GUACCGUG 2.0\n"
"int22_GUACCUGU 2.3\n"
"int22_GUACCUUA 2.3\n"
"int22_GUACCUUG 2.3\n"
"int22_GUACGAGU 1.4\n"
"int22_GUACGAUA 1.6\n"
"int22_GUACGAUG 1.6\n"
"int22_GUACGCGU 2.0\n"
"int22_GUACGCUA 2.0\n"
"int22_GUACGCUG 2.0\n"
"int22_GUACGGGU 1.9\n"
"int22_GUACGGUA 2.0\n"
"int22_GUACGGUG 2.0\n"
"int22_GUACGUGU 1.2\n"
"int22_GUACGUUA 1.1\n"
"int22_GUACGUUG 1.1\n"
"int22_GUACUAGU 2.0\n"
"int22_GUACUAUA 2.0\n"
"int22_GUACUAUG 2.0\n"
"int22_GUACUCGU 2.3\n"
"int22_GUACUCUA 2.6\n"
"int22_GUACUCUG 2.6\n"
"int22_GUACUGGU 0.2\n"
"int22_GUACUGUA -0.2\n"
"int22_GUACUGUG -0.2\n"
"int22_GUACUUGU 1.5\n"
"int22_GUACUUUA 1.8\n"
"int22_GUACUUUG 1.8\n"
"int22_GUAGAAUA 1.5\n"
"int22_GUAGAAUG 1.5\n"
"int22_GUAGACUA 1.5\n"
"int22_GUAGACUG 1.5\n"
"int22_GUAGAGGU 0.3\n"
"int22_GUAGAGUA 0.5\n"
"int22_GUAGAGUG 0.5\n"
"int22_GUAGAUGU 2.0\n"
"int22_GUAGAUUA 2.0\n"
"int22_GUAGAUUG 2.0\n"
"int22_GUAGCAGU 1.3\n"
"int22_GUAGCAUA 1.1\n"
"int22_GUAGCAUG 1.1\n"
"int22_GUAGCCGU 2.2\n"
"int22_GUAGCCUA 2.5\n"
"int22_GUAGCCUG 2.5\n"
"int22_GUAGCGGU 2.0\n"
"int22_GUAGCGUA 2.0\n"
"int22_GUAGCGUG 2.0\n"
"int22_GUAGCUGU 2.2\n"
"int22_GUAGCUUA 2.2\n"
"int22_GUAGCUUG 2.2\n"
"int22_GUAGGAGU 0.3\n"
"int22_GUAGGAUA 0.5\n"
"int22_GUAGGAUG 0.5\n"
"int22_GUAGGCGU 2.0\n"
"int22_GUAGGCUA 2.0\n"
"int22_GUAGGCUG 2.0\n"
"int22_GUAGGGGU 0.8\n"
"int22_GUAGGGUA 0.9\n"
"int22_GUAGGGUG 0.9\n"
"int22_GUAGGUGU 1.9\n"
"int22_GUAGGUUA 1.8\n"
"int22_GUAGGUUG 1.8\n"
"int22_GUAGUAGU 2.0\n"
"int22_GUAGUAUA 2.0\n"
"int22_GUAGUAUG 2.0\n"
"int22_GUAGUCGU 2.2\n"
"int22_GUAGUCUA 2.5\n"
"int22_GUAGUCUG 2.5\n"
"int22_GUAGUGGU 0.9\n"
"int22_GUAGUGUA 0.5\n"
"int22_GUAGUGUG 0.5\n"
"int22_GUAGUUGU 2.2\n"
"int22_GUAGUUUA 2.5\n"
"int22_GUAGUUUG 2.5\n"
"int22_GUAUAAUA 2.0\n"
"int22_GUAUAAUG 2.0\n"
"int22_GUAUACUA 2.0\n"
"int22_GUAUACUG 2.0\n"
"int22_GUAUAGUA 2.0\n"
"int22_GUAUAGUG 2.0\n"
"int22_GUAUAUGU 2.0\n"
"int22_GUAUAUUA 2.0\n"
"int22_GUAUAUUG 2.0\n"
"int22_GUAUCAGU 2.0\n"
"int22_GUAUCAUA 2.0\n"
"int22_GUAUCAUG 2.0\n"
"int22_GUAUCCGU 2.0\n"
"int22_GUAUCCUA 2.0\n"
"int22_GUAUCCUG 2.0\n"
"int22_GUAUCGGU 2.0\n"
"int22_GUAUCGUA 2.0\n"
"int22_GUAUCGUG 2.0\n"
"int22_GUAUCUGU 2.0\n"
"int22_GUAUCUUA 2.0\n"
"int22_GUAUCUUG 2.0\n"
"int22_GUAUGAGU 2.0\n"
"int22_GUAUGAUA 2.0\n"
"int22_GUAUGAUG 2.0\n"
"int22_GUAUGCGU 2.0\n"
"int22_GUAUGCUA 2.0\n"
"int22_GUAUGCUG 2.0\n"
"int22_GUAUGGGU 2.0\n"
"int22_GUAUGGUA 2.0\n"
"int22_GUAUGGUG 2.0\n"
"int22_GUAUGUGU 2.0\n"
"int22_GUAUGUUA 2.0\n"
"int22_GUAUGUUG 2.0\n"
"int22_GUAUUAGU 2.0\n"
"int22_GUAUUAUA 2.0\n"
"int22_GUAUUAUG 2.0\n"
"int22_GUAUUCGU 2.0\n"
"int22_GUAUUCUA 2.0\n"
"int22_GUAUUCUG 2.0\n"
"int22_GUAUUGGU 2.0\n"
"int22_GUAUUGUA 2.0\n"
"int22_GUAUUGUG 2.0\n"
"int22_GUAUUUGU 2.0\n"
"int22_GUAUUUUA 2.0\n"
"int22_GUAUUUUG 2.0\n"
"int22_GUCAAAUA 2.5\n"
"int22_GUCAAAUG 2.5\n"
"int22_GUCAACUA 2.5\n"
"int22_GUCAACUG 2.5\n"
"int22_GUCAAGUA 1.5\n"
"int22_GUCAAGUG 1.5\n"
"int22_GUCAAUUA 2.0\n"
"int22_GUCAAUUG 2.0\n"
"int22_GUCACAGU 2.3\n"
"int22_GUCACAUA 2.1\n"
"int22_GUCACAUG 2.1\n"
"int22_GUCACCGU 2.2\n"
"int22_GUCACCUA 2.5\n"
"int22_GUCACCUG 2.5\n"
"int22_GUCACGGU 2.0\n"
"int22_GUCACGUA 2.0\n"
"int22_GUCACGUG 2.0\n"
"int22_GUCACUGU 2.2\n"
"int22_GUCACUUA 2.2\n"
"int22_GUCACUUG 2.2\n"
"int22_GUCAGAGU 1.3\n"
"int22_GUCAGAUA 1.5\n"
"int22_GUCAGAUG 1.5\n"
"int22_GUCAGCGU 2.0\n"
"int22_GUCAGCUA 2.0\n"
"int22_GUCAGCUG 2.0\n"
"int22_GUCAGGGU 1.8\n"
"int22_GUCAGGUA 1.9\n"
"int22_GUCAGGUG 1.9\n"
"int22_GUCAGUGU 1.1\n"
"int22_GUCAGUUA 1.0\n"
"int22_GUCAGUUG 1.0\n"
"int22_GUCAUAGU 2.0\n"
"int22_GUCAUAUA 2.0\n"
"int22_GUCAUAUG 2.0\n"
"int22_GUCAUCGU 2.2\n"
"int22_GUCAUCUA 2.5\n"
"int22_GUCAUCUG 2.5\n"
"int22_GUCAUGGU 0.1\n"
"int22_GUCAUGUA -0.3\n"
"int22_GUCAUGUG -0.3\n"
"int22_GUCAUUGU 1.4\n"
"int22_GUCAUUUA 1.7\n"
"int22_GUCAUUUG 1.7\n"
"int22_GUCCAAUA 3.1\n"
"int22_GUCCAAUG 3.1\n"
"int22_GUCCACUA 2.5\n"
"int22_GUCCACUG 2.5\n"
"int22_GUCCAGUA 2.4\n"
"int22_GUCCAGUG 2.4\n"
"int22_GUCCAUUA 2.0\n"
"int22_GUCCAUUG 2.0\n"
"int22_GUCCCAUA 2.0\n"
"int22_GUCCCAUG 2.0\n"
"int22_GUCCCCGU 2.2\n"
"int22_GUCCCCUA 2.5\n"
"int22_GUCCCCUG 2.5\n"
"int22_GUCCCGGU 2.0\n"
"int22_GUCCCGUA 2.0\n"
"int22_GUCCCGUG 2.0\n"
"int22_GUCCCUGU 2.2\n"
"int22_GUCCCUUA 2.2\n"
"int22_GUCCCUUG 2.2\n"
"int22_GUCCGAGU 2.2\n"
"int22_GUCCGAUA 2.4\n"
"int22_GUCCGAUG 2.4\n"
"int22_GUCCGCGU 2.0\n"
"int22_GUCCGCUA 2.0\n"
"int22_GUCCGCUG 2.0\n"
"int22_GUCCGGGU 2.4\n"
"int22_GUCCGGUA 2.4\n"
"int22_GUCCGGUG 2.4\n"
"int22_GUCCGUGU 2.0\n"
"int22_GUCCGUUA 1.9\n"
"int22_GUCCGUUG 1.9\n"
"int22_GUCCUAGU 2.0\n"
"int22_GUCCUAUA 2.0\n"
"int22_GUCCUAUG 2.0\n"
"int22_GUCCUCGU 2.2\n"
"int22_GUCCUCUA 2.5\n"
"int22_GUCCUCUG 2.5\n"
"int22_GUCCUGGU 1.0\n"
"int22_GUCCUGUA 0.7\n"
"int22_GUCCUGUG 0.7\n"
"int22_GUCCUUGU 1.4\n"
"int22_GUCCUUUA 1.6\n"
"int22_GUCCUUUG 1.6\n"
"int22_GUCGAAUA 2.0\n"
"int22_GUCGAAUG 2.0\n"
"int22_GUCGACUA 2.0\n"
"int22_GUCGACUG 2.0\n"
"int22_GUCGAGUA 2.0\n"
"int22_GUCGAGUG 2.0\n"
"int22_GUCGAUUA 2.0\n"
"int22_GUCGAUUG 2.0\n"
"int22_GUCGCAUA 2.0\n"
"int22_GUCGCAUG 2.0\n"
"int22_GUCGCCUA 2.0\n"
"int22_GUCGCCUG 2.0\n"
"int22_GUCGCGGU 2.0\n"
"int22_GUCGCGUA 2.0\n"
"int22_GUCGCGUG 2.0\n"
"int22_GUCGCUGU 2.0\n"
"int22_GUCGCUUA 2.0\n"
"int22_GUCGCUUG 2.0\n"
"int22_GUCGGAGU 2.0\n"
"int22_GUCGGAUA 2.0\n"
"int22_GUCGGAUG 2.0\n"
"int22_GUCGGCGU 2.0\n"
"int22_GUCGGCUA 2.0\n"
"int22_GUCGGCUG 2.0\n"
"int22_GUCGGGGU 2.0\n"
"int22_GUCGGGUA 2.0\n"
"int22_GUCGGGUG 2.0\n"
"int22_GUCGGUGU 2.0\n"
"int22_GUCGGUUA 2.0\n"
"int22_GUCGGUUG 2.0\n"
"int22_GUCGUAGU 2.0\n"
"int22_GUCGUAUA 2.0\n"
"int22_GUCGUAUG 2.0\n"
"int22_GUCGUCGU 2.0\n"
"int22_GUCGUCUA 2.0\n"
"int22_GUCGUCUG 2.0\n"
"int22_GUCGUGGU 2.0\n"
"int22_GUCGUGUA 2.0\n"
"int22_GUCGUGUG 2.0\n"
"int22_GUCGUUGU 2.0\n"
"int22_GUCGUUUA 2.0\n"
"int22_GUCGUUUG 2.0\n"
"int22_GUCUAAUA 3.1\n"
"int22_GUCUAAUG 3.1\n"
"int22_GUCUACUA 2.5\n"
"int22_GUCUACUG 2.5\n"
"int22_GUCUAGUA 2.4\n"
"int22_GUCUAGUG 2.4\n"
"int22_GUCUAUUA 2.0\n"
"int22_GUCUAUUG 2.0\n"
"int22_GUCUCAUA 2.0\n"
"int22_GUCUCAUG 2.0\n"
"int22_GUCUCCUA 2.5\n"
"int22_GUCUCCUG 2.5\n"
"int22_GUCUCGUA 2.0\n"
"int22_GUCUCGUG 2.0\n"
"int22_GUCUCUGU 2.2\n"
"int22_GUCUCUUA 2.2\n"
"int22_GUCUCUUG 2.2\n"
"int22_GUCUGAGU 2.2\n"
"int22_GUCUGAUA 2.4\n"
"int22_GUCUGAUG 2.4\n"
"int22_GUCUGCGU 2.0\n"
"int22_GUCUGCUA 2.0\n"
"int22_GUCUGCUG 2.0\n"
"int22_GUCUGGGU 2.4\n"
"int22_GUCUGGUA 2.4\n"
"int22_GUCUGGUG 2.4\n"
"int22_GUCUGUGU 2.0\n"
"int22_GUCUGUUA 1.9\n"
"int22_GUCUGUUG 1.9\n"
"int22_GUCUUAGU 2.0\n"
"int22_GUCUUAUA 2.0\n"
"int22_GUCUUAUG 2.0\n"
"int22_GUCUUCGU 2.2\n"
"int22_GUCUUCUA 2.5\n"
"int22_GUCUUCUG 2.5\n"
"int22_GUCUUGGU 1.0\n"
"int22_GUCUUGUA 0.7\n"
"int22_GUCUUGUG 0.7\n"
"int22_GUCUUUGU 1.4\n"
"int22_GUCUUUUA 1.6\n"
"int22_GUCUUUUG 1.6\n"
"int22_GUGAAAUA 1.5\n"
"int22_GUGAAAUG 1.5\n"
"int22_GUGAACUA 1.5\n"
"int22_GUGAACUG 1.5\n"
"int22_GUGAAGUA 0.5\n"
"int22_GUGAAGUG 0.5\n"
"int22_GUGAAUUA 2.0\n"
"int22_GUGAAUUG 2.0\n"
"int22_GUGACAUA 1.1\n"
"int22_GUGACAUG 1.1\n"
"int22_GUGACCUA 2.5\n"
"int22_GUGACCUG 2.5\n"
"int22_GUGACGUA 2.0\n"
"int22_GUGACGUG 2.0\n"
"int22_GUGACUUA 2.2\n"
"int22_GUGACUUG 2.2\n"
"int22_GUGAGAGU 0.3\n"
"int22_GUGAGAUA 0.5\n"
"int22_GUGAGAUG 0.5\n"
"int22_GUGAGCGU 2.0\n"
"int22_GUGAGCUA 2.0\n"
"int22_GUGAGCUG 2.0\n"
"int22_GUGAGGGU 0.8\n"
"int22_GUGAGGUA 0.9\n"
"int22_GUGAGGUG 0.9\n"
"int22_GUGAGUGU 1.9\n"
"int22_GUGAGUUA 1.8\n"
"int22_GUGAGUUG 1.8\n"
"int22_GUGAUAGU 2.0\n"
"int22_GUGAUAUA 2.0\n"
"int22_GUGAUAUG 2.0\n"
"int22_GUGAUCGU 2.2\n"
"int22_GUGAUCUA 2.5\n"
"int22_GUGAUCUG 2.5\n"
"int22_GUGAUGGU 0.9\n"
"int22_GUGAUGUA 0.5\n"
"int22_GUGAUGUG 0.5\n"
"int22_GUGAUUGU 2.2\n"
"int22_GUGAUUUA 2.5\n"
"int22_GUGAUUUG 2.5\n"
"int22_GUGCAAUA 2.0\n"
"int22_GUGCAAUG 2.0\n"
"int22_GUGCACUA 2.0\n"
"int22_GUGCACUG 2.0\n"
"int22_GUGCAGUA 2.0\n"
"int22_GUGCAGUG 2.0\n"
"int22_GUGCAUUA 2.0\n"
"int22_GUGCAUUG 2.0\n"
"int22_GUGCCAUA 2.0\n"
"int22_GUGCCAUG 2.0\n"
"int22_GUGCCCUA 2.0\n"
"int22_GUGCCCUG 2.0\n"
"int22_GUGCCGUA 2.0\n"
"int22_GUGCCGUG 2.0\n"
"int22_GUGCCUUA 2.0\n"
"int22_GUGCCUUG 2.0\n"
"int22_GUGCGAUA 2.0\n"
"int22_GUGCGAUG 2.0\n"
"int22_GUGCGCGU 2.0\n"
"int22_GUGCGCUA 2.0\n"
"int22_GUGCGCUG 2.0\n"
"int22_GUGCGGGU 2.0\n"
"int22_GUGCGGUA 2.0\n"
"int22_GUGCGGUG 2.0\n"
"int22_GUGCGUGU 2.0\n"
"int22_GUGCGUUA 2.0\n"
"int22_GUGCGUUG 2.0\n"
"int22_GUGCUAGU 2.0\n"
"int22_GUGCUAUA 2.0\n"
"int22_GUGCUAUG 2.0\n"
"int22_GUGCUCGU 2.0\n"
"int22_GUGCUCUA 2.0\n"
"int22_GUGCUCUG 2.0\n"
"int22_GUGCUGGU 2.0\n"
"int22_GUGCUGUA 2.0\n"
"int22_GUGCUGUG 2.0\n"
"int22_GUGCUUGU 2.0\n"
"int22_GUGCUUUA 2.0\n"
"int22_GUGCUUUG 2.0\n"
"int22_GUGGAAUA 2.1\n"
"int22_GUGGAAUG 2.1\n"
"int22_GUGGACUA 2.1\n"
"int22_GUGGACUG 2.1\n"
"int22_GUGGAGUA 1.0\n"
"int22_GUGGAGUG 1.0\n"
"int22_GUGGAUUA 2.0\n"
"int22_GUGGAUUG 2.0\n"
"int22_GUGGCAUA 1.6\n"
"int22_GUGGCAUG 1.6\n"
"int22_GUGGCCUA 2.7\n"
"int22_GUGGCCUG 2.7\n"
"int22_GUGGCGUA 2.0\n"
"int22_GUGGCGUG 2.0\n"
"int22_GUGGCUUA 2.4\n"
"int22_GUGGCUUG 2.4\n"
"int22_GUGGGAUA 1.0\n"
"int22_GUGGGAUG 1.0\n"
"int22_GUGGGCUA 2.0\n"
"int22_GUGGGCUG 2.0\n"
"int22_GUGGGGGU 1.4\n"
"int22_GUGGGGUA 1.4\n"
"int22_GUGGGGUG 1.4\n"
"int22_GUGGGUGU 1.6\n"
"int22_GUGGGUUA 1.5\n"
"int22_GUGGGUUG 1.5\n"
"int22_GUGGUAGU 2.0\n"
"int22_GUGGUAUA 2.0\n"
"int22_GUGGUAUG 2.0\n"
"int22_GUGGUCGU 2.4\n"
"int22_GUGGUCUA 2.7\n"
"int22_GUGGUCUG 2.7\n"
"int22_GUGGUGGU 0.7\n"
"int22_GUGGUGUA 0.3\n"
"int22_GUGGUGUG 0.3\n"
"int22_GUGGUUGU 2.0\n"
"int22_GUGGUUUA 2.2\n"
"int22_GUGGUUUG 2.2\n"
"int22_GUGUAAUA 2.3\n"
"int22_GUGUAAUG 2.3\n"
"int22_GUGUACUA 1.3\n"
"int22_GUGUACUG 1.3\n"
"int22_GUGUAGUA 2.1\n"
"int22_GUGUAGUG 2.1\n"
"int22_GUGUAUUA 2.0\n"
"int22_GUGUAUUG 2.0\n"
"int22_GUGUCAUA 0.9\n"
"int22_GUGUCAUG 0.9\n"
"int22_GUGUCCUA 2.3\n"
"int22_GUGUCCUG 2.3\n"
"int22_GUGUCGUA 2.0\n"
"int22_GUGUCGUG 2.0\n"
"int22_GUGUCUUA 2.0\n"
"int22_GUGUCUUG 2.0\n"
"int22_GUGUGAUA 2.1\n"
"int22_GUGUGAUG 2.1\n"
"int22_GUGUGCUA 2.0\n"
"int22_GUGUGCUG 2.0\n"
"int22_GUGUGGUA 1.7\n"
"int22_GUGUGGUG 1.7\n"
"int22_GUGUGUGU -0.1\n"
"int22_GUGUGUUA -0.2\n"
"int22_GUGUGUUG -0.2\n"
"int22_GUGUUAGU 2.0\n"
"int22_GUGUUAUA 2.0\n"
"int22_GUGUUAUG 2.0\n"
"int22_GUGUUCGU 2.0\n"
"int22_GUGUUCUA 2.3\n"
"int22_GUGUUCUG 2.3\n"
"int22_GUGUUGGU -1.1\n"
"int22_GUGUUGUA -1.5\n"
"int22_GUGUUGUG -1.5\n"
"int22_GUGUUUGU 2.0\n"
"int22_GUGUUUUA 2.3\n"
"int22_GUGUUUUG 2.3\n"
"int22_GUUAAAUA 2.0\n"
"int22_GUUAAAUG 2.0\n"
"int22_GUUAACUA 2.0\n"
"int22_GUUAACUG 2.0\n"
"int22_GUUAAGUA 2.0\n"
"int22_GUUAAGUG 2.0\n"
"int22_GUUAAUUA 2.0\n"
"int22_GUUAAUUG 2.0\n"
"int22_GUUACAUA 2.0\n"
"int22_GUUACAUG 2.0\n"
"int22_GUUACCUA 2.0\n"
"int22_GUUACCUG 2.0\n"
"int22_GUUACGUA 2.0\n"
"int22_GUUACGUG 2.0\n"
"int22_GUUACUUA 2.0\n"
"int22_GUUACUUG 2.0\n"
"int22_GUUAGAUA 2.0\n"
"int22_GUUAGAUG 2.0\n"
"int22_GUUAGCUA 2.0\n"
"int22_GUUAGCUG 2.0\n"
"int22_GUUAGGUA 2.0\n"
"int22_GUUAGGUG 2.0\n"
"int22_GUUAGUUA 2.0\n"
"int22_GUUAGUUG 2.0\n"
"int22_GUUAUAGU 2.0\n"
"int22_GUUAUAUA 2.0\n"
"int22_GUUAUAUG 2.0\n"
"int22_GUUAUCGU 2.0\n"
"int22_GUUAUCUA 2.0\n"
"int22_GUUAUCUG 2.0\n"
"int22_GUUAUGGU 2.0\n"
"int22_GUUAUGUA 2.0\n"
"int22_GUUAUGUG 2.0\n"
"int22_GUUAUUGU 2.0\n"
"int22_GUUAUUUA 2.0\n"
"int22_GUUAUUUG 2.0\n"
"int22_GUUCAAUA 3.1\n"
"int22_GUUCAAUG 3.1\n"
"int22_GUUCACUA 2.5\n"
"int22_GUUCACUG 2.5\n"
"int22_GUUCAGUA 2.4\n"
"int22_GUUCAGUG 2.4\n"
"int22_GUUCAUUA 2.0\n"
"int22_GUUCAUUG 2.0\n"
"int22_GUUCCAUA 2.0\n"
"int22_GUUCCAUG 2.0\n"
"int22_GUUCCCUA 2.5\n"
"int22_GUUCCCUG 2.5\n"
"int22_GUUCCGUA 2.0\n"
"int22_GUUCCGUG 2.0\n"
"int22_GUUCCUUA 2.2\n"
"int22_GUUCCUUG 2.2\n"
"int22_GUUCGAUA 2.4\n"
"int22_GUUCGAUG 2.4\n"
"int22_GUUCGCUA 2.0\n"
"int22_GUUCGCUG 2.0\n"
"int22_GUUCGGUA 2.4\n"
"int22_GUUCGGUG 2.4\n"
"int22_GUUCGUUA 1.9\n"
"int22_GUUCGUUG 1.9\n"
"int22_GUUCUAUA 2.0\n"
"int22_GUUCUAUG 2.0\n"
"int22_GUUCUCGU 2.2\n"
"int22_GUUCUCUA 2.5\n"
"int22_GUUCUCUG 2.5\n"
"int22_GUUCUGGU 1.0\n"
"int22_GUUCUGUA 0.7\n"
"int22_GUUCUGUG 0.7\n"
"int22_GUUCUUGU 1.4\n"
"int22_GUUCUUUA 1.6\n"
"int22_GUUCUUUG 1.6\n"
"int22_GUUGAAUA 1.3\n"
"int22_GUUGAAUG 1.3\n"
"int22_GUUGACUA 0.3\n"
"int22_GUUGACUG 0.3\n"
"int22_GUUGAGUA 1.1\n"
"int22_GUUGAGUG 1.1\n"
"int22_GUUGAUUA 2.0\n"
"int22_GUUGAUUG 2.0\n"
"int22_GUUGCAUA -0.1\n"
"int22_GUUGCAUG -0.1\n"
"int22_GUUGCCUA 1.3\n"
"int22_GUUGCCUG 1.3\n"
"int22_GUUGCGUA 2.0\n"
"int22_GUUGCGUG 2.0\n"
"int22_GUUGCUUA 1.0\n"
"int22_GUUGCUUG 1.0\n"
"int22_GUUGGAUA 1.1\n"
"int22_GUUGGAUG 1.1\n"
"int22_GUUGGCUA 2.0\n"
"int22_GUUGGCUG 2.0\n"
"int22_GUUGGGUA 0.7\n"
"int22_GUUGGGUG 0.7\n"
"int22_GUUGGUUA -1.2\n"
"int22_GUUGGUUG -1.2\n"
"int22_GUUGUAUA 2.0\n"
"int22_GUUGUAUG 2.0\n"
"int22_GUUGUCUA 1.3\n"
"int22_GUUGUCUG 1.3\n"
"int22_GUUGUGGU -2.1\n"
"int22_GUUGUGUA -2.5\n"
"int22_GUUGUGUG -2.5\n"
"int22_GUUGUUGU 1.1\n"
"int22_GUUGUUUA 1.3\n"
"int22_GUUGUUUG 1.3\n"
"int22_GUUUAAUA 2.7\n"
"int22_GUUUAAUG 2.7\n"
"int22_GUUUACUA 1.7\n"
"int22_GUUUACUG 1.7\n"
"int22_GUUUAGUA 2.4\n"
"int22_GUUUAGUG 2.4\n"
"int22_GUUUAUUA 2.0\n"
"int22_GUUUAUUG 2.0\n"
"int22_GUUUCAUA 1.2\n"
"int22_GUUUCAUG 1.2\n"
"int22_GUUUCCUA 1.7\n"
"int22_GUUUCCUG 1.7\n"
"int22_GUUUCGUA 2.0\n"
"int22_GUUUCGUG 2.0\n"
"int22_GUUUCUUA 1.4\n"
"int22_GUUUCUUG 1.4\n"
"int22_GUUUGAUA 2.4\n"
"int22_GUUUGAUG 2.4\n"
"int22_GUUUGCUA 2.0\n"
"int22_GUUUGCUG 2.0\n"
"int22_GUUUGGUA 2.0\n"
"int22_GUUUGGUG 2.0\n"
"int22_GUUUGUUA 1.9\n"
"int22_GUUUGUUG 1.9\n"
"int22_GUUUUAUA 2.0\n"
"int22_GUUUUAUG 2.0\n"
"int22_GUUUUCUA 1.7\n"
"int22_GUUUUCUG 1.7\n"
"int22_GUUUUGUA 0.7\n"
"int22_GUUUUGUG 0.7\n"
"int22_GUUUUUGU 0.6\n"
"int22_GUUUUUUA 0.8\n"
"int22_GUUUUUUG 0.8\n"
"int22_UAAAAAUA 2.8\n"
"int22_UAAAAAUG 2.8\n"
"int22_UAAAACUA 2.8\n"
"int22_UAAAACUG 2.8\n"
"int22_UAAAAGUA 1.7\n"
"int22_UAAAAGUG 1.7\n"
"int22_UAAAAUUA 2.0\n"
"int22_UAAAAUUG 2.0\n"
"int22_UAAACAUA 2.3\n"
"int22_UAAACAUG 2.3\n"
"int22_UAAACCUA 3.4\n"
"int22_UAAACCUG 3.4\n"
"int22_UAAACGUA 2.0\n"
"int22_UAAACGUG 2.0\n"
"int22_UAAACUUA 3.1\n"
"int22_UAAACUUG 3.1\n"
"int22_UAAAGAUA 1.7\n"
"int22_UAAAGAUG 1.7\n"
"int22_UAAAGCUA 2.0\n"
"int22_UAAAGCUG 2.0\n"
"int22_UAAAGGUA 2.1\n"
"int22_UAAAGGUG 2.1\n"
"int22_UAAAGUUA 2.2\n"
"int22_UAAAGUUG 2.2\n"
"int22_UAAAUAUA 2.0\n"
"int22_UAAAUAUG 2.0\n"
"int22_UAAAUCUA 3.4\n"
"int22_UAAAUCUG 3.4\n"
"int22_UAAAUGUA 1.0\n"
"int22_UAAAUGUG 1.0\n"
"int22_UAAAUUUA 2.9\n"
"int22_UAAAUUUG 2.9\n"
"int22_UAACAAUG 2.8\n"
"int22_UAACACUA 2.8\n"
"int22_UAACACUG 2.8\n"
"int22_UAACAGUA 1.7\n"
"int22_UAACAGUG 1.7\n"
"int22_UAACAUUA 2.0\n"
"int22_UAACAUUG 2.0\n"
"int22_UAACCAUA 2.3\n"
"int22_UAACCAUG 2.3\n"
"int22_UAACCCUA 2.8\n"
"int22_UAACCCUG 2.8\n"
"int22_UAACCGUA 2.0\n"
"int22_UAACCGUG 2.0\n"
"int22_UAACCUUA 2.5\n"
"int22_UAACCUUG 2.5\n"
"int22_UAACGAUA 1.7\n"
"int22_UAACGAUG 1.7\n"
"int22_UAACGCUA 2.0\n"
"int22_UAACGCUG 2.0\n"
"int22_UAACGGUA 2.1\n"
"int22_UAACGGUG 2.1\n"
"int22_UAACGUUA 1.2\n"
"int22_UAACGUUG 1.2\n"
"int22_UAACUAUA 2.0\n"
"int22_UAACUAUG 2.0\n"
"int22_UAACUCUA 2.8\n"
"int22_UAACUCUG 2.8\n"
"int22_UAACUGUA 0.0\n"
"int22_UAACUGUG 0.0\n"
"int22_UAACUUUA 1.9\n"
"int22_UAACUUUG 1.9\n"
"int22_UAAGAAUG 1.7\n"
"int22_UAAGACUG 1.7\n"
"int22_UAAGAGUA 0.7\n"
"int22_UAAGAGUG 0.7\n"
"int22_UAAGAUUA 2.0\n"
"int22_UAAGAUUG 2.0\n"
"int22_UAAGCAUA 1.3\n"
"int22_UAAGCAUG 1.3\n"
"int22_UAAGCCUA 2.7\n"
"int22_UAAGCCUG 2.7\n"
"int22_UAAGCGUA 2.0\n"
"int22_UAAGCGUG 2.0\n"
"int22_UAAGCUUA 2.4\n"
"int22_UAAGCUUG 2.4\n"
"int22_UAAGGAUA 0.7\n"
"int22_UAAGGAUG 0.7\n"
"int22_UAAGGCUA 2.0\n"
"int22_UAAGGCUG 2.0\n"
"int22_UAAGGGUA 1.1\n"
"int22_UAAGGGUG 1.1\n"
"int22_UAAGGUUA 2.0\n"
"int22_UAAGGUUG 2.0\n"
"int22_UAAGUAUA 2.0\n"
"int22_UAAGUAUG 2.0\n"
"int22_UAAGUCUA 2.7\n"
"int22_UAAGUCUG 2.7\n"
"int22_UAAGUGUA 0.7\n"
"int22_UAAGUGUG 0.7\n"
"int22_UAAGUUUA 2.7\n"
"int22_UAAGUUUG 2.7\n"
"int22_UAAUAAUG 2.0\n"
"int22_UAAUACUG 2.0\n"
"int22_UAAUAGUG 2.0\n"
"int22_UAAUAUUA 2.0\n"
"int22_UAAUAUUG 2.0\n"
"int22_UAAUCAUA 2.0\n"
"int22_UAAUCAUG 2.0\n"
"int22_UAAUCCUA 2.0\n"
"int22_UAAUCCUG 2.0\n"
"int22_UAAUCGUA 2.0\n"
"int22_UAAUCGUG 2.0\n"
"int22_UAAUCUUA 2.0\n"
"int22_UAAUCUUG 2.0\n"
"int22_UAAUGAUA 2.0\n"
"int22_UAAUGAUG 2.0\n"
"int22_UAAUGCUA 2.0\n"
"int22_UAAUGCUG 2.0\n"
"int22_UAAUGGUA 2.0\n"
"int22_UAAUGGUG 2.0\n"
"int22_UAAUGUUA 2.0\n"
"int22_UAAUGUUG 2.0\n"
"int22_UAAUUAUA 2.0\n"
"int22_UAAUUAUG 2.0\n"
"int22_UAAUUCUA 2.0\n"
"int22_UAAUUCUG 2.0\n"
"int22_UAAUUGUA 2.0\n"
"int22_UAAUUGUG 2.0\n"
"int22_UAAUUUUA 2.0\n"
"int22_UAAUUUUG 2.0\n"
"int22_UACAAAUG 2.3\n"
"int22_UACAACUG 2.3\n"
"int22_UACAAGUG 1.3\n"
"int22_UACAAUUG 2.0\n"
"int22_UACACAUA 1.9\n"
"int22_UACACAUG 1.9\n"
"int22_UACACCUA 2.3\n"
"int22_UACACCUG 2.3\n"
"int22_UACACGUA 2.0\n"
"int22_UACACGUG 2.0\n"
"int22_UACACUUA 2.0\n"
"int22_UACACUUG 2.0\n"
"int22_UACAGAUA 1.3\n"
"int22_UACAGAUG 1.3\n"
"int22_UACAGCUA 2.0\n"
"int22_UACAGCUG 2.0\n"
"int22_UACAGGUA 1.7\n"
"int22_UACAGGUG 1.7\n"
"int22_UACAGUUA 0.8\n"
"int22_UACAGUUG 0.8\n"
"int22_UACAUAUA 2.0\n"
"int22_UACAUAUG 2.0\n"
"int22_UACAUCUA 2.3\n"
"int22_UACAUCUG 2.3\n"
"int22_UACAUGUA -0.5\n"
"int22_UACAUGUG -0.5\n"
"int22_UACAUUUA 1.5\n"
"int22_UACAUUUG 1.5\n"
"int22_UACCAAUG 3.4\n"
"int22_UACCACUG 2.8\n"
"int22_UACCAGUG 2.7\n"
"int22_UACCAUUG 2.0\n"
"int22_UACCCAUG 2.3\n"
"int22_UACCCCUA 2.8\n"
"int22_UACCCCUG 2.8\n"
"int22_UACCCGUA 2.0\n"
"int22_UACCCGUG 2.0\n"
"int22_UACCCUUA 2.5\n"
"int22_UACCCUUG 2.5\n"
"int22_UACCGAUA 2.7\n"
"int22_UACCGAUG 2.7\n"
"int22_UACCGCUA 2.0\n"
"int22_UACCGCUG 2.0\n"
"int22_UACCGGUA 2.7\n"
"int22_UACCGGUG 2.7\n"
"int22_UACCGUUA 2.2\n"
"int22_UACCGUUG 2.2\n"
"int22_UACCUAUA 2.0\n"
"int22_UACCUAUG 2.0\n"
"int22_UACCUCUA 2.8\n"
"int22_UACCUCUG 2.8\n"
"int22_UACCUGUA 1.0\n"
"int22_UACCUGUG 1.0\n"
"int22_UACCUUUA 1.9\n"
"int22_UACCUUUG 1.9\n"
"int22_UACGAAUG 2.0\n"
"int22_UACGACUG 2.0\n"
"int22_UACGAGUG 2.0\n"
"int22_UACGAUUG 2.0\n"
"int22_UACGCAUG 2.0\n"
"int22_UACGCCUG 2.0\n"
"int22_UACGCGUA 2.0\n"
"int22_UACGCGUG 2.0\n"
"int22_UACGCUUA 2.0\n"
"int22_UACGCUUG 2.0\n"
"int22_UACGGAUA 2.0\n"
"int22_UACGGAUG 2.0\n"
"int22_UACGGCUA 2.0\n"
"int22_UACGGCUG 2.0\n"
"int22_UACGGGUA 2.0\n"
"int22_UACGGGUG 2.0\n"
"int22_UACGGUUA 2.0\n"
"int22_UACGGUUG 2.0\n"
"int22_UACGUAUA 2.0\n"
"int22_UACGUAUG 2.0\n"
"int22_UACGUCUA 2.0\n"
"int22_UACGUCUG 2.0\n"
"int22_UACGUGUA 2.0\n"
"int22_UACGUGUG 2.0\n"
"int22_UACGUUUA 2.0\n"
"int22_UACGUUUG 2.0\n"
"int22_UACUAAUG 3.1\n"
"int22_UACUACUG 2.5\n"
"int22_UACUAGUG 2.4\n"
"int22_UACUAUUG 2.0\n"
"int22_UACUCAUG 2.0\n"
"int22_UACUCCUG 2.5\n"
"int22_UACUCGUG 2.0\n"
"int22_UACUCUUA 2.2\n"
"int22_UACUCUUG 2.2\n"
"int22_UACUGAUA 2.4\n"
"int22_UACUGAUG 2.4\n"
"int22_UACUGCUA 2.0\n"
"int22_UACUGCUG 2.0\n"
"int22_UACUGGUA 2.4\n"
"int22_UACUGGUG 2.4\n"
"int22_UACUGUUA 1.9\n"
"int22_UACUGUUG 1.9\n"
"int22_UACUUAUA 2.0\n"
"int22_UACUUAUG 2.0\n"
"int22_UACUUCUA 2.5\n"
"int22_UACUUCUG 2.5\n"
"int22_UACUUGUA 0.7\n"
"int22_UACUUGUG 0.7\n"
"int22_UACUUUUA 1.6\n"
"int22_UACUUUUG 1.6\n"
"int22_UAGAAAUG 1.7\n"
"int22_UAGAACUG 1.7\n"
"int22_UAGAAGUG 0.7\n"
"int22_UAGAAUUG 2.0\n"
"int22_UAGACAUG 1.3\n"
"int22_UAGACCUG 2.7\n"
"int22_UAGACGUG 2.0\n"
"int22_UAGACUUG 2.4\n"
"int22_UAGAGAUA 0.7\n"
"int22_UAGAGAUG 0.7\n"
"int22_UAGAGCUA 2.0\n"
"int22_UAGAGCUG 2.0\n"
"int22_UAGAGGUA 1.1\n"
"int22_UAGAGGUG 1.1\n"
"int22_UAGAGUUA 2.0\n"
"int22_UAGAGUUG 2.0\n"
"int22_UAGAUAUA 2.0\n"
"int22_UAGAUAUG 2.0\n"
"int22_UAGAUCUA 2.7\n"
"int22_UAGAUCUG 2.7\n"
"int22_UAGAUGUA 0.7\n"
"int22_UAGAUGUG 0.7\n"
"int22_UAGAUUUA 2.7\n"
"int22_UAGAUUUG 2.7\n"
"int22_UAGCAAUG 2.0\n"
"int22_UAGCACUG 2.0\n"
"int22_UAGCAGUG 2.0\n"
"int22_UAGCAUUG 2.0\n"
"int22_UAGCCAUG 2.0\n"
"int22_UAGCCCUG 2.0\n"
"int22_UAGCCGUG 2.0\n"
"int22_UAGCCUUG 2.0\n"
"int22_UAGCGAUG 2.0\n"
"int22_UAGCGCUA 2.0\n"
"int22_UAGCGCUG 2.0\n"
"int22_UAGCGGUA 2.0\n"
"int22_UAGCGGUG 2.0\n"
"int22_UAGCGUUA 2.0\n"
"int22_UAGCGUUG 2.0\n"
"int22_UAGCUAUA 2.0\n"
"int22_UAGCUAUG 2.0\n"
"int22_UAGCUCUA 2.0\n"
"int22_UAGCUCUG 2.0\n"
"int22_UAGCUGUA 2.0\n"
"int22_UAGCUGUG 2.0\n"
"int22_UAGCUUUA 2.0\n"
"int22_UAGCUUUG 2.0\n"
"int22_UAGGAAUG 2.1\n"
"int22_UAGGACUG 2.1\n"
"int22_UAGGAGUG 1.1\n"
"int22_UAGGAUUG 2.0\n"
"int22_UAGGCAUG 1.7\n"
"int22_UAGGCCUG 2.7\n"
"int22_UAGGCGUG 2.0\n"
"int22_UAGGCUUG 2.4\n"
"int22_UAGGGAUG 1.1\n"
"int22_UAGGGCUG 2.0\n"
"int22_UAGGGGUA 1.5\n"
"int22_UAGGGGUG 1.5\n"
"int22_UAGGGUUA 1.6\n"
"int22_UAGGGUUG 1.6\n"
"int22_UAGGUAUA 2.0\n"
"int22_UAGGUAUG 2.0\n"
"int22_UAGGUCUA 2.7\n"
"int22_UAGGUCUG 2.7\n"
"int22_UAGGUGUA 0.3\n"
"int22_UAGGUGUG 0.3\n"
"int22_UAGGUUUA 2.3\n"
"int22_UAGGUUUG 2.3\n"
"int22_UAGUAAUG 2.2\n"
"int22_UAGUACUG 1.2\n"
"int22_UAGUAGUG 2.0\n"
"int22_UAGUAUUG 2.0\n"
"int22_UAGUCAUG 0.8\n"
"int22_UAGUCCUG 2.2\n"
"int22_UAGUCGUG 2.0\n"
"int22_UAGUCUUG 1.9\n"
"int22_UAGUGAUG 2.0\n"
"int22_UAGUGCUG 2.0\n"
"int22_UAGUGGUG 1.6\n"
"int22_UAGUGUUA -0.3\n"
"int22_UAGUGUUG -0.3\n"
"int22_UAGUUAUA 2.0\n"
"int22_UAGUUAUG 2.0\n"
"int22_UAGUUCUA 2.2\n"
"int22_UAGUUCUG 2.2\n"
"int22_UAGUUGUA -1.6\n"
"int22_UAGUUGUG -1.6\n"
"int22_UAGUUUUA 2.2\n"
"int22_UAGUUUUG 2.2\n"
"int22_UAUAAAUG 2.0\n"
"int22_UAUAACUG 2.0\n"
"int22_UAUAAGUG 2.0\n"
"int22_UAUAAUUG 2.0\n"
"int22_UAUACAUG 2.0\n"
"int22_UAUACCUG 2.0\n"
"int22_UAUACGUG 2.0\n"
"int22_UAUACUUG 2.0\n"
"int22_UAUAGAUG 2.0\n"
"int22_UAUAGCUG 2.0\n"
"int22_UAUAGGUG 2.0\n"
"int22_UAUAGUUG 2.0\n"
"int22_UAUAUAUA 2.0\n"
"int22_UAUAUAUG 2.0\n"
"int22_UAUAUCUA 2.0\n"
"int22_UAUAUCUG 2.0\n"
"int22_UAUAUGUA 2.0\n"
"int22_UAUAUGUG 2.0\n"
"int22_UAUAUUUA 2.0\n"
"int22_UAUAUUUG 2.0\n"
"int22_UAUCAAUG 3.4\n"
"int22_UAUCACUG 2.8\n"
"int22_UAUCAGUG 2.7\n"
"int22_UAUCAUUG 2.0\n"
"int22_UAUCCAUG 2.3\n"
"int22_UAUCCCUG 2.8\n"
"int22_UAUCCGUG 2.0\n"
"int22_UAUCCUUG 2.5\n"
"int22_UAUCGAUG 2.7\n"
"int22_UAUCGCUG 2.0\n"
"int22_UAUCGGUG 2.7\n"
"int22_UAUCGUUG 2.2\n"
"int22_UAUCUAUG 2.0\n"
"int22_UAUCUCUA 2.8\n"
"int22_UAUCUCUG 2.8\n"
"int22_UAUCUGUA 1.0\n"
"int22_UAUCUGUG 1.0\n"
"int22_UAUCUUUA 1.9\n"
"int22_UAUCUUUG 1.9\n"
"int22_UAUGAAUG 1.0\n"
"int22_UAUGACUG 0.0\n"
"int22_UAUGAGUG 0.7\n"
"int22_UAUGAUUG 2.0\n"
"int22_UAUGCAUG -0.5\n"
"int22_UAUGCCUG 1.0\n"
"int22_UAUGCGUG 2.0\n"
"int22_UAUGCUUG 0.7\n"
"int22_UAUGGAUG 0.7\n"
"int22_UAUGGCUG 2.0\n"
"int22_UAUGGGUG 0.3\n"
"int22_UAUGGUUG -1.6\n"
"int22_UAUGUAUG 2.0\n"
"int22_UAUGUCUG 1.0\n"
"int22_UAUGUGUA -2.9\n"
"int22_UAUGUGUG -2.9\n"
"int22_UAUGUUUA 0.9\n"
"int22_UAUGUUUG 0.9\n"
"int22_UAUUAAUG 2.9\n"
"int22_UAUUACUG 1.9\n"
"int22_UAUUAGUG 2.7\n"
"int22_UAUUAUUG 2.0\n"
"int22_UAUUCAUG 1.5\n"
"int22_UAUUCCUG 1.9\n"
"int22_UAUUCGUG 2.0\n"
"int22_UAUUCUUG 1.6\n"
"int22_UAUUGAUG 2.7\n"
"int22_UAUUGCUG 2.0\n"
"int22_UAUUGGUG 2.3\n"
"int22_UAUUGUUG 2.2\n"
"int22_UAUUUAUG 2.0\n"
"int22_UAUUUCUG 1.9\n"
"int22_UAUUUGUG 0.9\n"
"int22_UAUUUUUA 1.1\n"
"int22_UAUUUUUG 1.1\n"
"int22_UGAAAAUG 2.8\n"
"int22_UGAAACUG 2.8\n"
"int22_UGAAAGUG 1.7\n"
"int22_UGAAAUUG 2.0\n"
"int22_UGAACAUG 2.3\n"
"int22_UGAACCUG 3.4\n"
"int22_UGAACGUG 2.0\n"
"int22_UGAACUUG 3.1\n"
"int22_UGAAGAUG 1.7\n"
"int22_UGAAGCUG 2.0\n"
"int22_UGAAGGUG 2.1\n"
"int22_UGAAGUUG 2.2\n"
"int22_UGAAUAUG 2.0\n"
"int22_UGAAUCUG 3.4\n"
"int22_UGAAUGUG 1.0\n"
"int22_UGAAUUUG 2.9\n"
"int22_UGACACUG 2.8\n"
"int22_UGACAGUG 1.7\n"
"int22_UGACAUUG 2.0\n"
"int22_UGACCAUG 2.3\n"
"int22_UGACCCUG 2.8\n"
"int22_UGACCGUG 2.0\n"
"int22_UGACCUUG 2.5\n"
"int22_UGACGAUG 1.7\n"
"int22_UGACGCUG 2.0\n"
"int22_UGACGGUG 2.1\n"
"int22_UGACGUUG 1.2\n"
"int22_UGACUAUG 2.0\n"
"int22_UGACUCUG 2.8\n"
"int22_UGACUGUG 0.0\n"
"int22_UGACUUUG 1.9\n"
"int22_UGAGAGUG 0.7\n"
"int22_UGAGAUUG 2.0\n"
"int22_UGAGCAUG 1.3\n"
"int22_UGAGCCUG 2.7\n"
"int22_UGAGCGUG 2.0\n"
"int22_UGAGCUUG 2.4\n"
"int22_UGAGGAUG 0.7\n"
"int22_UGAGGCUG 2.0\n"
"int22_UGAGGGUG 1.1\n"
"int22_UGAGGUUG 2.0\n"
"int22_UGAGUAUG 2.0\n"
"int22_UGAGUCUG 2.7\n"
"int22_UGAGUGUG 0.7\n"
"int22_UGAGUUUG 2.7\n"
"int22_UGAUAUUG 2.0\n"
"int22_UGAUCAUG 2.0\n"
"int22_UGAUCCUG 2.0\n"
"int22_UGAUCGUG 2.0\n"
"int22_UGAUCUUG 2.0\n"
"int22_UGAUGAUG 2.0\n"
"int22_UGAUGCUG 2.0\n"
"int22_UGAUGGUG 2.0\n"
"int22_UGAUGUUG 2.0\n"
"int22_UGAUUAUG 2.0\n"
"int22_UGAUUCUG 2.0\n"
"int22_UGAUUGUG 2.0\n"
"int22_UGAUUUUG 2.0\n"
"int22_UGCACAUG 1.9\n"
"int22_UGCACCUG 2.3\n"
"int22_UGCACGUG 2.0\n"
"int22_UGCACUUG 2.0\n"
"int22_UGCAGAUG 1.3\n"
"int22_UGCAGCUG 2.0\n"
"int22_UGCAGGUG 1.7\n"
"int22_UGCAGUUG 0.8\n"
"int22_UGCAUAUG 2.0\n"
"int22_UGCAUCUG 2.3\n"
"int22_UGCAUGUG -0.5\n"
"int22_UGCAUUUG 1.5\n"
"int22_UGCCCCUG 2.8\n"
"int22_UGCCCGUG 2.0\n"
"int22_UGCCCUUG 2.5\n"
"int22_UGCCGAUG 2.7\n"
"int22_UGCCGCUG 2.0\n"
"int22_UGCCGGUG 2.7\n"
"int22_UGCCGUUG 2.2\n"
"int22_UGCCUAUG 2.0\n"
"int22_UGCCUCUG 2.8\n"
"int22_UGCCUGUG 1.0\n"
"int22_UGCCUUUG 1.9\n"
"int22_UGCGCGUG 2.0\n"
"int22_UGCGCUUG 2.0\n"
"int22_UGCGGAUG 2.0\n"
"int22_UGCGGCUG 2.0\n"
"int22_UGCGGGUG 2.0\n"
"int22_UGCGGUUG 2.0\n"
"int22_UGCGUAUG 2.0\n"
"int22_UGCGUCUG 2.0\n"
"int22_UGCGUGUG 2.0\n"
"int22_UGCGUUUG 2.0\n"
"int22_UGCUCUUG 2.2\n"
"int22_UGCUGAUG 2.4\n"
"int22_UGCUGCUG 2.0\n"
"int22_UGCUGGUG 2.4\n"
"int22_UGCUGUUG 1.9\n"
"int22_UGCUUAUG 2.0\n"
"int22_UGCUUCUG 2.5\n"
"int22_UGCUUGUG 0.7\n"
"int22_UGCUUUUG 1.6\n"
"int22_UGGAGAUG 0.7\n"
"int22_UGGAGCUG 2.0\n"
"int22_UGGAGGUG 1.1\n"
"int22_UGGAGUUG 2.0\n"
"int22_UGGAUAUG 2.0\n"
"int22_UGGAUCUG 2.7\n"
"int22_UGGAUGUG 0.7\n"
"int22_UGGAUUUG 2.7\n"
"int22_UGGCGCUG 2.0\n"
"int22_UGGCGGUG 2.0\n"
"int22_UGGCGUUG 2.0\n"
"int22_UGGCUAUG 2.0\n"
"int22_UGGCUCUG 2.0\n"
"int22_UGGCUGUG 2.0\n"
"int22_UGGCUUUG 2.0\n"
"int22_UGGGGGUG 1.5\n"
"int22_UGGGGUUG 1.6\n"
"int22_UGGGUAUG 2.0\n"
"int22_UGGGUCUG 2.7\n"
"int22_UGGGUGUG 0.3\n"
"int22_UGGGUUUG 2.3\n"
"int22_UGGUGUUG -0.3\n"
"int22_UGGUUAUG 2.0\n"
"int22_UGGUUCUG 2.2\n"
"int22_UGGUUGUG -1.6\n"
"int22_UGGUUUUG 2.2\n"
"int22_UGUAUAUG 2.0\n"
"int22_UGUAUCUG 2.0\n"
"int22_UGUAUGUG 2.0\n"
"int22_UGUAUUUG 2.0\n"
"int22_UGUCUCUG 2.8\n"
"int22_UGUCUGUG 1.0\n"
"int22_UGUCUUUG 1.9\n"
"int22_UGUGUGUG -2.9\n"
"int22_UGUGUUUG 0.9\n"
"int22_UGUUUUUG 1.1\n"
"tetraloop_AUGAAA -2.0\n"
"tetraloop_AUGACA -1.5\n"
"tetraloop_AUGAUA -1.5\n"
"tetraloop_AUGAUG -1.5\n"
"tetraloop_CGGAAA -3.0\n"
"tetraloop_CGGAAG -2.0\n"
"tetraloop_CGGACA -3.0\n"
"tetraloop_CGGACG -2.5\n"
"tetraloop_CGGAGA -3.0\n"
"tetraloop_CGGAGG -1.5\n"
"tetraloop_CGGAUA -2.0\n"
"tetraloop_CGGAUG -3.0\n"
"tetraloop_CGGGAA -2.5\n"
"tetraloop_CGUCAA -2.0\n"
"tetraloop_CGUGAC -2.5\n"
"tetraloop_CGUGUC -3.0\n"
"tetraloop_GCGAAA -3.0\n"
"tetraloop_GCGAAG -3.0\n"
"tetraloop_GCGACA -2.5\n"
"tetraloop_GCGACG -1.5\n"
"tetraloop_GCGAGA -1.5\n"
"tetraloop_GCGAGG -3.0\n"
"tetraloop_GCGAUG -3.0\n"
"tetraloop_GCGGAA -1.5\n"
"tetraloop_GCGGGA -1.5\n"
"tetraloop_GCUAGA -1.5\n"
"tetraloop_UAGAAA -1.5\n"
"tetraloop_UAGAGA -1.5\n"
"tetraloop_UGGAAA -2.0\n"
"tetraloop_UGGAAG -2.5\n"
;
#endif
